% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uncertainty_estimation.R
\name{.compute_uncertainty}
\alias{.compute_uncertainty}
\title{Internal helper: compute uncertainty decomposition (epistemic / aleatoric / both)}
\usage{
.compute_uncertainty(model, x, uncertainty_method, alpha, forward_passes)
}
\arguments{
\item{model}{Fitted Keras model for a single smooth term.}

\item{x}{Input covariate matrix (or vector; will be reshaped as needed).}

\item{uncertainty_method}{Character; one of \code{"epistemic"}, \code{"aleatoric"}, \code{"both"}, or \code{"none"}.}

\item{alpha}{Coverage level (e.g. 0.05 for 95\% bands).}

\item{forward_passes}{Integer; number of MC Dropout passes.}
}
\value{
A \code{data.frame} with columns:
\itemize{
\item \code{lwr}, \code{upr}: lower/upper bounds of interval estimates.
\item \code{var_epistemic}: epistemic variance.
\item \code{var_aleatoric}: aleatoric variance.
\item \code{var_total}: total variance (epistemic + aleatoric).
}
}
\description{
Given a fitted Keras submodel and covariate input \code{x}, compute uncertainty
estimates according to the \code{uncertainty_method}.
\itemize{
\item \code{"epistemic"}: estimates only epistemic variance (via MC Dropout passes).
\item \code{"aleatoric"}: uses deterministic quantile heads to estimate aleatoric variance.
\item \code{"both"}: combines aleatoric and epistemic using variance decomposition.
\item Otherwise: returns \code{NA} placeholders.
}
}
\author{
Ines Ortega-Fernandez, Marta Sestelo
}
\keyword{internal}
