% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcdid.R
\name{pcdid}
\alias{pcdid}
\title{Principal Components Difference-in-Differences}
\usage{
pcdid(
  formula,
  index,
  data,
  alpha = FALSE,
  fproxy = NULL,
  stationary = FALSE,
  kmax = 10,
  nwlag = round(max(data[[index[2]]])^0.25)
)
}
\arguments{
\item{formula}{regression specification: depvar ~ treatvar + didvar + indepvar | residvar, where depvar is the dependent variable, treatvar is the binary treatment indicator (1 for treated unit(s) and 0 for control unit(s)), didvar is the interaction term of treatvar and post-treatment time indicator, indepvar is a vector of other independent variables, and residvar is a vector of variables used to compute residuals from control units, if residvar is not specified, indepvar will be used}

\item{index}{vector of length 2 indicating c(id, time)}

\item{data}{a data frame containing variables to be used}

\item{alpha}{perform the parallel trend alpha test. (Note: irrelevant if there is only one treated unit.)}

\item{fproxy}{set number of factors used. If this option is not specified, the number of factors will be automatically determined by the recursive factor number test.}

\item{stationary}{advanced option: assume all factors are stationary in the recursive factor number test. (Note: irrelevant if fproxy(#) is specified.)}

\item{kmax}{advanced option: set maximum number of factors in the recursive factor number test; default is 10. (Note: irrelevant if fproxy(#) is specified.)}

\item{nwlag}{set maximum lag order of autocorrelation in computing Newey-West standard errors; default is int(T^0.25). (Note: irrelevant if there is more than one treated unit.)}
}
\value{
A list of class \code{pcdid}, the output list includes element:

\describe{
 \item{mg}{mean-group estimate of the treatment effect}
 \item{alpha}{alpha test result}
 \item{treated}{list of treated unit regression results}
 \item{control}{list of control unit regression results}
}
}
\description{
pcdid first uses a data-driven method (based on principal component analysis) on the control panel to compute factor proxies, which capture the unobserved trends. Then, among treated unit(s), it runs regression(s) using the factor proxies as extra covariates.  Analogous to a control function approach, these extra covariates capture the endogeneity arising from potentially unparallel trends.
}
\examples{
# use all control variables to compute residuals
result <- pcdid(
  lncase ~ treated + treated_post +
    afdcben + unemp + empratio + mon_d2 + mon_d3 + mon_d4,
  index = c("state", "trend"),
  data = welfare,
  alpha = TRUE
)
result$mg

# use no control variable to compute residuals
result <- pcdid(
  lncase ~ treated + treated_post +
    afdcben + unemp + empratio + mon_d2 + mon_d3 + mon_d4 | NULL,
  index = c("state", "trend"),
  data = welfare,
  alpha = TRUE
)
result$mg

}
\author{
Xiaolei Wang \email{adamwang15@gmail.com}
}
