% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/purge.R
\name{purge_java}
\alias{purge_java}
\title{Purge Java processes}
\usage{
purge_java(pids = NULL, ask = TRUE)
}
\arguments{
\item{pids}{PIDs to kill. The PIDs should be Java processes. If \code{NULL},
tries to kill all Java processes.}

\item{ask}{If \code{TRUE}, asks for consent before killing the
processes. Defaults to \code{TRUE}.}
}
\value{
An integer vector of the \code{pkill} / \code{Taskkill} status
codes or \code{NULL} if not running Java processes are found.
}
\description{
Kill all or selected running Java processes. This function is useful to
stop Photon instances when not being able to kill the
\code{\link[processx]{process}} objects. Be aware that you can also
kill Java processes other than the photon application using this function!
}
\details{
A list of running Java tasks is retrieved using \code{ps} (on Linux and MacOS)
or \code{tasklist} (on Windows). Tasks are killed using \code{pkill}
(on Linux and MacOS) or \code{Taskkill} (on Windows).
}
\examples{
# NOTE: These examples should only be run interactively or when you are
# sure that no other java processes are running simultaneously!
\dontrun{
purge_java() # does nothing if no java processes are running

# start a new photon instance
dir <- file.path(tempdir(), "photon")
photon <- new_photon(dir, country = "Monaco")
photon$start()

# kill photon using a sledgehammer
purge_java()

photon$start()

# kill photon using a scalpel
library(ps)
p <- ps_handle(photon$proc$get_pid())
pids <- sapply(ps_children(p), ps::ps_pid)
purge_java(pids)}
}
