% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rhs_data_funs.R
\name{rhs_plot_nm}
\alias{rhs_plot_nm}
\title{Generate Right-hand side data plot (NONMEM)}
\usage{
rhs_plot_nm(
  rhs,
  x_var,
  inputs,
  est_parms = NULL,
  nm_res_file = NULL,
  time_nn = NULL,
  act = NULL,
  beta = 20
)
}
\arguments{
\item{rhs}{(string) String of right-hand side}

\item{x_var}{(string) Name of the variable in inputs against which the right-hand data should be plotted.}

\item{inputs}{(dataframe) Dataframe of inputs, with corresponding columns (including matching column names 
for each variable in \emph{rhs}.}

\item{est_parms}{(named vector; semi-optional) Named vector of estimated parameters from the NN extracted through the \emph{pre_fixef_extractor_mlx} function. For optionality, see \strong{Details}.}

\item{nm_res_file}{(string; semi-optional) (path)/name of the results file of a NONMEM run, must include file extension, e.g., “.res”. For optionality, see \strong{Details}.}

\item{time_nn}{(boolean vector) Vector for each NN in \emph{rhs} defining whether the neural network is a time-dependent neural network or not. Default value for all NN is FALSE.}

\item{act}{(character vector) Vector for each NN in \emph{rhs} defining the activation function used in the NN. Default value for all NN is "ReLU".}

\item{beta}{(numeric) Beta value for the Softplus activation function, only applicable if any \emph{act} is softplus; Default to 20.}
}
\value{
ggplot of right-hand side data.
}
\description{
This functions allows to generate right-hand side plot, i.e., combined derivative data of multiple NNs and base-R operations.
}
\details{
Either \emph{est_parms} or \emph{nm_res_file} must be given. If both arguments are given, \emph{est_parms} is prioritized.
}
\examples{
res_path <- system.file("extdata","nm_example1_model_converted_ind.res",package="pmxNODE")
est_parms <- pre_fixef_extractor_nm(res_path)
rhs_plot <- rhs_plot_nm(rhs="NNc + DOSE * NNt",
                         x_var = "NNc",
                         inputs = data.frame(NNc = 1:100,
                                             NNt = seq(0,10,length.out=100),
                                             DOSE = rep(50,100)),
                         est_parms=est_parms,
                         time_nn = c(FALSE, TRUE))
}
\author{
Dominic Bräm
}
