% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcd_cmdstan_model.R
\name{pcd_as_stan_data}
\alias{pcd_as_stan_data}
\title{Prepare data for primarycensored Stan model}
\usage{
pcd_as_stan_data(
  data,
  delay = "delay",
  delay_upper = "delay_upper",
  n = "n",
  pwindow = "pwindow",
  relative_obs_time = "relative_obs_time",
  dist_id,
  primary_id,
  param_bounds,
  primary_param_bounds,
  priors,
  primary_priors,
  compute_log_lik = FALSE,
  use_reduce_sum = FALSE,
  truncation_check_multiplier = 2
)
}
\arguments{
\item{data}{A data frame containing the delay data.}

\item{delay}{Column name for observed delays (default: "delay")}

\item{delay_upper}{Column name for upper bound of delays
(default: "delay_upper")}

\item{n}{Column name for count of observations (default: "n")}

\item{pwindow}{Column name for primary window (default: "pwindow")}

\item{relative_obs_time}{Column name for relative observation time
(default: "relative_obs_time")}

\item{dist_id}{Integer identifying the delay distribution:
You can use \code{\link[=pcd_stan_dist_id]{pcd_stan_dist_id()}} to get the dist ID for a
distribution or look at the \link{pcd_distributions} data set.}

\item{primary_id}{Integer identifying the primary distribution:
You can use \code{\link[=pcd_stan_dist_id]{pcd_stan_dist_id()}} to get the primary dist ID for a
distribution (make sure to select the "primary" type) or look at the
\link{pcd_primary_distributions} data set.}

\item{param_bounds}{A list with elements \code{lower} and \code{upper}, each a numeric
vector specifying bounds for the delay distribution parameters.}

\item{primary_param_bounds}{A list with elements \code{lower} and \code{upper}, each a
numeric vector specifying bounds for the primary distribution parameters.}

\item{priors}{A list with elements \code{location} and \code{scale}, each a numeric
vector specifying priors for the delay distribution parameters.}

\item{primary_priors}{A list with elements \code{location} and \code{scale}, each a
numeric vector specifying priors for the primary distribution parameters.}

\item{compute_log_lik}{Logical; compute log likelihood? (default: FALSE)}

\item{use_reduce_sum}{Logical; use reduce_sum for performance?
(default: FALSE)}

\item{truncation_check_multiplier}{Numeric multiplier to use for checking
if the truncation time D is appropriate relative to the maximum delay
for each unique D value. Set to NULL to skip the check. Default is 2.}
}
\value{
A list containing the data formatted for use with
\code{\link[=pcd_cmdstan_model]{pcd_cmdstan_model()}}
}
\description{
This function takes in delay data and prepares it for use with the
primarycensored Stan model.
}
\examples{
data <- data.frame(
  delay = c(1, 2, 3),
  delay_upper = c(2, 3, 4),
  n = c(10, 20, 15),
  pwindow = c(1, 1, 2),
  relative_obs_time = c(10, 10, 10)
)
stan_data <- pcd_as_stan_data(
  data,
  dist_id = 1,
  primary_id = 1,
  param_bounds = list(lower = c(0, 0), upper = c(10, 10)),
  primary_param_bounds = list(lower = numeric(0), upper = numeric(0)),
  priors = list(location = c(1, 1), scale = c(1, 1)),
  primary_priors = list(location = numeric(0), scale = numeric(0))
)
}
\seealso{
Modelling wrappers for external fitting packages
\code{\link{fitdistdoublecens}()},
\code{\link{pcd_cmdstan_model}()}
}
\concept{modelhelpers}
