% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epi_functions.R
\name{odds_trend}
\alias{odds_trend}
\title{Function to calculate OR using Wald CI, and plot trend.}
\usage{
odds_trend(data, x, y, method = "wald", ...)
}
\arguments{
\item{data}{A data frame.}

\item{x}{A variable in the data frame.}

\item{y}{A variable in the data frame.}

\item{method}{Method for calculating confidence interval around odds ratio.}

\item{...}{Passes optional arguments to \code{oddsratio}.}
}
\value{
A data frame.
}
\description{
\code{odds_trend} calculates the odds ratio with confidence intervals (Wald) for different levels.
(three or more) of the exposure variable.
}
\details{
\code{odds_trend} is a wrap function that calls \code{oddsratio} from package \code{epitools}.

Additional methods for confidence intervals include: \code{"midp"}, \code{"fisher"}, and \code{"small"}.
}
\examples{
## A cross-sectional study looked at the association between obesity and a biopsy resulting
## from mammography screening.

Freq <- c(3441, 34, 39137, 519, 20509, 280, 12149, 196, 11882, 199)
Biopsy <- gl(2, 1, 10, labels = c("No", "Yes"))
Weight <- gl(5, 2, 10, labels = c(
  "Underweight", "Normal", "Over (11-24\%)",
  "Over (25-39\%)", "Over (> 39\%)"
))
breast <- data.frame(Freq, Biopsy, Weight)
breast

breast <- expand_df(breast)
require(sjlabelled, quietly = TRUE)

breast <- var_labels(breast,
  Weight = "Weight group"
)

breast |>
  odds_trend(x = Weight, y = Biopsy)

breast |>
  odds_trend(x = Weight, y = Biopsy) |>
  effect_plot(x = OR, y = Exposure)
}
\seealso{
\code{\link[epitools]{oddsratio}}.
}
