% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minB.R
\name{build_pwl_envelope}
\alias{build_pwl_envelope}
\title{Construct Piecewise Linear Envelope}
\usage{
build_pwl_envelope(data, smallconst = 1e-06)
}
\arguments{
\item{data}{A numeric matrix with two columns: x and f(x) values.
Must have at least two rows.}

\item{smallconst}{Small constant for numerical tolerance (default 1e-6).}
}
\value{
A list with element 'PWL': a numeric matrix of segments (slope, intercept, lower x-bound, upper x-bound).
Returns NULL if envelope construction fails due to invalid input.
}
\description{
Builds a piecewise linear envelope around the data using
convex hulls and intersection logic similar to the original C++ code.
}
\keyword{internal}
