% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rap_projection.R
\name{rap_projection}
\alias{rap_projection}
\title{Select Projection System for RAP Extent}
\usage{
rap_projection(x, res)
}
\arguments{
\item{x}{\emph{character}. One of \code{"CONUS_AEA"}, \code{"CONUS_EQUI7"}, \code{"CONUS_IGH"}}

\item{res}{\emph{integer}. Resolution in meters.}
}
\value{
An empty \emph{SpatRaster} object with a standard extent (xmin,ymax,xmax,ymin),
resolution and projected Coordinate Reference System.
}
\description{
This function provides several "standard" projected Coordinate Reference
Systems that are suitable for representing Rangeland Analysis Platform
products across the contiguous (lower 48) United States at the specified
resolution (in meters).
}
\details{
Currently there are three pre-calculated grid systems that have their extent
designed to align at 1, 5, 10, 30, 100, and 300 meter resolutions.

\code{"CONUS_AEA"} is the default template used with \code{get_rap(source="rap-10m")}
when data spanning multiple UTM zones are requested, unless user specifies
their own template via SpatRaster object as \code{x} or \code{template} argument.
\subsection{Grid Specifications}{
\itemize{
\item \code{"CONUS_AEA"}: Albers Equal Area Conic projection for CONUS extent.
\itemize{
\item \code{xmin = -2356300}
\item \code{ymax = 3172500}
\item \code{xmax = 2264000}
\item \code{ymin = 270000}
\item \code{crs = "EPSG:5070"}
}
\item \verb{"CONUS_EQUI7}: \href{https://github.com/TUW-GEO/Equi7Grid}{Equi7Grid} projection for CONUS + Hawaii extent.
\itemize{
\item \code{xmin = 599500}
\item \code{ymax = 4967500}
\item \code{xmax = 10737100}
\item \code{ymin = 1913500}
\item \code{crs = "EPSG:27705"}
}
\item \code{"CONUS_IGH"}: Interrupted Goode Homolosine projection for CONUS extent.
\itemize{
\item \code{xmin = -13390500}
\item \code{ymax = 5836700}
\item \code{xmax = -8268600}
\item \code{ymin = 2480600}
\item \code{crs = "+proj=igh"}
}
}
}
}
\examples{
\dontshow{if (requireNamespace("terra")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

rap_projection("CONUS_AEA", 10)

rap_projection("CONUS_IGH", 100)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=get_rap]{get_rap()}}
}
