% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.R
\name{flatten_network}
\alias{flatten_network}
\title{Flatten a network by adding points at apparent intersections}
\usage{
flatten_network(network)
}
\arguments{
\item{network}{A network object of class \code{\link[sfnetworks:sfnetwork]{sfnetworks::sfnetwork}}}
}
\value{
An \code{\link[sfnetworks:sfnetwork]{sfnetworks::sfnetwork}} object with additional points at
intersections
}
\description{
All crossing edges are identified, and the points of intersections are
injected within the edge geometries. Note that the injected points are
not converted to network nodes (this can be achieved via sfnetworks'
\code{\link[sfnetworks:spatial_morphers]{sfnetworks::to_spatial_subdivision()}}, which is part of the tasks
that are included in \code{\link[=clean_network]{clean_network()}}.
}
\details{
The functionality is similar to sfnetworks'
\code{\link[sfnetworks:st_network_blend]{sfnetworks::st_network_blend()}}, but in that case an external point is
only injected to the closest edge.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
bucharest_osm <- get_osm_example_data()
edges <- dplyr::bind_rows(bucharest_osm$streets,
                          bucharest_osm$railways)
network <- sfnetworks::as_sfnetwork(edges, directed = FALSE)
flatten_network(network)
\dontshow{\}) # examplesIf}
}
