% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NCA_Server.R
\name{NCA_fetch_np_meta}
\alias{NCA_fetch_np_meta}
\title{Fetches NCA Parameter Meta Information}
\usage{
NCA_fetch_np_meta(
  MOD_yaml_file = system.file(package = "ruminate", "templates", "NCA.yaml")
)
}
\arguments{
\item{MOD_yaml_file}{Module configuration file with MC as main section.}
}
\value{
List with the following elements:
\itemize{
\item{choices:} List parameter choices grouped by values specified in the module configuration file.
\item{summary:} Data frame with meta data about the NCA parameters with
the following columns:
\itemize{
\item{parameter:}   Name of parameter in PKNCA.
\item{text:}        Name of parameter in plain text.
\item{md:}          Parameter name formatted in Markdown.
\item{latex:}       Parameter name formatted using LaTeX.
\item{description:} Verbose description in plain text for the parameter.
}
}
}
\description{
This provides meta information about NCA parameters. This
includes parameter names, text descriptions, formatting (md and LaTeX).
}
\examples{
NCA_fetch_np_meta()
}
