% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_statis.R
\name{plot.statis.plane}
\alias{plot.statis.plane}
\title{Plot a Plane of Observations or 2D Projections}
\usage{
\method{plot}{statis.plane}(points, inertia = 100, labels = NULL, title = "")
}
\arguments{
\item{points}{A matrix, data frame, or a length-2 vector with coordinates (x, y). Must have exactly two columns.}

\item{inertia}{A number between 0 and 100 indicating the percentage of explained inertia (optional, defaults to 100).}

\item{labels}{A character vector with labels for the points (optional). Must match the number of rows in \code{points}.}

\item{title}{A text string to be used as the main title of the plot (optional).}
}
\value{
A \code{ggplot} object with the generated plot.
}
\description{
This function generates a two-dimensional scatter plot with centered axes,
useful for representing the results of multivariate analyses.
}
\details{
The plot includes points, optional labels, Cartesian axes (centered at 0),
and a title indicating the percentage of explained inertia.
}
\examples{
data(expert1, expert2, expert3)

labels <- c("Expert 1", "Expert 2", "Expert 3")

# If you want to select an specific table or row just set the parameters in the statis function.

res <- statis(list(expert1, expert2, expert3), table.labels = labels)

# Main Plane of Average Individuals
individuals <- res$plane.individuals
plot.statis.plane(individuals$points, individuals$inertia, individuals$labels, individuals$title)

# Main Plane of the Evolution of individuals
evolution <- res$plane.evolution
plot.statis.plane(evolution$points, evolution$inertia, evolution$labels, evolution$title)

}
\seealso{
\code{\link{statis}}
}
