% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{page}
\alias{page}
\alias{body}
\alias{topbar}
\alias{footer}
\alias{sidebar_menu}
\alias{horizontal_menu}
\alias{menu_item}
\alias{tab_items}
\alias{tab_item}
\title{Create a Tabler Dashboard Page}
\usage{
page(
  title = NULL,
  navbar = NULL,
  body = NULL,
  footer = NULL,
  layout = "boxed",
  theme = "light",
  color = "blue",
  show_theme_button = FALSE
)

body(..., class = NULL)

topbar(title = NULL, brand_image = NULL, ...)

footer(left = NULL, right = NULL)

sidebar_menu(..., title = NULL)

horizontal_menu(...)

menu_item(text, tab_name = NULL, icon = NULL, href = NULL, badge = NULL)

tab_items(...)

tab_item(tab_name, ...)
}
\arguments{
\item{title}{Optional brand for the sidebar; either a string (text title) or
a named list with elements `text` and `img` (URL/path) to render a brand
image and title. Example: `title = list(text = "My App", img = "logo.png")`.}

\item{navbar}{Dashboard navbar/menu. Can be:
- `sidebar_menu()` for a vertical sidebar
- `horizontal_menu()` for a horizontal menu}

\item{body}{Dashboard body content}

\item{footer}{Dashboard footer (optional)}

\item{layout}{Layout type: "boxed"}

\item{theme}{Default theme: "light" (default) or "dark".}

\item{color}{Color theme (optional): "blue" (default), "azure", "indigo", "purple", "pink",
"red", "orange", "yellow", "lime", "green", "teal", "cyan".}

\item{show_theme_button}{Whether to show the theme toggle buttons (default: `FALSE`).}

\item{...}{Content for this tab}

\item{class}{Additional CSS classes}

\item{brand_image}{URL or path to brand image}

\item{left}{Left-aligned content}

\item{right}{Right-aligned content}

\item{text}{Item text/label}

\item{tab_name}{Unique identifier for the tab (must match menuItem tab_name)}

\item{icon}{Icon name (optional)}

\item{href}{Link URL (optional, alternative to tab_name)}

\item{badge}{Badge text (optional)}
}
\value{
HTML tag with dependencies attached

An HTML tag representing the body

An HTML tag representing the top header

An HTML tag representing the footer

An HTML tag representing the sidebar menu

An HTML tag representing the horizontal menu

An HTML tag representing the menu item

An HTML tag representing the tab items container

An HTML tag representing the tab item
}
\description{
Main function to create a complete dashboard page with Tabler theme

Container for dashboard content

Helper to create a top navigation header. This replaces the
previous top-navbar behavior when users passed a header-like component.

Footer for the dashboard

Container for navigation items in sidebar

Container for navigation items in horizontal layout

Individual navigation item for sidebar

Container for multiple tab panels in tabbed layouts

Individual tab panel content
}
\examples{
ui <- page(
  title = "Combo Dashboard",
  layout = "combo",
  navbar = list(
    top = topbar(title = "My App"),
    side = sidebar_menu(
      menu_item("Dogs", icon = "dog"),
      menu_item("Cats", icon = "cat")
    )
  ),
  body = body("Welcome to Tabler!")
)

server <- function(input, output, session) {}

# shinyApp(ui, server)
}
