% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_models.R
\docType{data}
\name{nuvel1}
\alias{nuvel1}
\title{NUVEL-1 Global model of current plate motions}
\format{
An object of class \code{data.frame}
\describe{
\item{plate.name}{The rotating plate}
\item{plate.rot}{The abbreviation of the plate's name}
\item{lat,lon}{Coordinates of the Pole of Rotation}
\item{angle}{The amount of rotation (angle in 1 Myr)}
\item{plate.fix}{The anchored plate, i.e. \code{plate.rot} moves relative
to  \code{plate.fix}}
\item{source}{Reference to underlying study}
}
}
\usage{
data('nuvel1')
}
\description{
NNR-NUVEL-1 global model of current plate motions by DeMets et al. 1990
}
\examples{
data("nuvel1")
head("nuvel1")
}
\references{
DeMets, C., Gordon, R. G., Argus, D. F., & Stein, S. (1990).
Current plate motions. \emph{Geophysical Journal International}, \strong{101}(2),
425-478. \doi{10.1111/j.1365-246X.1990.tb06579.x}.
}
\keyword{datasets}
