% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggstrat-plot_addons.R
\name{sequential_layer_facets}
\alias{sequential_layer_facets}
\title{Change facet ordering behaviour}
\usage{
sequential_layer_facets(reverse = FALSE)
}
\arguments{
\item{reverse}{Use TRUE to process layers in reverse order}
}
\value{
An object that can be added to a \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}
}
\description{
Normally, facets are ordered using \link[base:factor]{as.factor} on all values that occur
within layer data, which means that when adding additional layers, any ordering
is not preserved unless the factor levels are identical on all factors. This function
changes this behaviour such that facet levels are combined in layer order. This is
useful when adding standalone layers to a plot without disturbing the existing order.
}
\examples{
library(ggplot2)

p <- ggplot(mapping = aes(x, y)) +
  geom_point(data = data.frame(x = 1:5, y = 1:5, facet = "b")) +
  geom_point(data = data.frame(x = 1:5, y = 1:5, facet = "a")) +
  facet_wrap(vars(facet))

p
p + sequential_layer_facets()

}
