% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visit_sequence.R
\name{visit_sequence}
\alias{visit_sequence}
\title{Generate a visit sequence.}
\usage{
visit_sequence(schema, weight_var = NULL, synthesize_weight = TRUE)
}
\arguments{
\item{schema}{A \code{schema} object.}

\item{weight_var}{A numeric weight for the weighted total ordering.}

\item{synthesize_weight}{Boolean for if weight_var should be included in the
visit sequence.}
}
\value{
A \code{visit_sequence} object.
}
\description{
Generate a visit sequence.
}
\examples{

df <- data.frame(
  factor_var = c("1", "1", "2"),
  vara = c(10000, 20000, 100000),
  varb = c(300, 200, 100),
  var_loss = c(1999999, 0, -1000000),
  weight = c(1000, 1000, 2000)
)

start_df <- dplyr::select(df, factor_var)

schema1 <- schema(
  conf_data = dplyr::select(df, -weight),
  start_data = start_df
)
                  
vs1 <- visit_sequence(
  schema = schema1
)

schema2 <- schema(
  conf_data = df,
  start_data = start_df
)

vs2 <- visit_sequence(
  schema = schema2,
  weight_var = weight,
  synthesize_weight = TRUE
)

}
