% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type_summary.R
\name{type_summary}
\alias{type_summary}
\title{Plot summary values of \code{y} at unique values of \code{x}}
\usage{
type_summary(fun = mean, ...)
}
\arguments{
\item{fun}{summarizing function. Should be compatible with
\code{\link[stats]{ave}}. Defaults to \code{\link[base]{mean}}.}

\item{...}{Additional arguments are passed to the \code{lines()} function,
ex: \code{type="p"}, \code{col="pink"}.}
}
\description{
Applies a summary function to \code{y} along unique values of \code{x}. For example,
plot the mean \code{y} value for each \code{x} value. Internally,
\code{type_summary()} applies a thin wrapper around \code{\link[stats]{ave}} and
then passes the result to \code{\link{type_lines}} for drawing.
}
\examples{
# Plot the mean chick weight over time
tinyplot(weight ~ Time, data = ChickWeight, type = "summary")

# Note: "mean" is the default function, so these are also equivalent:
# tinyplot(weight ~ Time, data = ChickWeight, type = type_summary())
# tinyplot(weight ~ Time, data = ChickWeight, type = type_summary(mean))

# Plot the median instead
tinyplot(weight ~ Time, data = ChickWeight, type = type_summary(median))

# Works with groups and/or facets too
tinyplot(weight ~ Time | Diet, facet = "by", data = ChickWeight, type = "summary")

# Custom/complex function example
tinyplot(
  weight ~ Time | Diet, facet = "by", data = ChickWeight,
  type = type_summary(function(y) quantile(y, probs = 0.9)/max(y))
)

}
\seealso{
\code{\link{ave}} which performs the summarizing (averaging) behind the
scenes.
}
