% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_addcmul}
\alias{torch_addcmul}
\title{Addcmul}
\usage{
torch_addcmul(self, tensor1, tensor2, value = 1L)
}
\arguments{
\item{self}{(Tensor) the tensor to be added}

\item{tensor1}{(Tensor) the tensor to be multiplied}

\item{tensor2}{(Tensor) the tensor to be multiplied}

\item{value}{(Number, optional) multiplier for \eqn{tensor1 .* tensor2}}
}
\description{
Addcmul
}
\section{addcmul(input, tensor1, tensor2, *, value=1, out=NULL) -> Tensor }{


Performs the element-wise multiplication of \code{tensor1}
by \code{tensor2}, multiply the result by the scalar \code{value}
and add it to \code{input}.

\deqn{
    \mbox{out}_i = \mbox{input}_i + \mbox{value} \times \mbox{tensor1}_i \times \mbox{tensor2}_i
}
The shapes of \code{tensor}, \code{tensor1}, and \code{tensor2} must be
broadcastable .

For inputs of type \code{FloatTensor} or \code{DoubleTensor}, \code{value} must be
a real number, otherwise an integer.
}

\examples{
if (torch_is_installed()) {

t = torch_randn(c(1, 3))
t1 = torch_randn(c(3, 1))
t2 = torch_randn(c(1, 3))
torch_addcmul(t, t1, t2, 0.1)
}
}
