% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_quantize_per_channel}
\alias{torch_quantize_per_channel}
\title{Quantize_per_channel}
\usage{
torch_quantize_per_channel(self, scales, zero_points, axis, dtype)
}
\arguments{
\item{self}{(Tensor) float tensor to quantize}

\item{scales}{(Tensor) float 1D tensor of scales to use, size should match \code{input.size(axis)}}

\item{zero_points}{(int) integer 1D tensor of offset to use, size should match \code{input.size(axis)}}

\item{axis}{(int) dimension on which apply per-channel quantization}

\item{dtype}{(\code{torch.dtype}) the desired data type of returned tensor.        Has to be one of the quantized dtypes: \code{torch_quint8}, \code{torch.qint8}, \code{torch.qint32}}
}
\description{
Quantize_per_channel
}
\section{quantize_per_channel(input, scales, zero_points, axis, dtype) -> Tensor }{


Converts a float tensor to per-channel quantized tensor with given scales and zero points.
}

\examples{
if (torch_is_installed()) {
x = torch_tensor(matrix(c(-1.0, 0.0, 1.0, 2.0), ncol = 2, byrow = TRUE))
torch_quantize_per_channel(x, torch_tensor(c(0.1, 0.01)), 
                           torch_tensor(c(10L, 0L)), 0, torch_quint8())
torch_quantize_per_channel(x, torch_tensor(c(0.1, 0.01)), 
                           torch_tensor(c(10L, 0L)), 0, torch_quint8())$int_repr()
}
}
