% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treedata.table.R
\name{[[.treedata.table}
\alias{[[.treedata.table}
\title{Function for extract a named vector from an object of class \code{treedata.table}}
\usage{
\method{[[}{treedata.table}(x, ..., exact = TRUE)
}
\arguments{
\item{x}{An object of class \code{treedata.table}}

\item{...}{Column name in class \code{character}}

\item{exact}{whether exact search should be conducted}
}
\value{
A new object of class \code{vector} with names set to labels corresponding
to tip labels in the provided \code{treedata.table} object.
}
\description{
This function extracts a named vector for any  trait from an object of class
\code{treedata.table}.
}
\examples{
data(anolis)
# With a phylo object
td <- as.treedata.table(anolis$phy, anolis$dat)
td[["SVL"]]

# With a multiPhylo object
treesFM <- list(anolis$phy, anolis$phy)
class(treesFM) <- "multiPhylo"
td <- as.treedata.table(treesFM, anolis$dat)
td[["SVL"]]
}
