% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_aug_wormhole.R
\name{ts_aug_wormhole}
\alias{ts_aug_wormhole}
\title{Augmentation by Wormhole}
\usage{
ts_aug_wormhole()
}
\value{
A \code{ts_aug_wormhole} object.
}
\description{
Generate augmented windows by selectively replacing lag terms
with older lagged values, creating plausible alternative trajectories.
}
\details{
This combinatorial replacement preserves overall scale while
introducing temporal permutations of lag content.
}
\examples{
# Wormhole augmentation replaces some lags with older values
# Load package and example dataset
library(daltoolbox)
data(tsd)

# Convert to sliding windows and preview
xw <- ts_data(tsd$y, 10)
ts_head(xw)

# Apply wormhole augmentation and inspect augmented windows
augment <- ts_aug_wormhole()
augment <- fit(augment, xw)
xa <- transform(augment, xw)
ts_head(xa)
}
\references{
\itemize{
\item Q. Wen et al. (2021). Time Series Data Augmentation for Deep Learning:
A Survey. IJCAI Workshop on Time Series.
}
}
