% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualisation.R
\name{plot_counterfactual}
\alias{plot_counterfactual}
\title{Prepare Plot Data and Plot Counterfactuals}
\usage{
plot_counterfactual(
  predictions,
  params,
  window_size = 14,
  date_effect_start = NULL,
  buffer = 0,
  plot_pred_interval = TRUE
)
}
\arguments{
\item{predictions}{The data.table containing the predictions (hourly)}

\item{params}{Parameters for plotting, including the target variable.}

\item{window_size}{The window size for the rolling mean (default is 14 days).}

\item{date_effect_start}{A date. Start date of the
effect that is to be evaluated. The data from this point onwards is disregarded
for calculating model performance}

\item{buffer}{Integer. An additional, optional buffer window before
\code{date_effect_start} to account for uncertainty in the effect start point.
Disregards additional buffer data points for model evaluation.
Use \code{buffer=0} for no buffer.}

\item{plot_pred_interval}{Boolean. If \code{TRUE}, shows a grey band of the prediction
interval.}
}
\value{
A ggplot object with the counterfactual plot. Can be adjusted further,
e.g. set limits for the y-axis for better visualisation.
}
\description{
Smooths the predictions using a rolling mean, prepares the data for plotting,
and generates the counterfactual plot for the application window. Data before
the red box are reference window, red box is buffer and values after black,
dotted line are effect window.
}
\details{
The optional grey ribbon is a prediction interval for the hourly values. The
interpretation for a 90\% prediction interval (to be defined in \code{alpha} parameter
of \code{\link[=run_counterfactual]{run_counterfactual()}}) is that 90\% of the true hourly values
(not the rolled means) lie within the grey band. This might be helpful for
getting an idea of the variance of the data and predictions.
}
