#ifndef RF_STACK_OUTPUT_H
#define RF_STACK_OUTPUT_H
char getStrengthTreeCount(char       mode,
                          uint       ntree,
                          uint       maxTree,
                          uint      *tLeafCount,
                          uint      *oobSZ,
                          uint      *strengthTreeCount);
void stackStrengthObjectsPtrOnly(char       mode,
                                 uint       strengthTreeCount,
                                 uint     **strengthTreeID,
                                 uint     **branchCount,
                                 uint    ***branchID,
                                 uint    ***oobCount,
                                 uint    ***xReleaseCount,
                                 uint   ****xReleaseIDArray,
                                 uint   ****complementCount,
                                 uint   ****oobMembers,
                                 uint  *****complementMembers,
                                 uint    ***proxyIndv,
                                 uint    ***proxyIndvDepth);
void unstackStrengthObjectsPtrOnly(char      mode,
                                   uint      strengthTreeCount,
                                   uint     *strengthTreeID,
                                   uint     *branchCount,
                                   uint    **branchID,
                                   uint    **oobCount,
                                   uint    **xReleaseCount,
                                   uint   ***xReleaseIDArray,
                                   uint   ***complementCount,
                                   uint   ***oobMembers,
                                   uint  ****complementMembers,
                                   uint    **proxyIndv,
                                   uint    **proxyIndvDepth);
void selectTrees(uint    ntree,
                 uint    strengthTreeCount,
                 uint   *tLeafCount,
                 uint   *oobSZ,
                 uint   *strengthTreeID);
void selectBranches(uint    b,
                    uint    treeID,
                    uint    maxRulesTree,
                    uint    leafCount,
                    uint    *branchCount,
                    uint   **branchID,
                    uint   **oobCount,
                    uint   **xReleaseCount,
                    uint  ***xReleaseIDArray,
                    uint  ***complementCount,
                    uint  ***oobMembers,
                    uint ****complementMembers,
                    uint   **proxyIndv,
                    uint   **proxyIndvDepth);
void selectBranchesTrain(uint    b,
                         uint    treeID,
                         uint    maxRulesTree,
                         uint    leafCount,
                         TerminalBase **termMembership,
                         uint     membershipSize,
                         uint    *targMembershipIndx,
                         uint     targMembershipSize,
                         uint    *branchCount,
                         uint   **branchID,
                         uint   **oobCount,
                         uint   **xReleaseCount,
                         uint  ***xReleaseIDArray,
                         uint  ***complementCount,
                         uint  ***oobMembers,
                         uint ****complementMembers,
                         uint   **proxyIndv,
                         uint   **proxyIndvDepth);
void selectBranchesTest(uint    b,
                        uint    treeID,
                        uint    maxRulesTree,
                        uint    leafCount,
                        TerminalBase **termMembership,
                        uint     membershipSize,
                        uint    *branchCount,
                        uint   **branchID,
                        uint   **oobCount,
                        uint   **xReleaseCount,
                        uint  ***xReleaseIDArray,
                        uint  ***complementCount,
                        uint  ***oobMembers,
                        uint ****complementMembers,
                        uint   **proxyIndv,
                        uint   **proxyIndvDepth);
void freeStrengthBranchIDVectors(uint     strengthTreeCount,
                                 uint    *branchCount,
                                 uint   **branchID,
                                 uint   **oobCount,
                                 uint   **xReleaseCount,
                                 uint  ***xReleaseIDArray,
                                 uint  ***complementCount,
                                 uint  ***oobMembers,
                                 uint ****complementMembers,
                                 uint   **proxyIndv,
                                 uint   **proxyIndvDepth);
void freeReleaseIDArray(uint    branchCount,
                        uint   *oobCount,
                        uint   *xReleaseCount,
                        uint  **xReleaseIDArray,
                        uint  **complementCount,
                        uint  **oobMembers,
                        uint ***complementMembers,
                        uint   *proxyIndvDepth);
void freeComplementMembership(uint   xReleaseCount,
                              uint  *complementCount,
                              uint **complementMembers);
void writeStrengthArray(uint     *strengthTreeID,
                        uint      strengthTreeCount,
                        uint    **branchID,
                        uint     *branchCount,
                        uint    **branchMemberCount,
                        uint   ***complementCount,
                        uint    **xReleaseCount,
                        uint   ***xReleaseIDArray,
                        uint     *treeID,
                        uint     *nodeID,
                        uint     *xReleaseID,
                        void     *brmCT,
                        void     *releaseStat);
void writeMembershipArray(uint      strengthTreeCount,
                          uint     *branchCount,
                          uint    **branchMemberCount,
                          uint   ***complementCount,
                          uint    **xReleaseCount,
                          uint   ***branchMembers,
                          uint  ****complementMembers,
                          uint     *complementCT,
                          uint     *branchPopID,
                          uint     *complementID);
void acquireTwinStat(uint strengthTreeCount,
                     uint *branchCount,
                     uint ***complementCount,
                     uint **xReleaseCount,
                     uint **branchID,
                     uint **testCaseNodeIDptr,
                     uint   ***xReleaseIDArray,
                     uint  ****complementMembers,
                     uint n,
                     uint xSize,
                     uint  i,
                     uint  neighbourSize,
                     uint  xReduceSize,
                     uint *xReduceIndx,
                     uint   **twinStatID_ptr,
                     double **twinStat_ptr,
                     uint  ***twinFreqTable_ptr);
void getMinHeap(uint twin, uint m, uint n, double *value, uint *minHeap);
void testTwinMembership(void);
void testMinHeap(void);
#endif
