% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/km_wlr_calculations_helpers.R
\name{km_quantile}
\alias{km_quantile}
\title{Kaplan-Meier quantile and confidence interval}
\usage{
km_quantile(
  time_points,
  survival_probs,
  se_probs = NULL,
  qprob = 0.5,
  type = c("midpoint", "min"),
  conf_level = 0.95
)
}
\arguments{
\item{time_points}{Vector of time points.}

\item{survival_probs}{Vector of survival probabilities.}

\item{se_probs}{Standard errors of survival probabilities.}

\item{qprob}{Quantile probability (default 0.5).}

\item{type}{Calculation type (midpoint or min).}

\item{conf_level}{Confidence level (default 0.95).}
}
\value{
List with quantile and confidence interval.
}
\description{
Calculates the quantile and confidence interval for a Kaplan-Meier curve.
}
