% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Indices.R
\name{removeIndex}
\alias{removeIndex}
\title{Removes an index from an Andromeda table}
\usage{
removeIndex(tbl, columnNames = NULL, indexName = NULL)
}
\arguments{
\item{tbl}{An \code{\link{Andromeda}} table (or any other 'DBI' table).}

\item{columnNames}{A vector of column names (character) on which the index was created. If not
provided, then the \code{indexName} argument must be provided.}

\item{indexName}{The name of the index. If not provided, the \code{columnNames} argument must be
provided.}
}
\value{
Invisibly returns the input table.
}
\description{
Removes an index from an Andromeda table
}
\details{
Remove an index created using the \code{\link[=createIndex]{createIndex()}} function. Either the index name or the column
names on which the index was created must be provided.
}
\examples{
andr <- andromeda(cars = cars)

createIndex(andr$cars, "speed")

# Will be faster now that speed is indexed:
andr$cars \%>\%
  filter(speed == 10) \%>\%
  collect()
  
removeIndex(andr$cars, "speed")

close(andr)

}
\seealso{
\code{\link[=createIndex]{createIndex()}}, \code{\link[=listIndices]{listIndices()}}
}
