% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggm_search.R
\name{ggm_search}
\alias{ggm_search}
\title{Perform Bayesian Graph Search and Optional Model Averaging}
\usage{
ggm_search(
  x,
  n = NULL,
  method = "mc3",
  prior_prob = 0.3,
  iter = 5000,
  stop_early = 1000,
  bma_mean = TRUE,
  seed = NULL,
  progress = TRUE,
  ...
)
}
\arguments{
\item{x}{Data, either raw data or covariance matrix}

\item{n}{For x = covariance matrix, provide number of observations}

\item{method}{mc3 defaults to MH sampling}

\item{prior_prob}{Prior prbability of sparseness.}

\item{iter}{Number of iterations
#@param burn_in Burn in. Defaults to iter/2}

\item{stop_early}{Default to 1000. Stop MH algorithm if proposals keep being rejected (stopping by default after 1000 rejections).}

\item{bma_mean}{Compute Bayesian Model Averaged solution}

\item{seed}{Set seed. Current default is to set R's random seed.}

\item{progress}{Show progress bar, defaults to TRUE}

\item{...}{Not currently in use}
}
\value{
A list containing the MAP graph structure, BMA solution (if specified),
        and posterior probabilities of the sampled graphs.
}
\description{
The `ggm_search` function performs a Bayesian graph search to identify the 
most probable graph structure (MAP solution) using the Metropolis-Hastings 
algorithm. It also computes an optional Bayesian Model Averaged (BMA) solution 
across the graph structures sampled during the search.
}
\details{
This function is ideal for exploring the graph space and obtaining an initial 
estimate of the graph structure or adjacency matrix. 

To refine the results or compute posterior distributions of graph parameters 
(e.g., partial correlations), use the \code{\link{bma_posterior}} function, 
which builds on the output of `ggm_search` to account for parameter uncertainty.
}
\seealso{
\code{\link{bma_posterior}}
}
\author{
Donny Williams and Philippe Rast
}
