% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_extrapolation.R
\name{test_extrapolation}
\alias{test_extrapolation}
\title{Test differences between observed and extrapolated stocks}
\usage{
test_extrapolation(
  df = NULL,
  depth = 100,
  core = "core",
  mind = "mind_corrected",
  maxd = "maxd_corrected",
  dbd = "dbd",
  oc = "eoc"
)
}
\arguments{
\item{df}{A data.frame with, at least, columns: core,
mind (minimum depth of the sample), maxd (maximum depth of the sample),
dbd (dry bulk density), oc (organic carbon \%)}

\item{depth}{Number Standardization soil depth, by default 100 cm.}

\item{core}{Character Name of the column reporting core ID.}

\item{mind}{Character Name of the column reporting the minimum depth of each sample.}

\item{maxd}{Character Name of the column reporting the maximum depth of each sample.}

\item{dbd}{Character Name of the column reporting dry bulk density.}

\item{oc}{Character Name of the column reporting organic carbon concentrations.}
}
\value{
A data.frame with the observed and extrapolated stocks. A plot with comparisons.
}
\description{
Subset those cores that reach the standardization depth and estimates the stock (observed stock),
estimate the stock from the linear relation of organic carbon accumulated mass and depth using the 90, 75, 50 and 25\%
top length of the indicated standardization depth. Compares the observed stock with the estimated stocks by extrapolation.
}
\examples{
bluecarbon_decompact <- decompact(bluecarbon_data)
oc <- estimate_oc(bluecarbon_decompact)
out <- test_extrapolation(oc[[1]])


}
