/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.ibase.plots;

import java.awt.Frame;
import java.awt.event.KeyEvent;
import org.rosuda.ibase.Common;
import org.rosuda.ibase.SMarker;
import org.rosuda.ibase.SVar;
import org.rosuda.ibase.toolkit.Axis;
import org.rosuda.ibase.toolkit.BaseCanvas;
import org.rosuda.ibase.toolkit.EzMenu;
import org.rosuda.pograss.PoGraSS;
import org.rosuda.util.Global;

public class KapMeCanvas
extends BaseCanvas {
    SVar vEvent;
    SVar vTime;
    double[] kmX;
    double[] kmY;
    double[] kmC;
    int[] filter = null;
    public boolean showCounts = true;

    public int calcKM(int[] nArray) {
        int n = 0;
        double d = -1.0;
        int n2 = 0;
        while (n2 < nArray.length) {
            double d2;
            if (Double.isNaN(d2 = this.vTime.atD(nArray[n2++])) || d2 == d) continue;
            ++n;
            d = d2;
        }
        this.kmX = new double[n + 1];
        this.kmY = new double[n + 1];
        this.kmC = new double[n + 1];
        int n3 = 1;
        this.kmX[0] = 0.0;
        this.kmY[0] = 1.0;
        this.kmC[0] = 1.0;
        double d3 = 1.0;
        int n4 = nArray.length;
        int n5 = 0;
        int n6 = 0;
        d = -1.0;
        double d4 = 1.0;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            d4 = this.vTime.atD(nArray[n2]);
            if (!Double.isNaN(d4) && d4 != d) {
                if (d != -1.0) {
                    d3 = d3 * (double)(n4 - n5) / (double)n4;
                    this.kmX[n3] = d4;
                    this.kmY[n3] = d3;
                    this.kmC[n3] = (double)(n4 - n5) / (double)nArray.length;
                    ++n3;
                }
                n4 -= n6;
                d = d4;
                n5 = 0;
                n6 = 0;
            }
            ++n6;
            if (!this.vEvent.atS(nArray[n2]).equals("dead")) continue;
            ++n5;
        }
        d3 = d3 * (double)(n4 - n5) / (double)n4;
        this.kmX[n3] = d4;
        this.kmY[n3] = d3;
        this.kmC[n3] = (double)(n4 - n5) / (double)nArray.length;
        return n3 + 1;
    }

    public KapMeCanvas(int n, Frame frame, SVar sVar, SVar sVar2, SMarker sMarker) {
        super(n, frame, sMarker);
        this.setTitle("Kaplan-Meier Plot");
        this.allow180 = false;
        this.vTime = sVar;
        this.vEvent = sVar2;
        this.ay = new Axis(null, 1, 0);
        this.ay.addDepend(this);
        this.ay.setValueRange(0.0, 1.0);
        this.ax = new Axis(this.vTime, 0, 0);
        this.ax.addDepend(this);
        this.ax.setValueRange(0.0, this.ax.vBegin + this.ax.vLen);
        String[] stringArray = new String[]{"+", "File", "~File.Graph", "~Edit", "+", "View", "Hide counts", "counts", "~Window", "0"};
        EzMenu.getEzMenu(frame, this, stringArray);
        this.setDefaultMargins(new int[]{35, 10, 10, 25});
        this.pp = null;
        this.dontPaint = false;
    }

    public void updateObjects() {
        int[] nArray = this.vTime.getRanked();
        this.calcKM(nArray);
    }

    public void paintKM(PoGraSS poGraSS) {
        int n = this.ax.getValuePos(this.kmX[0]);
        int n2 = this.ay.getValuePos(this.kmY[0]);
        for (int i = 1; i < this.kmX.length; ++i) {
            int n3 = this.ax.getValuePos(this.kmX[i]);
            int n4 = this.ay.getValuePos(this.kmY[i]);
            if (n4 == n2) {
                poGraSS.drawLine(n, n2, n3, n4);
            } else {
                poGraSS.drawLine(n, n2, n3, n2);
                poGraSS.drawLine(n3, n2, n3, n4);
            }
            n = n3;
            n2 = n4;
        }
    }

    public void paintInit(PoGraSS poGraSS) {
        float[] fArray = Common.selectColor.getRGBComponents(null);
        poGraSS.defineColor("invMark", fArray[0], fArray[1], fArray[2], 0.3f);
        poGraSS.defineColor("counts", 0.0f, 0.0f, 0.0f, 0.2f);
        poGraSS.defineColor("countsMark", fArray[0], fArray[1], fArray[2], 0.2f);
        poGraSS.defineColor("countsShadow", 0.0f, 0.0f, 0.0f, 0.1f);
        poGraSS.defineColor("backShadow", 0.0f, 0.0f, 0.5f, 0.3f);
    }

    public void paintCounts(PoGraSS poGraSS, double d) {
        if (!this.showCounts) {
            return;
        }
        int n = this.ax.getValuePos(this.kmX[0]);
        int n2 = this.ay.getValuePos(0.0);
        for (int i = 1; i < this.kmX.length; ++i) {
            int n3 = this.ax.getValuePos(this.kmX[i]);
            int n4 = this.ay.getValuePos(this.kmC[i] * d);
            poGraSS.fillRect(n, n4, n3 - n, n2 - n4);
            n = n3;
        }
    }

    public void paintBack(PoGraSS poGraSS) {
        if (this.kmX == null) {
            return;
        }
        poGraSS.setColor("black");
        poGraSS.drawLine(this.mLeft, this.mTop, this.mLeft, this.H - this.mBottom);
        poGraSS.drawLine(this.mLeft, this.H - this.mBottom, this.W - this.mRight, this.H - this.mBottom);
        this.startAddingLabels();
        double d = this.ax.getSensibleTickDistance(50, 26);
        double d2 = this.ax.getSensibleTickStart(d);
        if (Global.DEBUG > 1) {
            System.out.println("KM.ax:" + this.ax.toString() + ", distance=" + d + ", start=" + d2);
        }
        try {
            while (d2 < this.ax.vBegin + this.ax.vLen) {
                int n = this.ax.getValuePos(d2);
                poGraSS.drawLine(n, this.H - this.mBottom, n, this.H - this.mBottom + 5);
                if (this.isShowLabels()) {
                    this.xLabels.add(n, this.H - this.mBottom + 20, 0.5, 0.0, this.ax.getDisplayableValue(d2));
                }
                d2 += d;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        d = this.ay.getSensibleTickDistance(30, 18);
        d2 = this.ay.getSensibleTickStart(d);
        if (Global.DEBUG > 1) {
            System.out.println("KM.ay:" + this.ay.toString() + ", distance=" + d + ", start=" + d2);
        }
        try {
            while (d2 < this.ay.vBegin + this.ay.vLen) {
                int n = this.ay.getValuePos(d2);
                poGraSS.drawLine(this.mLeft - 5, n, this.mLeft, n);
                if (this.isShowLabels()) {
                    this.yLabels.add(this.mLeft - 8, n, 1.0, 0.3, this.ay.getDisplayableValue(d2));
                }
                d2 += d;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.endAddingLabels();
        if (this.filter == null) {
            poGraSS.setColor("counts");
            this.paintCounts(poGraSS, 1.0);
            poGraSS.setColor("back");
            this.paintKM(poGraSS);
        } else {
            poGraSS.setColor("countsShadow");
            this.paintCounts(poGraSS, 1.0);
            poGraSS.setColor("backShadow");
            this.paintKM(poGraSS);
            int[] nArray = new int[this.vTime.size()];
            int n = 0;
            while (n < this.filter.length) {
                nArray[this.filter[n++]] = -2;
            }
            int[] nArray2 = this.vTime.getRanked();
            int[] nArray3 = SVar.filterRanksByMap(nArray2, nArray, -2);
            double[] dArray = this.kmX;
            double[] dArray2 = this.kmY;
            double[] dArray3 = this.kmC;
            if (nArray3 == null || nArray3.length < 2) {
                return;
            }
            this.calcKM(nArray3);
            poGraSS.setColor("counts");
            this.paintCounts(poGraSS, (double)nArray3.length / (double)this.vTime.size());
            poGraSS.setColor("back");
            this.paintKM(poGraSS);
            this.kmX = dArray;
            this.kmY = dArray2;
            this.kmC = dArray3;
        }
    }

    public void setFilter(int[] nArray) {
        this.filter = nArray;
        this.setUpdateRoot(0);
        this.repaint();
    }

    public void paintSelected(PoGraSS poGraSS) {
        int[] nArray;
        double[] dArray = this.kmX;
        double[] dArray2 = this.kmY;
        double[] dArray3 = this.kmC;
        int[] nArray2 = this.vTime.getRanked();
        int[] nArray3 = this.m.getMaskCopy(0);
        int n = 0;
        if (this.filter != null) {
            int n2 = 0;
            while (n2 < this.filter.length) {
                int n3 = this.filter[n2++];
                nArray3[n3] = nArray3[n3] + 2;
            }
            n = 2;
        }
        if ((nArray = SVar.filterRanksByMap(nArray2, nArray3, -1 + n)) == null || nArray.length < 2) {
            return;
        }
        this.calcKM(nArray);
        poGraSS.setColor("countsMark");
        this.paintCounts(poGraSS, (double)nArray.length / (double)this.vTime.size());
        poGraSS.setColor("marked");
        this.paintKM(poGraSS);
        this.kmX = dArray;
        this.kmY = dArray2;
        this.kmC = dArray3;
        nArray = SVar.filterRanksByMap(nArray2, nArray3, n);
        if (nArray == null || nArray.length < 2) {
            return;
        }
        this.calcKM(nArray);
        poGraSS.setColor("invMark");
        this.paintKM(poGraSS);
        this.kmX = dArray;
        this.kmY = dArray2;
        this.kmC = dArray3;
    }

    public void keyTyped(KeyEvent keyEvent) {
        super.keyTyped(keyEvent);
        if (keyEvent.getKeyChar() == 'c') {
            this.run(this, "counts");
        }
    }

    public Object run(Object object, String string) {
        super.run(object, string);
        if (string == "counts") {
            this.showCounts = !this.showCounts;
            EzMenu.getItem(this.getFrame(), "counts").setLabel(this.showCounts ? "Hide counts" : "Show counts");
            this.setUpdateRoot(0);
            this.repaint();
        }
        return null;
    }

    public SVar getData(int n) {
        switch (n) {
            case 0: {
                return this.vTime;
            }
            case 1: {
                return this.vEvent;
            }
        }
        return null;
    }
}

