#' Write UTF-8 text with LF line endings across platforms
#' @keywords internal
#' @noRd
write_text_lf <- function(path, text, ensure_trailing_newline = TRUE) {
  # Accept character vector (lines) or single string
  if (length(text) > 1L) {
    s <- paste(text, collapse = "\n")
  } else {
    s <- if (length(text)) text else ""
  }
  # Normalize line endings: CRLF and lone CR -> LF
  s <- gsub("\r\n", "\n", s, perl = TRUE)
  s <- gsub("\r", "\n", s, perl = TRUE)
  # Ensure trailing newline similar to writeLines default behavior
  if (ensure_trailing_newline && !grepl("\n$", s)) {
    s <- paste0(s, "\n")
  }
  # Write as UTF-8 without BOM in binary mode to avoid OS translations
  con <- file(path, open = "wb")
  on.exit(close(con), add = TRUE)
  writeBin(charToRaw(enc2utf8(s)), con)
  invisible(path)
}
