% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_documentation.R
\name{Colon_df}
\alias{Colon_df}
\title{Chemotherapy Data for Stage B/C Colon Cancer}
\format{
A data frame with 1,858 observations and 16 variables:
\describe{
  \item{id}{Patient identifier (numeric)}
  \item{study}{Study number (numeric)}
  \item{rx}{Treatment group (factor)}
  \item{sex}{Sex of the patient (numeric)}
  \item{age}{Age of the patient in years (numeric)}
  \item{obstruct}{Obstruction present (numeric indicator)}
  \item{perfor}{Perforation present (numeric indicator)}
  \item{adhere}{Adherence to adjacent structures (numeric indicator)}
  \item{nodes}{Number of lymph nodes with cancer (numeric)}
  \item{status}{Patient status (numeric indicator)}
  \item{differ}{Tumor differentiation (numeric)}
  \item{extent}{Extent of local spread (numeric)}
  \item{surg}{Surgical procedure performed (numeric indicator)}
  \item{node4}{At least 4 nodes positive (numeric indicator)}
  \item{time}{Follow-up time in days (numeric)}
  \item{etype}{Type of event (numeric indicator)}
}
}
\source{
Data taken from the survival package version 3.8-3
}
\usage{
data(Colon_df)
}
\description{
This dataset, Colon_df, contains data from a clinical trial of chemotherapy for
patients with Stage B/C colon cancer. The dataset includes 1,858 observations
and 16 variables, providing information on patient demographics, treatment assignment,
disease characteristics, and outcomes. Some observations contain missing values.
}
\details{
The dataset name has been kept as 'Colon_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
ForCausality package and assists users in identifying its specific characteristics.
The suffix 'df' indicates that the dataset is a data frame. The original content has not
been modified in any way.
}
