% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate_periods.R
\name{aggregate_periods}
\alias{aggregate_periods}
\title{Aggregate Periods}
\usage{
aggregate_periods(
  time_series,
  measure = "AGSA",
  time = "timestamp",
  sample_frequency,
  duration = NA,
  first_epoch_timestamp = NA,
  events = NA,
  start_time = "start",
  end_time = "end",
  fun = mean
)
}
\arguments{
\item{time_series}{Data frame to be aggregated.}

\item{measure}{Name of the measure columns to be included.}

\item{time}{Name of the time column.}

\item{sample_frequency}{Frequency of data.}

\item{duration}{Time duration to aggregate in each epoch.}

\item{first_epoch_timestamp}{Time to start the first epoch, defaults to first record.}

\item{events}{Data frame containing the start and end index of each event.}

\item{start_time}{Name of the column in events containing the start index of the events.}

\item{end_time}{Name of the column in events containing the end index of the events.}

\item{fun}{Function to apply on aggregation, defaults to mean.}
}
\value{
Data frame of aggregated epochs or events.
}
\description{
Generalised aggregation function generates distinct epochs or events outputs based on the initial parameters provided.
}
