% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dpe.R
\name{dpe}
\alias{dpe}
\title{dpe}
\usage{
dpe(y, mu, R)
}
\arguments{
\item{y}{response variable vector}

\item{mu}{predicted mean vector}

\item{R}{predicted covariance matrix with the scale parameter removed}
}
\value{
a numeric value
}
\description{
Calculates a decorrelated prediction error (DPE) value. Lower DPE values indicate better fits.
}
\examples{

### test function ###
f_x <- function(x) {
return(sin(2*pi*x) + x^2)
}

### training data ###
n <- 8
x <- runif(n, 0, 1)
y <- f_x(x)

### testing data ###
n.test <- 100
x.test <- runif(n.test, 0, 1)
y.test <- f_x(x.test)

### get parameter estimates ###
out <- mle_gp(y, x)

### prediction ###
pred <- predict_gp(out, x.test)

### get DPE value ###
DPE_value <- dpe(y.test, pred$mup, pred$R)

}
