% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mle_penalty.R
\name{mle_penalty}
\alias{mle_penalty}
\title{mle_penalty}
\usage{
mle_penalty(object, one.se = FALSE, lambda = NULL, ncores = 1)
}
\arguments{
\item{object}{A list returned from \code{\link{gp_cv}}.}

\item{one.se}{Logical indicator for selecting the lambda value using the one-standard error. Default is FALSE. When FALSE, the lambda value that minimizes mse, dpe, or mahalanobis distance (md), or maximizes the score, is selected.
When TRUE, the lambda value is chosen based on the one-standard error rule.}

\item{lambda}{A user specified tuning parameter. This can be provided directly instead of performing cross-validation.}

\item{ncores}{A number of cores for parallel computing with \code{optim}. Default is 1. Make sure your system supports the specified number of cores.}
}
\value{
A list of y, x, and hyperparameters:
\itemize{
\item \code{y}: A copy of y.
\item \code{x}: A copy of x.
\item \code{theta}: A matrix of penalized lengthscale estimates.
\item \code{sigma2}: The estimated scale parameter.
\item \code{mu}: Returns 0 if \code{mu=FALSE} otherwise the estimated mu parameter.
\item \code{g}: Returns the \code{fixed_g} value if \code{g=FALSE} otherwise the estimated nugget value.
\item \code{lambda}: A scalar or vector of lambda values evaluated.
\item \code{theta_upper}: A copy of the upper bound for theta used in \code{\link{gp_cv}} function.
\item \code{theta_lower}: A copy of the lower bound for theta used in \code{\link{gp_cv}} function.
}
}
\description{
Computes penalized maximum likelihood estimates for the lengthscale parameter using \code{optim}.
}
\details{
This function takes the output from \code{\link{gp_cv}} and computes penalized MLEs for the lengthscale parameter,
along with MLEs for other model parameters. Users may choose to apply the one standard error rule for selecting the lambda value.
The \code{\link{gp_cv}} function returns both the optimal lambda and one standard error lambda except for the md metric. See \code{\link{gp_cv}} for details.
}
\examples{
\donttest{
### training data ###
n <- 8

### test function ###
f_x <- function(x) {
return(sin(2*pi*x) + x^2)
}

### generate x ###
x <- runif(n, 0, 1)
y <- f_x(x)

### k-fold cross validation ###
cv.lambda <- gp_cv(y, x, k=4)

### fit the model ###
penalized.mle <- mle_penalty(cv.lambda)

#### use the one standard error rule ###
penalized.mle <- mle_penalty(cv.lambda, one.se=TRUE)

### specify lambda ###
penalized.mle <- mle_penalty(cv.lambda, lambda=cv.lambda$lambda.score.max)

}

}
