% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lopez_ruzicka.R
\name{sen_lopez_ruzicka_sym_instantaneous}
\alias{sen_lopez_ruzicka_sym_instantaneous}
\title{Instantaneous sensitivity via symmetrical Lopez-Ruzicka decomposition}
\usage{
sen_lopez_ruzicka_sym_instantaneous(
  mx,
  age = 0:(length(mx) - 1),
  nx = rep(1, length(mx)),
  sex = "t",
  perturb = 1e-06,
  closeout = TRUE
)
}
\arguments{
\item{mx}{Numeric vector of mortality rates (central death rates).}

\item{age}{integer vector of the lower bound of each age group (currently only single ages supported)}

\item{nx}{integer vector of age intervals, default 1.}

\item{sex}{Character; \code{"m"} for male, \code{"f"} for female, or \code{"t"} for total.}

\item{perturb}{Numeric; a small constant determining the perturbation size (default 1e-6).}

\item{closeout}{logical. Default \code{TRUE}. Shall we use the HMD Method Protocol to close out the \code{ax} and \code{qx} values? See details.}
}
\value{
numeric vector of sensitivity of life expectancy to perturbations in \code{mx}.
}
\description{
Estimates the instantaneous sensitivity of life expectancy to small proportional changes in mortality rates, using the symmetrical Lopez-Ruzicka decomposition. This implementation perturbs the rates up and down around a central value and applies the symmetrical decomposition to the result.

Specifically, the function constructs:
\deqn{m_{x}^{1} = m_x \cdot \left(\frac{1}{1 - h}\right)}
\deqn{m_{x}^{2} = m_x \cdot (1 - h)}
and applies \code{sen_lopez_ruzicka_sym(mx1, mx2, ...)} to the result.
}
\details{
This gives a pointwise estimate of the derivative of life expectancy with respect to each age-specific mortality rate, evaluated symmetrically around the given mortality schedule. It gives numerically identical results to e.g. \code{sen_arriaga_sym_instantaneous()} and \code{sen_chandrasekaran_II_instantaneous()}.
}
\examples{
a <- 0.001
b <- 0.07
x <- 0:100
mx <- a * exp(x * b)
s <- sen_lopez_ruzicka_sym_instantaneous(mx, age = x)
\donttest{
plot(x, s, type = "l")
}
}
\seealso{
\code{\link{sen_lopez_ruzicka_sym}}, \code{\link{sen_lopez_ruzicka_sym_instantaneous2}}, \code{\link{sen_arriaga_sym_instantaneous}}
}
