% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExtractData.R
\name{getEunomiaPlpData}
\alias{getEunomiaPlpData}
\title{Create a plpData object from the Eunomia database'}
\usage{
getEunomiaPlpData(covariateSettings = NULL)
}
\arguments{
\item{covariateSettings}{A list of covariateSettings objects created using the
\code{createCovariateSettings} function in the \code{FeatureExtraction} package.
If nothing is specified covariates with age, gender, conditions and drug era are used.}
}
\value{
An object of type \code{plpData}, containing information on the cohorts, their
outcomes, and baseline covariates. Information about multiple outcomes can be
captured at once for efficiency reasons. This object is a list with the
following components: \describe{ \item{outcomes}{A data frame listing the
outcomes per person, including the time to event, and the outcome id}
\item{cohorts}{A data frame listing the persons in each cohort, listing their
exposure status as well as the time to the end of the observation period and
time to the end of the cohort} \item{covariateData}{An Andromeda object created
with the \code{FeatureExtraction} package. This object contains the following items:
\describe{ \item{covariates}{An Andromeda table listing the covariates per
person in the two cohorts. This is done using a sparse representation:
covariates with a value of 0 are omitted to save space. Usually has three
columns, rowId, covariateId and covariateValue'.} \item{covariateRef}{An
Andromeda table describing the covariates that have been extracted.}
\item{AnalysisRef}{An Andromeda table with information about which analysisIds
from 'FeatureExtraction' were used.} }}}
}
\description{
This function creates a plpData object from the Eunomia database. It gets
the connection details, creates the cohorts, and extracts the data. The cohort
is predicting GIbleed in new users of celecoxib.
}
\examples{
\dontshow{if (rlang::is_installed("Eunomia") && rlang::is_installed("curl") && curl::has_internet()) withAutoprint(\{ # examplesIf}
\donttest{ \dontshow{ # takes too long }
covariateSettings <- FeatureExtraction::createCovariateSettings(
  useDemographicsAge = TRUE,
  useDemographicsGender = TRUE,
  useConditionOccurrenceAnyTimePrior = TRUE
)
plpData <- getEunomiaPlpData(covariateSettings = covariateSettings)
}
\dontshow{\}) # examplesIf}
}
