// Title: The Pardo statistic for uniformity
// Ref. (book or article): Pardo, M. C. (2003), A test for uniformity based on informational energy,
//                         Statistical Papers, 44, 521-534.
// Y. Marhuenda, D. Morales & M. C. Pardo, (2005), A comparison of uniformity tests, 
// A Journal of Theoretical and Applied Statistics, 39:4, 315-327

#include <R.h>
#include "Rmath.h"

extern "C" {

  void stat79(double *x, int *xlen, double *level, int *nblevel, char **name, int *getname, double *statistic, int *pvalcomp, double *pvalue, double *critvalL, double *critvalR, int *usecrit, int *alter, int *decision, double *paramstat, int *nbparamstat) {

// If the test statistic can only be in category 3 or 4 (see just below), INDICATE the following line accordingly. Else, leave it commented.
// 0: two.sided=bilateral, 1: less=unilateral, 2: greater=unilateral, 3: bilateral test that rejects H0 only for large values of the test statistic, 
// 4: bilateral test that rejects H0 only for small values of the test statistic
    alter[0] = 3;

    int i, j=0, n=xlen[0];
    if (getname[0] == 1) {    
// Here, INDICATE the name of your statistic
      const char *nom = "$E_{m,n}$";
// Here, INDICATE the number of parameters of your statistic
      nbparamstat[0] = 1;
// Here, INDICATE the default values of the parameters:
      if (name[0][0] == '1') { // To prevent writing in a non declared address (because maybe paramstat has not be initialized with a sufficient length since the correct value of nbparamstat[0] may be unkown yet).
      paramstat[0] = 2.0;
     }
// The following 7 lines should NOT be modified
      const char *space = " ";
      while (nom[j] != '\0') {
	name[j][0] = nom[j];
	j++;
      }
      for (i=j;i<50;i++) name[i][0] = space[0];
      return;
    }

// Initialization of the parameters
    int m;
    if (nbparamstat[0] == 0) {
      nbparamstat[0] = 1;
      m = 2;
      paramstat[0] = 2.0;
    } else if (nbparamstat[0] == 1) {
      m = (int)paramstat[0];
    } else {
      Rf_error("Number of parameters should be at most: 1");
    }

    // If necessary, we check if some parameter values are out of parameter space
    if (m > (n + 1)) {
      Rf_warning("m should be <= n+1 in stat79!\n");
      for (i = 0; i < n; i++) x[i] = R_NaN;
      return;
    }

	
    if (n>3) {
// Computation of the value of the test statistic
    void R_rsort (double* x, int n);
    double punif(double q, double min, double max, int lower_tail, int log_p);
    double *U;
    U = new double[n];
    double temp1, temp2, statEn;
    
    // generate vector U
    for (i = 0; i < n; i++) {
      U[i] = punif(x[i], 0.0, 1.0, 1, 0);
    }
    R_rsort(U, n); // We sort the data
    
    // calculate statEn
    statEn = 0.0;
    for (i = 0; i < n; i++) {
      if (i < m) temp2 = U[0]; else temp2 = U[i-m];
      if (i > (n - m- 1 )) temp1 = U[n-1]; else temp1 = U[i+m];
      statEn = statEn + (double)(2 * m) / ((double)n * (temp1 - temp2));
    }
    statEn = statEn / (double)n;
	
    statistic[0] = statEn; // Here is the test statistic value
	

if (pvalcomp[0] == 1) {
	// If possible, computation of the p-value.
	#include "pvalues/pvalue79.cpp"
}

// We take the decision to reject or not to reject the null hypothesis H0
 for (i = 0; i <= (nblevel[0] - 1); i++) {
   if (usecrit[0] == 1) { // We use the provided critical values
     if (statistic[0] > critvalR[i]) decision[i] = 1; else decision[i] = 0; // two.sided (but in this case only one possible critical value)
   } else {
     if (pvalue[0] < level[i]) decision[i] = 1; else decision[i] = 0; // We use the p-value
   }
 }
    
// If applicable, we free the unused array of pointers
 delete[] U;

}

// We return
    return;
       
  }
  
  
  
}
