% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_data_processing.R
\name{matched_fig}
\alias{matched_fig}
\title{Providing a time dependent matched_index() function}
\usage{
matched_fig(
  data,
  start,
  end,
  base = "start",
  type = "prodID",
  fixedbase = TRUE,
  figure = TRUE,
  date_breaks = "1 month"
)
}
\arguments{
\item{data}{The user's data frame. It must contain a column \code{time} (as Date in format: year-month-day,e.g. '2020-12-01') and also a column indicated by the \code{type} parameter.}

\item{start}{The beginning of a time interval (as character) limited to the year and month, e.g. "2019-03".}

\item{end}{The end of a time interval (as character) limited to the year and month, e.g. "2019-04".}

\item{base}{The base period (as character) for product comparisons. Its possible values are: "start" and "end".}

\item{type}{This parameter defines the column which is used in the procedure. Possible values of the \code{type} parameter are: \code{retID}, \code{prodID}, \code{codeIN}, \code{codeOUT} or \code{description}.}

\item{fixedbase}{A logical parameter indicating whether the procedure is to work for subsequent months from the considered time interval (\code{fixedbase}=FALSE). Otherwise the period defined by \code{base} plays a role of fixed base month (\code{fixedbase}=TRUE)}

\item{figure}{A logical parameter indicating whether the function returns a figure (TRUE) or a data frame (FALSE) with \code{\link{matched_index}} values.}

\item{date_breaks}{A string giving the distance between breaks on the X axis like "1 month" (default value) or "4 months".}
}
\value{
The function returns a data frame or a figure presenting the \code{\link{matched_index}} function calculated for the column defined by the \code{type} parameter and for each month from the considered time interval. The interval is set by \code{start} and \code{end} parameters. The returned object (data frame or figure) depends on the value of \code{figure} parameter. The returned values belong to [0,1].
}
\description{
The function provides a data frame or a figure presenting the \code{\link{matched_index}} function calculated for the column defined by the \code{type} parameter and for each month from the considered time interval
}
\examples{
\donttest{matched_fig(milk, start="2018-12", end="2019-12")}
\donttest{matched_fig(milk, start="2018-12", end="2019-12", figure=FALSE)}
}
