% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qrglasso.R
\name{plot.qrglasso}
\alias{plot.qrglasso}
\title{Display BIC Results from \code{qrglasso}}
\usage{
\method{plot}{qrglasso}(x, ...)
}
\arguments{
\item{x}{An object of class \code{qrglasso} for the \code{plot} method.}

\item{...}{Additional parameters not used directly.}
}
\value{
\code{NULL}
}
\description{
Visualize the HDIC BIC results corresponding to hyperparameters obtained from \code{qrglasso}.
}
\examples{
set.seed(123)
n <- 100
p <- 5
L <- 5
Y <- matrix(rnorm(n), n, 1)
W <- matrix(rnorm(n * p * (L - 1)), n, p * (L - 1))

# Call qrglasso with default parameters
result <- qrglasso(Y = Y, W = W, p = p)

# Visualize the BIC results
plot(result)

}
\seealso{
\code{\link{qrglasso}}
}
