#' Functions for converting pixels and centimeters
#'
#' \code{cm2px} - Converts centimeters to pixels.
#'
#' @param cm Numeric value or numeric vector (centimeters) to be converted
#' to pixels.
#' @param ppcm Numeric value or numeric vector (default NULL) of the same length
#' as \code{cm} or \code{px} specifying how many pixels there are per
#' centimeter.
#' If \code{ppcm} is not NULL, \code{ppi} is ignored.\cr
#' Examples: 300 ppi (printing) is 118 ppcm, 150 ppi is 59 ppcm,
#' 72 ppi (screens) is 28 ppcm.
#' @param ppi Numeric value or numeric vector (default NULL) of the same length
#' as \code{cm} or \code{px} specifying how many pixels there are per inch.
#' Set \code{ppcm} to NULL to use \code{ppi}.\cr
#' Examples: 300 ppi (printing) is 118 ppcm, 150 ppi is 59 ppcm,
#' 72 ppi (screens) is 28 ppcm.
#'
#' @return \code{cm2px} Numeric value or numeric vector (pixels).
#'
#' @export
#' @rdname convert_px_cm
#'
#' @examples
#' cm2px(2, 4)
cm2px <- function(cm, ppcm = NULL, ppi = NULL) {
  if (is.null(ppcm)) {
    px <- cm * ppi2ppcm(ppi)
  } else {
    px <- cm * ppcm
  }
  return(px)
}
#' Functions for converting pixels and centimeters
#'
#' \code{px2cm} - Converts pixels to centimeters.
#'
#' @param px Numeric value or numeric vector (pixels) to be converted to
#' centimeters.
#'
#' @return \code{px2cm} Numeric value or numeric vector (centimeters).
#'
#' @export
#' @rdname convert_px_cm
#'
#' @examples
#' px2cm(2, 4)
px2cm <- function(px, ppcm = NULL, ppi = NULL) {
  if (is.null(ppcm)) {
    cm <- px / ppi2ppcm(ppi)
  } else {
    cm <- px / ppcm
  }
  return(cm)
}
