% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree.R
\name{NW_Tree}
\alias{NW_Tree}
\title{Fit a Structural Forest Heterogeneous Newsvendor tree}
\usage{
NW_Tree(
  data,
  honest_ratio = 1,
  min_size = 50,
  max_depth = 50,
  features = NULL,
  approximate = FALSE,
  max_candidates = 256,
  leaf_round_digits = 1L
)
}
\arguments{
\item{data}{A data frame or output from \code{\link[=NW_prepare]{NW_prepare()}}.}

\item{honest_ratio}{Ratio of the estimation subsample to the splitting subsample.}

\item{min_size}{Minimum number of observations in each child node.}

\item{max_depth}{Maximum depth of the tree.}

\item{features}{Optional subset of features (names or indices) to consider at each split.}

\item{approximate}{Logical; if \code{TRUE}, limit candidate split points for speed.}

\item{max_candidates}{Maximum candidate split points per feature when \code{approximate = TRUE}.}

\item{leaf_round_digits}{Control the rounding of demand samples when fitting leaf CDFs.
Use negative values to disable rounding.}
}
\value{
A list representing the fitted tree.
}
\description{
Builds an honest tree that estimates the structural parameter of the heterogeneous
newsvendor model using the SFHNV algorithm.
}
\examples{
data <- data.frame(x1 = rnorm(200), x2 = rnorm(200), D = rnorm(200), Q = rnorm(200))
tree <- NW_Tree(data, min_size = 20, max_depth = 5)
preds <- predict_tree(tree, data)
}
