% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SLRMss.R
\name{SLRMss}
\alias{SLRMss}
\title{Symmetric Linear Regression Models for small samples}
\usage{
SLRMss(formula, family, xi, statistic, testingbeta, data)
}
\arguments{
\item{formula}{An object of class \code{formula} (or one that can be coerced to that class): a symbolic description of the model to be fitted.}

\item{family}{A description of the error distribution to be used in the model. There are four supported families, Normal, t-Student, Power Exponential and Logistic ("Normal", "Student", "Powerexp" and "Logistic", respectively)}

\item{xi}{An extra parameter of some specified error distribution. For t-Student is a positive value and for Power Exponential is a real number between -1 and 1/3.}

\item{statistic}{The statistic which will be used. It includes "Wald", "LR", "Score" or "Gradient".}

\item{testingbeta}{A vector containing the names of the variables to be testing.}

\item{data}{An optional data frame containing the variables in the model.}
}
\value{
A list with the following components

\item{beta.coefficients}{A matrix with the estimated position parameters under alternative hypothesis.}

\item{phi}{A numeric value with the estimated precision paramater under alternative hypothesis.}

\item{beta.coefficients.h0}{A matrix with the estimated position parameters under null hypothesis.}

\item{phi.h0}{A numeric value with the estimated precision paramater under null hypothesis.}

\item{y.fitted}{A vector with the fitted values of the model.}

\item{null.hypothesis}{The description of the null hypothesis.}

\item{statistics}{A matrix with the selected statistics and theirs p-values. The corrected statistic is marked with an asterisk.}

\item{statistic.distribution}{The name of the statistics' distribution used to test null hypothesis. It always return "Chi-Squared".}

\item{df}{The degrees of freedom of the statistics' distribution. It's the length of the testingbeta vector.}

\item{residuals}{The difference among the real y values and the fitted y.}

\item{std.residuals}{The residuals divided by the precision parameter}

\item{AICc}{The corrected Akaike Information Criterion for small samples.}

\item{BIC}{The Bayesian Information Criterion.}
}
\description{
Computes Wald, Likelihood Ratio, Score, or Gradient statistics for symmetric linear regression models. Also computes modified versions of the Likelihood Ratio, Score, and Gradient tests for small sample sizes.
}
\examples{
data(orange)
fit1 <- SLRMss(emulsion ~ arabicgum + xanthangum + orangeoil, family="Student", 
xi=3, testingbeta="xanthangum", statistic="LR", data=orange)
print(fit1)

data(cheese)
fit2 <- SLRMss(cohe ~ fat + xangum + sodcase, family="Normal", 
testingbeta=c("xangum","sodcase"), statistic="Gradient", data=cheese)
print(fit2)
}
\references{
Medeiros, F. M. C and Ferrari, S. L. P. (2017). Small-sample testing inference in symmetric and log-symmetric linear regression models, Statistica Neerlandica. \doi{10.1111/stan.12107}.
}
