% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.SLRMss.R
\name{coef.SLRMss}
\alias{coef.SLRMss}
\title{Extract the model coefficients for a SLRMss object}
\usage{
\method{coef}{SLRMss}(object, H0 = FALSE, ...)
}
\arguments{
\item{object}{An object of class \code{SLRMss}.}

\item{H0}{If TRUE, choose the coefficients under the null hypothesis, if FALSE, choose the coefficients under alternative hypothesis (default).}

\item{...}{Currently ignored.}
}
\value{
Coefficients extracted from the SLRMss object.
}
\description{
This function provides the coefficients of a \code{SLRMss} model.
}
\examples{
data(orange)
fit <- SLRMss(emulsion ~ arabicgum + xanthangum + orangeoil, family="Student",
xi=3, testingbeta="xanthangum", statistic="LR", data=orange)
coef(fit)
}
