% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{WeightsLSKEW}
\alias{WeightsLSKEW}
\title{Linear Skewness (LSKEW) weightings for a pooling group}
\usage{
WeightsLSKEW(x)
}
\arguments{
\item{x}{pooling group derived with the Pool() function}
}
\value{
A data.frame with site references in the first column and associated weights in the second
}
\description{
Provides the LSKEW weights for each site in a pooling group
}
\details{
Weighting method for FEH2025.
}
\examples{
# Get some CDs, form an ungauged pooling group, and estimate ungauged LSkew
cds_27051 <- GetCDs(27051)
pool_27051 <- Pool(cds_27051, exclude = 27051)
WeightsLSKEW(pool_27051)

}
\author{
Anthony Hammond
}
