% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heritability.R
\name{heritability_fa}
\alias{heritability_fa}
\title{Heritability for Factor Analytic Models in ASReml-R}
\usage{
heritability_fa(
  model_fa = NULL,
  genotype = "line",
  env = "loc",
  vc_model = c("fa2"),
  diag = FALSE
)
}
\arguments{
\item{model_fa}{Factor Analytic ASReml model}

\item{genotype}{A character string indicating the column in data that
contains genotypes.}

\item{env}{A character string indicating the column in data that contains
environments or trials.}

\item{vc_model}{A character string indicating the variance-covariance
structure. Can be "fa1", "fa2", "fa3", "fa4" or "us".}

\item{diag}{\code{TRUE} or \code{FALSE} depending on the user if they want to
take the elements on the diagonal of the variance-covariance matrix or the
elements out of the diagonal to estimate the heritability. \code{FALSE} by
default.}
}
\value{
An object with a list of:
\item{h2_cullis}{A numerical value of the Cullis heritability estimate.}
\item{h2_se}{A numerical value of the Cullis heritability estimate based on
 the standard error.}
}
\description{
Heritability for Factor Analytic Models in ASReml-R
}
\examples{
\dontrun{
library(agridat)
library(agriutilities)
data(besag.met)
dat <- besag.met
results <- check_design_met(
  data = dat,
  genotype = "gen",
  trial = "county",
  traits = c("yield"),
  rep = "rep",
  block = "block",
  col = "col",
  row = "row"
)
out <- single_trial_analysis(results, progress = FALSE)
met_results <- met_analysis(out, progress = FALSE)
model <- met_results$met_models$yield
heritability_fa(
   model_fa = model,
   genotype = "genotype",
   env = "trial",
   vc_model = "us"
 )
}
}
