# Test listing creation of l_ae_slide (Adverse Events Listing)

    Code
      l_ae_slide(adsl = adsl, adae = adae)
    Output
                                              Date of                                                             
                             Adverse        First Study               Caused by                             Action
                           Event MedDRA         Drug                    Study                               Taken 
      Center/Patient ID   Preferred Term   Administration   Serious     Drug      Analysis Toxicity Grade    (2)  
      ————————————————————————————————————————————————————————————————————————————————————————————————————————————
        BRA-1/id-134      dcd B.2.1.2.1      04NOV2020        No         No                  3                2   
                          dcd D.1.1.4.2      04NOV2020        No         No                  3                2   
                          dcd A.1.1.1.2      04NOV2020        Yes        No                  2                2   
                          dcd A.1.1.1.2      04NOV2020        Yes        No                  2                5   
        BRA-1/id-141      dcd B.2.1.2.1      25JUL2020        No         No                  3                1   
                          dcd D.2.1.5.3      25JUL2020        No         Yes                 1                1   
                          dcd A.1.1.1.1      25JUL2020        No         No                  1                3   
                          dcd A.1.1.1.2      25JUL2020        Yes        No                  2                2   
                          dcd A.1.1.1.1      25JUL2020        No         No                  1                1   
                          dcd D.1.1.1.1      25JUL2020        Yes        Yes                 5                6   
        BRA-1/id-236      dcd B.1.1.1.1      15JAN2021        Yes        Yes                 5                6   
                          dcd B.1.1.1.1      15JAN2021        Yes        Yes                 5                6   
                          dcd B.1.1.1.1      15JAN2021        Yes        Yes                 5                6   
        BRA-1/id-265      dcd C.2.1.2.1      07OCT2019        No         Yes                 2                5   
                          dcd D.1.1.4.2      07OCT2019        No         No                  3                7   
                          dcd D.1.1.1.1      07OCT2019        Yes        Yes                 5                6   
                          dcd C.1.1.1.3      07OCT2019        No         Yes                 4                7   
         BRA-1/id-42      dcd C.2.1.2.1      01JAN2020        No         Yes                 2                6   
                          dcd D.1.1.1.1      01JAN2020        Yes        Yes                 5                6   
                          dcd C.2.1.2.1      01JAN2020        No         Yes                 2                2   
                          dcd A.1.1.1.2      01JAN2020        Yes        No                  2                2   
                          dcd B.2.2.3.1      01JAN2020        Yes        No                  1                2   
                          dcd A.1.1.1.2      01JAN2020        Yes        No                  2                2   
                          dcd B.1.1.1.1      01JAN2020        Yes        Yes                 5                6   
                          dcd A.1.1.1.2      01JAN2020        Yes        No                  2                2   
                          dcd C.1.1.1.3      01JAN2020        No         Yes                 4                2   
                          dcd B.1.1.1.1      01JAN2020        Yes        Yes                 5                6   
         BRA-1/id-65      dcd C.2.1.2.1      15JUL2019        No         Yes                 2                2   
                          dcd D.2.1.5.3      15JUL2019        No         Yes                 1                2   
                          dcd B.1.1.1.1      15JUL2019        Yes        Yes                 5                6   
                          dcd C.1.1.1.3      15JUL2019        No         Yes                 4                3   
         BRA-1/id-93      dcd D.1.1.4.2      20JUN2020        No         No                  3                2   
                          dcd D.2.1.5.3      20JUN2020        No         Yes                 1                3   
                          dcd A.1.1.1.1      20JUN2020        No         No                  1                2   
                          dcd D.2.1.5.3      20JUN2020        No         Yes                 1                2   
                          dcd C.1.1.1.3      20JUN2020        No         Yes                 4                2   
                          dcd D.1.1.1.1      20JUN2020        Yes        Yes                 5                6   
                          dcd B.1.1.1.1      20JUN2020        Yes        Yes                 5                6   
                          dcd D.2.1.5.3      20JUN2020        No         Yes                 1                3   
                          dcd B.2.2.3.1      20JUN2020        Yes        No                  1                2   
        BRA-11/id-237     dcd D.2.1.5.3      10MAR2020        No         Yes                 1                6   
                          dcd C.1.1.1.3      10MAR2020        No         Yes                 4                5   
                          dcd B.2.1.2.1      10MAR2020        No         No                  3                3   
        BRA-11/id-321     dcd A.1.1.1.1      06OCT2020        No         No                  1                2   
                          dcd A.1.1.1.1      06OCT2020        No         No                  1                2   
                          dcd C.2.1.2.1      06OCT2020        No         Yes                 2                2   
                          dcd A.1.1.1.2      06OCT2020        Yes        No                  2                6   
                          dcd D.2.1.5.3      06OCT2020        No         Yes                 1                2   
                          dcd D.2.1.5.3      06OCT2020        No         Yes                 1                2   
                          dcd A.1.1.1.1      06OCT2020        No         No                  1                2   
                          dcd B.2.1.2.1      06OCT2020        No         No                  3                3   
                          dcd B.1.1.1.1      06OCT2020        Yes        Yes                 5                6   
        BRA-11/id-345     dcd B.2.1.2.1      18AUG2020        No         No                  3                5   
                          dcd D.1.1.4.2      18AUG2020        No         No                  3                3   
                          dcd A.1.1.1.1      18AUG2020        No         No                  1                2   
                          dcd B.1.1.1.1      18AUG2020        Yes        Yes                 5                6   
        BRA-11/id-397     dcd B.2.1.2.1      27JUN2020        No         No                  3                6   
                          dcd D.1.1.4.2      27JUN2020        No         No                  3                2   
                          dcd D.1.1.4.2      27JUN2020        No         No                  3                1   
                          dcd D.1.1.1.1      27JUN2020        Yes        Yes                 5                6   
                          dcd D.2.1.5.3      27JUN2020        No         Yes                 1                1   
                          dcd B.1.1.1.1      27JUN2020        Yes        Yes                 5                6   
        BRA-11/id-50      dcd D.1.1.4.2      28APR2019        No         No                  3                5   
                          dcd C.1.1.1.3      28APR2019        No         Yes                 4                7   
                          dcd A.1.1.1.2      28APR2019        Yes        No                  2                2   
         BRA-11/id-9      dcd D.1.1.4.2      25MAR2019        No         No                  3                3   
                          dcd B.2.2.3.1      25MAR2019        Yes        No                  1                2   
                          dcd D.1.1.1.1      25MAR2019        Yes        Yes                 5                6   
                          dcd B.1.1.1.1      25MAR2019        Yes        Yes                 5                6   
                          dcd B.2.2.3.1      25MAR2019        Yes        No                  1                2   
                          dcd C.2.1.2.1      25MAR2019        No         Yes                 2                3   
                          dcd C.2.1.2.1      25MAR2019        No         Yes                 2                6   
                          dcd B.2.1.2.1      25MAR2019        No         No                  3                2   
        BRA-12/id-59      dcd D.1.1.1.1      25NOV2019        Yes        Yes                 5                6   
                          dcd B.2.2.3.1      25NOV2019        Yes        No                  1                2   
                          dcd D.1.1.4.2      25NOV2019        No         No                  3                7   
                          dcd D.2.1.5.3      25NOV2019        No         Yes                 1                2   
                          dcd B.2.1.2.1      25NOV2019        No         No                  3                3   
                          dcd C.2.1.2.1      25NOV2019        No         Yes                 2                3   
                          dcd B.2.1.2.1      25NOV2019        No         No                  3                3   
                          dcd D.2.1.5.3      25NOV2019        No         Yes                 1                3   
                          dcd C.1.1.1.3      25NOV2019        No         Yes                 4                6   
                          dcd D.1.1.4.2      25NOV2019        No         No                  3                3   
        BRA-13/id-177     dcd B.2.1.2.1      30AUG2020        No         No                  3                2   
                          dcd D.2.1.5.3      30AUG2020        No         Yes                 1                5   
                          dcd B.1.1.1.1      30AUG2020        Yes        Yes                 5                6   
                          dcd C.1.1.1.3      30AUG2020        No         Yes                 4                3   
                          dcd B.2.1.2.1      30AUG2020        No         No                  3                2   
                          dcd B.1.1.1.1      30AUG2020        Yes        Yes                 5                6   
        BRA-14/id-120     dcd A.1.1.1.2      19SEP2020        Yes        No                  2                5   
                          dcd A.1.1.1.2      19SEP2020        Yes        No                  2                2   
                          dcd A.1.1.1.2      19SEP2020        Yes        No                  2                2   
                          dcd D.2.1.5.3      19SEP2020        No         Yes                 1                2   
                          dcd A.1.1.1.2      19SEP2020        Yes        No                  2                3   
                          dcd A.1.1.1.2      19SEP2020        Yes        No                  2                5   
                          dcd A.1.1.1.1      19SEP2020        No         No                  1                3   
                          dcd C.2.1.2.1      19SEP2020        No         Yes                 2                2   
                          dcd C.2.1.2.1      19SEP2020        No         Yes                 2                1   
                          dcd B.2.2.3.1      19SEP2020        Yes        No                  1                7   
        BRA-14/id-23      dcd B.2.1.2.1      06NOV2019        No         No                  3                2   
                          dcd D.2.1.5.3      06NOV2019        No         Yes                 1                3   
                          dcd C.1.1.1.3      06NOV2019        No         Yes                 4                7   
        BRA-15/id-36      dcd D.1.1.4.2      08JAN2020        No         No                  3                6   
                          dcd B.1.1.1.1      08JAN2020        Yes        Yes                 5                6   
                          dcd D.1.1.4.2      08JAN2020        No         No                  3                3   
                          dcd A.1.1.1.2      08JAN2020        Yes        No                  2                2   
        BRA-2/id-101      dcd B.2.1.2.1      26JUN2020        No         No                  3                2   
                          dcd A.1.1.1.1      26JUN2020        No         No                  1                2   
                          dcd A.1.1.1.2      26JUN2020        Yes        No                  2                2   
                          dcd C.1.1.1.3      26JUN2020        No         Yes                 4                2   
                          dcd A.1.1.1.1      26JUN2020        No         No                  1                1   
                          dcd D.1.1.4.2      26JUN2020        No         No                  3                5   
        BRA-2/id-296      dcd B.2.1.2.1      22JAN2021        No         No                  3                7   
                          dcd A.1.1.1.2      22JAN2021        Yes        No                  2                2   
                          dcd C.1.1.1.3      22JAN2021        No         Yes                 4                1   
                          dcd D.2.1.5.3      22JAN2021        No         Yes                 1                2   
                          dcd A.1.1.1.2      22JAN2021        Yes        No                  2                2   
                          dcd D.2.1.5.3      22JAN2021        No         Yes                 1                6   
                          dcd B.1.1.1.1      22JAN2021        Yes        Yes                 5                6   
         BRA-3/id-8       dcd A.1.1.1.1      12MAR2020        No         No                  1                2   
                          dcd D.2.1.5.3      12MAR2020        No         Yes                 1                2   
                          dcd A.1.1.1.2      12MAR2020        Yes        No                  2                3   
                          dcd C.1.1.1.3      12MAR2020        No         Yes                 4                1   
        BRA-4/id-368      dcd A.1.1.1.1      25FEB2020        No         No                  1                1   
                          dcd C.2.1.2.1      25FEB2020        No         Yes                 2                5   
                          dcd D.2.1.5.3      25FEB2020        No         Yes                 1                1   
                          dcd D.1.1.1.1      25FEB2020        Yes        Yes                 5                6   
                          dcd B.1.1.1.1      25FEB2020        Yes        Yes                 5                6   
                          dcd A.1.1.1.1      25FEB2020        No         No                  1                3   
        BRA-4/id-383      dcd A.1.1.1.2      18JAN2020        Yes        No                  2                6   
                          dcd A.1.1.1.2      18JAN2020        Yes        No                  2                7   
                          dcd D.2.1.5.3      18JAN2020        No         Yes                 1                5   
                          dcd B.2.1.2.1      18JAN2020        No         No                  3                7   
                          dcd D.2.1.5.3      18JAN2020        No         Yes                 1                3   
                          dcd B.2.2.3.1      18JAN2020        Yes        No                  1                6   
                          dcd C.1.1.1.3      18JAN2020        No         Yes                 4                3   
                          dcd A.1.1.1.1      18JAN2020        No         No                  1                5   
                          dcd B.1.1.1.1      18JAN2020        Yes        Yes                 5                6   
        BRA-5/id-234      dcd D.2.1.5.3      22JUN2019        No         Yes                 1                2   
                          dcd D.1.1.4.2      22JUN2019        No         No                  3                2   
                          dcd B.1.1.1.1      22JUN2019        Yes        Yes                 5                6   
                          dcd B.1.1.1.1      22JUN2019        Yes        Yes                 5                6   
                          dcd A.1.1.1.1      22JUN2019        No         No                  1                3   
                          dcd D.1.1.1.1      22JUN2019        Yes        Yes                 5                6   
                          dcd B.2.1.2.1      22JUN2019        No         No                  3                6   
                          dcd B.2.1.2.1      22JUN2019        No         No                  3                2   
        BRA-6/id-369      dcd A.1.1.1.1      13AUG2020        No         No                  1                2   
                          dcd C.1.1.1.3      13AUG2020        No         Yes                 4                6   
                          dcd B.2.1.2.1      13AUG2020        No         No                  3                6   
        BRA-7/id-301      dcd A.1.1.1.2      25JUL2019        Yes        No                  2                2   
                          dcd D.1.1.4.2      25JUL2019        No         No                  3                2   
                          dcd D.2.1.5.3      25JUL2019        No         Yes                 1                2   
                          dcd B.2.1.2.1      25JUL2019        No         No                  3                1   
                          dcd B.2.2.3.1      25JUL2019        Yes        No                  1                2   
                          dcd A.1.1.1.1      25JUL2019        No         No                  1                2   
                          dcd D.1.1.4.2      25JUL2019        No         No                  3                3   
         CAN-1/id-18      dcd A.1.1.1.1      02JAN2021        No         No                  1                3   
                          dcd B.2.2.3.1      02JAN2021        Yes        No                  1                2   
                          dcd B.2.1.2.1      02JAN2021        No         No                  3                7   
                          dcd A.1.1.1.1      02JAN2021        No         No                  1                6   
                          dcd B.2.2.3.1      02JAN2021        Yes        No                  1                2   
                          dcd A.1.1.1.2      02JAN2021        Yes        No                  2                3   
                          dcd A.1.1.1.1      02JAN2021        No         No                  1                5   
                          dcd D.2.1.5.3      02JAN2021        No         Yes                 1                2   
        CAN-1/id-341      dcd A.1.1.1.2      23MAY2019        Yes        No                  2                2   
                          dcd B.2.1.2.1      23MAY2019        No         No                  3                2   
                          dcd B.1.1.1.1      23MAY2019        Yes        Yes                 5                6   
                          dcd A.1.1.1.2      23MAY2019        Yes        No                  2                1   
                          dcd A.1.1.1.2      23MAY2019        Yes        No                  2                3   
                          dcd A.1.1.1.1      23MAY2019        No         No                  1                2   
                          dcd C.2.1.2.1      23MAY2019        No         Yes                 2                2   
                          dcd A.1.1.1.2      23MAY2019        Yes        No                  2                2   
        CAN-11/id-139     dcd D.2.1.5.3      15SEP2020        No         Yes                 1                2   
                          dcd D.1.1.1.1      15SEP2020        Yes        Yes                 5                6   
                          dcd A.1.1.1.2      15SEP2020        Yes        No                  2                2   
                          dcd C.2.1.2.1      15SEP2020        No         Yes                 2                2   
                          dcd A.1.1.1.2      15SEP2020        Yes        No                  2                6   
                          dcd C.1.1.1.3      15SEP2020        No         Yes                 4                2   
        CAN-11/id-306     dcd A.1.1.1.1      08JUN2020        No         No                  1                2   
                          dcd D.1.1.4.2      08JUN2020        No         No                  3                1   
                          dcd B.2.1.2.1      08JUN2020        No         No                  3                2   
                          dcd C.2.1.2.1      08JUN2020        No         Yes                 2                2   
                          dcd D.2.1.5.3      08JUN2020        No         Yes                 1                2   
                          dcd D.1.1.4.2      08JUN2020        No         No                  3                7   
        CAN-14/id-104     dcd D.2.1.5.3      28JUN2019        No         Yes                 1                3   
                          dcd D.2.1.5.3      28JUN2019        No         Yes                 1                2   
                          dcd A.1.1.1.2      28JUN2019        Yes        No                  2                2   
                          dcd C.1.1.1.3      28JUN2019        No         Yes                 4                3   
        CAN-4/id-324      dcd D.1.1.1.1      17NOV2020        Yes        Yes                 5                6   
                          dcd A.1.1.1.1      17NOV2020        No         No                  1                3   
                          dcd C.2.1.2.1      17NOV2020        No         Yes                 2                2   
                          dcd A.1.1.1.1      17NOV2020        No         No                  1                1   
                          dcd B.2.2.3.1      17NOV2020        Yes        No                  1                5   
                          dcd B.1.1.1.1      17NOV2020        Yes        Yes                 5                6   
                          dcd B.2.2.3.1      17NOV2020        Yes        No                  1                2   
                          dcd A.1.1.1.1      17NOV2020        No         No                  1                2   
        CAN-4/id-331      dcd C.2.1.2.1      03MAY2020        No         Yes                 2                3   
                          dcd B.1.1.1.1      03MAY2020        Yes        Yes                 5                6   
                          dcd D.1.1.4.2      03MAY2020        No         No                  3                3   
        CHN-1/id-107      dcd D.2.1.5.3      31JUL2020        No         Yes                 1                2   
                          dcd B.2.2.3.1      31JUL2020        Yes        No                  1                2   
                          dcd B.1.1.1.1      31JUL2020        Yes        Yes                 5                6   
                          dcd B.2.2.3.1      31JUL2020        Yes        No                  1                2   
                          dcd B.1.1.1.1      31JUL2020        Yes        Yes                 5                6   
                          dcd B.2.2.3.1      31JUL2020        Yes        No                  1                3   
        CHN-1/id-119      dcd D.2.1.5.3      14JAN2020        No         Yes                 1                2   
                          dcd C.2.1.2.1      14JAN2020        No         Yes                 2                2   
                          dcd A.1.1.1.2      14JAN2020        Yes        No                  2                6   
         CHN-1/id-12      dcd C.2.1.2.1      20DEC2020        No         Yes                 2                6   
        CHN-1/id-123      dcd C.1.1.1.3      28JAN2020        No         Yes                 4                3   
                          dcd A.1.1.1.2      28JAN2020        Yes        No                  2                2   
                          dcd B.2.1.2.1      28JAN2020        No         No                  3                3   
                          dcd D.1.1.1.1      28JAN2020        Yes        Yes                 5                6   
                          dcd D.1.1.1.1      28JAN2020        Yes        Yes                 5                6   
                          dcd D.1.1.1.1      28JAN2020        Yes        Yes                 5                6   
                          dcd B.2.1.2.1      28JAN2020        No         No                  3                3   
        CHN-1/id-133      dcd B.1.1.1.1      08AUG2020        Yes        Yes                 5                6   
                          dcd B.1.1.1.1      08AUG2020        Yes        Yes                 5                6   
        CHN-1/id-144      dcd C.1.1.1.3      19FEB2020        No         Yes                 4                3   
                          dcd D.2.1.5.3      19FEB2020        No         Yes                 1                2   
                          dcd B.2.1.2.1      19FEB2020        No         No                  3                5   
        CHN-1/id-156      dcd D.2.1.5.3      06SEP2020        No         Yes                 1                3   
                          dcd D.1.1.1.1      06SEP2020        Yes        Yes                 5                6   
         CHN-1/id-16      dcd B.2.2.3.1      03JAN2021        Yes        No                  1                3   
                          dcd C.2.1.2.1      03JAN2021        No         Yes                 2                2   
                          dcd D.2.1.5.3      03JAN2021        No         Yes                 1                2   
                          dcd A.1.1.1.2      03JAN2021        Yes        No                  2                2   
                          dcd B.2.2.3.1      03JAN2021        Yes        No                  1                2   
                          dcd D.1.1.4.2      03JAN2021        No         No                  3                5   
                          dcd C.1.1.1.3      03JAN2021        No         Yes                 4                2   
                          dcd B.2.1.2.1      03JAN2021        No         No                  3                2   
                          dcd C.1.1.1.3      03JAN2021        No         Yes                 4                2   
                          dcd A.1.1.1.2      03JAN2021        Yes        No                  2                6   
        CHN-1/id-163      dcd D.1.1.4.2      27MAY2020        No         No                  3                7   
        CHN-1/id-181      dcd B.2.2.3.1      05MAY2020        Yes        No                  1                1   
                          dcd D.1.1.4.2      05MAY2020        No         No                  3                2   
                          dcd B.2.2.3.1      05MAY2020        Yes        No                  1                2   
                          dcd B.2.1.2.1      05MAY2020        No         No                  3                2   
                          dcd D.2.1.5.3      05MAY2020        No         Yes                 1                6   
                          dcd B.1.1.1.1      05MAY2020        Yes        Yes                 5                6   
                          dcd C.2.1.2.1      05MAY2020        No         Yes                 2                1   
        CHN-1/id-186      dcd C.2.1.2.1      02FEB2021        No         Yes                 2                3   
                          dcd B.1.1.1.1      02FEB2021        Yes        Yes                 5                6   
                          dcd B.1.1.1.1      02FEB2021        Yes        Yes                 5                6   
                          dcd D.1.1.4.2      02FEB2021        No         No                  3                1   
        CHN-1/id-197      dcd C.2.1.2.1      01JUN2020        No         Yes                 2                7   
                          dcd B.2.2.3.1      01JUN2020        Yes        No                  1                2   
                          dcd A.1.1.1.1      01JUN2020        No         No                  1                5   
                          dcd D.1.1.1.1      01JUN2020        Yes        Yes                 5                6   
                          dcd A.1.1.1.1      01JUN2020        No         No                  1                2   
                          dcd B.2.1.2.1      01JUN2020        No         No                  3                2   
                          dcd B.2.2.3.1      01JUN2020        Yes        No                  1                1   
                          dcd A.1.1.1.1      01JUN2020        No         No                  1                2   
                          dcd D.2.1.5.3      01JUN2020        No         Yes                 1                2   
        CHN-1/id-199      dcd A.1.1.1.1      08JAN2020        No         No                  1                3   
                          dcd D.1.1.4.2      08JAN2020        No         No                  3                6   
        CHN-1/id-208      dcd D.2.1.5.3      31JUL2020        No         Yes                 1                2   
                          dcd C.1.1.1.3      31JUL2020        No         Yes                 4                2   
                          dcd D.2.1.5.3      31JUL2020        No         Yes                 1                2   
                          dcd D.1.1.4.2      31JUL2020        No         No                  3                5   
                          dcd C.1.1.1.3      31JUL2020        No         Yes                 4                3   
                          dcd B.1.1.1.1      31JUL2020        Yes        Yes                 5                6   
                          dcd D.1.1.4.2      31JUL2020        No         No                  3                2   
                          dcd B.1.1.1.1      31JUL2020        Yes        Yes                 5                6   
                          dcd A.1.1.1.2      31JUL2020        Yes        No                  2                2   
        CHN-1/id-212      dcd C.1.1.1.3      30DEC2020        No         Yes                 4                2   
                          dcd D.1.1.1.1      30DEC2020        Yes        Yes                 5                6   
                          dcd C.1.1.1.3      30DEC2020        No         Yes                 4                3   
                          dcd B.2.1.2.1      30DEC2020        No         No                  3                1   
                          dcd D.2.1.5.3      30DEC2020        No         Yes                 1                2   
                          dcd B.1.1.1.1      30DEC2020        Yes        Yes                 5                6   
                          dcd C.2.1.2.1      30DEC2020        No         Yes                 2                1   
                          dcd D.1.1.1.1      30DEC2020        Yes        Yes                 5                6   
                          dcd C.1.1.1.3      30DEC2020        No         Yes                 4                2   
        CHN-1/id-216      dcd D.1.1.4.2      04OCT2020        No         No                  3                2   
                          dcd B.2.1.2.1      04OCT2020        No         No                  3                3   
                          dcd A.1.1.1.1      04OCT2020        No         No                  1                3   
                          dcd D.1.1.4.2      04OCT2020        No         No                  3                6   
                          dcd C.2.1.2.1      04OCT2020        No         Yes                 2                2   
                          dcd B.2.2.3.1      04OCT2020        Yes        No                  1                5   
                          dcd B.2.2.3.1      04OCT2020        Yes        No                  1                6   
                          dcd A.1.1.1.1      04OCT2020        No         No                  1                2   
        CHN-1/id-227      dcd C.1.1.1.3      09APR2019        No         Yes                 4                7   
                          dcd B.2.1.2.1      09APR2019        No         No                  3                2   
                          dcd C.1.1.1.3      09APR2019        No         Yes                 4                1   
                          dcd C.1.1.1.3      09APR2019        No         Yes                 4                3   
                          dcd A.1.1.1.2      09APR2019        Yes        No                  2                2   
                          dcd B.2.2.3.1      09APR2019        Yes        No                  1                6   
        CHN-1/id-233      dcd D.1.1.1.1      11FEB2021        Yes        Yes                 5                6   
        CHN-1/id-235      dcd A.1.1.1.1      13JUL2019        No         No                  1                3   
                          dcd D.1.1.4.2      13JUL2019        No         No                  3                1   
                          dcd D.1.1.1.1      13JUL2019        Yes        Yes                 5                6   
                          dcd B.1.1.1.1      13JUL2019        Yes        Yes                 5                6   
                          dcd A.1.1.1.2      13JUL2019        Yes        No                  2                6   
                          dcd D.1.1.4.2      13JUL2019        No         No                  3                5   
                          dcd B.2.2.3.1      13JUL2019        Yes        No                  1                3   
                          dcd C.1.1.1.3      13JUL2019        No         Yes                 4                3   
                          dcd B.2.1.2.1      13JUL2019        No         No                  3                2   
         CHN-1/id-25      dcd D.1.1.4.2      02NOV2020        No         No                  3                5   
                          dcd C.1.1.1.3      02NOV2020        No         Yes                 4                2   
                          dcd C.1.1.1.3      02NOV2020        No         Yes                 4                3   
                          dcd D.1.1.4.2      02NOV2020        No         No                  3                7   
        CHN-1/id-253      dcd A.1.1.1.2      25OCT2020        Yes        No                  2                3   
                          dcd A.1.1.1.2      25OCT2020        Yes        No                  2                3   
         CHN-1/id-26      dcd D.1.1.4.2      16JUL2020        No         No                  3                3   
                          dcd B.2.2.3.1      16JUL2020        Yes        No                  1                6   
                          dcd B.2.1.2.1      16JUL2020        No         No                  3                3   
                          dcd A.1.1.1.1      16JUL2020        No         No                  1                7   
                          dcd A.1.1.1.1      16JUL2020        No         No                  1                3   
                          dcd A.1.1.1.1      16JUL2020        No         No                  1                2   
                          dcd D.2.1.5.3      16JUL2020        No         Yes                 1                2   
                          dcd A.1.1.1.2      16JUL2020        Yes        No                  2                5   
                          dcd A.1.1.1.2      16JUL2020        Yes        No                  2                1   
        CHN-1/id-275      dcd D.1.1.4.2      02JUN2020        No         No                  3                2   
                          dcd C.2.1.2.1      02JUN2020        No         Yes                 2                3   
                          dcd A.1.1.1.1      02JUN2020        No         No                  1                1   
                          dcd A.1.1.1.2      02JUN2020        Yes        No                  2                5   
                          dcd B.1.1.1.1      02JUN2020        Yes        Yes                 5                6   
                          dcd A.1.1.1.2      02JUN2020        Yes        No                  2                2   
                          dcd D.1.1.4.2      02JUN2020        No         No                  3                2   
                          dcd D.1.1.1.1      02JUN2020        Yes        Yes                 5                6   
        CHN-1/id-276      dcd A.1.1.1.1      24OCT2020        No         No                  1                3   
        CHN-1/id-277      dcd B.1.1.1.1      14JAN2021        Yes        Yes                 5                6   
        CHN-1/id-279      dcd B.1.1.1.1      17MAR2020        Yes        Yes                 5                6   
                          dcd D.1.1.1.1      17MAR2020        Yes        Yes                 5                6   
                          dcd B.2.1.2.1      17MAR2020        No         No                  3                3   
                          dcd B.2.2.3.1      17MAR2020        Yes        No                  1                2   
                          dcd B.1.1.1.1      17MAR2020        Yes        Yes                 5                6   
                          dcd A.1.1.1.1      17MAR2020        No         No                  1                2   
                          dcd C.2.1.2.1      17MAR2020        No         Yes                 2                2   
                          dcd D.1.1.4.2      17MAR2020        No         No                  3                2   
        CHN-1/id-288      dcd A.1.1.1.2      11DEC2019        Yes        No                  2                3   
                          dcd C.1.1.1.3      11DEC2019        No         Yes                 4                3   
                          dcd A.1.1.1.1      11DEC2019        No         No                  1                6   
        CHN-1/id-312      dcd B.1.1.1.1      07FEB2020        Yes        Yes                 5                6   
        CHN-1/id-315      dcd A.1.1.1.1      21AUG2019        No         No                  1                3   
                          dcd D.1.1.1.1      21AUG2019        Yes        Yes                 5                6   
                          dcd D.1.1.1.1      21AUG2019        Yes        Yes                 5                6   
                          dcd B.2.2.3.1      21AUG2019        Yes        No                  1                2   
                          dcd D.1.1.4.2      21AUG2019        No         No                  3                2   
        CHN-1/id-316      dcd D.1.1.1.1      15SEP2020        Yes        Yes                 5                6   
                          dcd B.2.2.3.1      15SEP2020        Yes        No                  1                5   
                          dcd C.1.1.1.3      15SEP2020        No         Yes                 4                5   
                          dcd C.1.1.1.3      15SEP2020        No         Yes                 4                2   
                          dcd B.1.1.1.1      15SEP2020        Yes        Yes                 5                6   
                          dcd A.1.1.1.1      15SEP2020        No         No                  1                3   
                          dcd C.1.1.1.3      15SEP2020        No         Yes                 4                3   
                          dcd B.2.1.2.1      15SEP2020        No         No                  3                3   
                          dcd D.2.1.5.3      15SEP2020        No         Yes                 1                7   
        CHN-1/id-329      dcd A.1.1.1.1      06JUL2019        No         No                  1                2   
                          dcd D.1.1.1.1      06JUL2019        Yes        Yes                 5                6   
                          dcd D.1.1.1.1      06JUL2019        Yes        Yes                 5                6   
                          dcd B.2.2.3.1      06JUL2019        Yes        No                  1                2   
         CHN-1/id-33      dcd B.1.1.1.1      19DEC2020        Yes        Yes                 5                6   
                          dcd D.2.1.5.3      19DEC2020        No         Yes                 1                1   
                          dcd D.1.1.1.1      19DEC2020        Yes        Yes                 5                6   
                          dcd D.1.1.1.1      19DEC2020        Yes        Yes                 5                6   
                          dcd B.2.1.2.1      19DEC2020        No         No                  3                3   
                          dcd A.1.1.1.1      19DEC2020        No         No                  1                3   
                          dcd A.1.1.1.1      19DEC2020        No         No                  1                1   
                          dcd B.2.1.2.1      19DEC2020        No         No                  3                2   
        CHN-1/id-336      dcd B.2.2.3.1      24AUG2020        Yes        No                  1                2   
                          dcd C.1.1.1.3      24AUG2020        No         Yes                 4                6   
                          dcd C.1.1.1.3      24AUG2020        No         Yes                 4                2   
        CHN-1/id-337      dcd B.2.2.3.1      05JUN2020        Yes        No                  1                2   
                          dcd A.1.1.1.1      05JUN2020        No         No                  1                7   
                          dcd A.1.1.1.2      05JUN2020        Yes        No                  2                2   
                          dcd D.1.1.4.2      05JUN2020        No         No                  3                1   
                          dcd D.2.1.5.3      05JUN2020        No         Yes                 1                2   
                          dcd D.2.1.5.3      05JUN2020        No         Yes                 1                2   
                          dcd D.1.1.4.2      05JUN2020        No         No                  3                6   
        CHN-1/id-344      dcd A.1.1.1.1      16NOV2020        No         No                  1                3   
                          dcd B.2.2.3.1      16NOV2020        Yes        No                  1                6   
                          dcd D.1.1.4.2      16NOV2020        No         No                  3                2   
        CHN-1/id-346      dcd B.2.2.3.1      23NOV2019        Yes        No                  1                3   
                          dcd D.1.1.1.1      23NOV2019        Yes        Yes                 5                6   
        CHN-1/id-347      dcd B.1.1.1.1      26SEP2020        Yes        Yes                 5                6   
                          dcd B.2.1.2.1      26SEP2020        No         No                  3                2   
                          dcd C.1.1.1.3      26SEP2020        No         Yes                 4                2   
                          dcd D.1.1.1.1      26SEP2020        Yes        Yes                 5                6   
                          dcd A.1.1.1.1      26SEP2020        No         No                  1                2   
        CHN-1/id-351      dcd D.1.1.4.2      01AUG2020        No         No                  3                2   
                          dcd B.2.1.2.1      01AUG2020        No         No                  3                1   
                          dcd A.1.1.1.1      01AUG2020        No         No                  1                7   
                          dcd D.1.1.4.2      01AUG2020        No         No                  3                6   
                          dcd D.2.1.5.3      01AUG2020        No         Yes                 1                1   
                          dcd D.2.1.5.3      01AUG2020        No         Yes                 1                2   
        CHN-1/id-360      dcd C.1.1.1.3      12MAY2020        No         Yes                 4                2   
                          dcd B.2.1.2.1      12MAY2020        No         No                  3                1   
                          dcd C.1.1.1.3      12MAY2020        No         Yes                 4                2   
                          dcd A.1.1.1.1      12MAY2020        No         No                  1                6   
        CHN-1/id-371      dcd B.2.2.3.1      09FEB2021        Yes        No                  1                3   
                          dcd D.1.1.4.2      09FEB2021        No         No                  3                1   
                          dcd A.1.1.1.1      09FEB2021        No         No                  1                3   
                          dcd A.1.1.1.2      09FEB2021        Yes        No                  2                3   
                          dcd C.1.1.1.3      09FEB2021        No         Yes                 4                2   
                          dcd C.1.1.1.3      09FEB2021        No         Yes                 4                3   
                          dcd C.2.1.2.1      09FEB2021        No         Yes                 2                1   
                          dcd A.1.1.1.1      09FEB2021        No         No                  1                7   
        CHN-1/id-376      dcd D.1.1.4.2      30SEP2019        No         No                  3                2   
                          dcd A.1.1.1.1      30SEP2019        No         No                  1                2   
                          dcd D.1.1.1.1      30SEP2019        Yes        Yes                 5                6   
                          dcd B.2.1.2.1      30SEP2019        No         No                  3                3   
                          dcd C.2.1.2.1      30SEP2019        No         Yes                 2                2   
                          dcd D.1.1.1.1      30SEP2019        Yes        Yes                 5                6   
        CHN-1/id-400      dcd C.2.1.2.1      16SEP2019        No         Yes                 2                6   
                          dcd B.2.2.3.1      16SEP2019        Yes        No                  1                5   
                          dcd C.1.1.1.3      16SEP2019        No         Yes                 4                2   
                          dcd C.1.1.1.3      16SEP2019        No         Yes                 4                1   
                          dcd C.1.1.1.3      16SEP2019        No         Yes                 4                2   
                          dcd A.1.1.1.1      16SEP2019        No         No                  1                7   
                          dcd D.1.1.1.1      16SEP2019        Yes        Yes                 5                6   
                          dcd D.2.1.5.3      16SEP2019        No         Yes                 1                7   
                          dcd B.1.1.1.1      16SEP2019        Yes        Yes                 5                6   
                          dcd A.1.1.1.1      16SEP2019        No         No                  1                1   
         CHN-1/id-47      dcd B.2.2.3.1      19JAN2020        Yes        No                  1                2   
                          dcd A.1.1.1.1      19JAN2020        No         No                  1                2   
                          dcd D.2.1.5.3      19JAN2020        No         Yes                 1                2   
                          dcd B.2.1.2.1      19JAN2020        No         No                  3                4   
                          dcd C.1.1.1.3      19JAN2020        No         Yes                 4                6   
                          dcd D.1.1.1.1      19JAN2020        Yes        Yes                 5                6   
         CHN-1/id-53      dcd C.2.1.2.1      07NOV2019        No         Yes                 2                5   
                          dcd B.2.1.2.1      07NOV2019        No         No                  3                1   
                          dcd D.2.1.5.3      07NOV2019        No         Yes                 1                7   
                          dcd D.1.1.1.1      07NOV2019        Yes        Yes                 5                6   
         CHN-1/id-62      dcd B.2.1.2.1      22NOV2020        No         No                  3                2   
                          dcd C.1.1.1.3      22NOV2020        No         Yes                 4                2   
                          dcd D.2.1.5.3      22NOV2020        No         Yes                 1                2   
         CHN-1/id-64      dcd B.2.1.2.1      28APR2019        No         No                  3                1   
                          dcd D.1.1.1.1      28APR2019        Yes        Yes                 5                6   
                          dcd C.1.1.1.3      28APR2019        No         Yes                 4                2   
                          dcd D.2.1.5.3      28APR2019        No         Yes                 1                2   
                          dcd A.1.1.1.2      28APR2019        Yes        No                  2                3   
                          dcd A.1.1.1.2      28APR2019        Yes        No                  2                3   
                          dcd D.1.1.1.1      28APR2019        Yes        Yes                 5                6   
                          dcd D.1.1.1.1      28APR2019        Yes        Yes                 5                6   
                          dcd D.2.1.5.3      28APR2019        No         Yes                 1                3   
         CHN-1/id-69      dcd D.1.1.1.1      04APR2020        Yes        Yes                 5                6   
                          dcd C.2.1.2.1      04APR2020        No         Yes                 2                2   
         CHN-1/id-71      dcd D.1.1.1.1      24DEC2020        Yes        Yes                 5                6   
                          dcd A.1.1.1.2      24DEC2020        Yes        No                  2                5   
                          dcd C.1.1.1.3      24DEC2020        No         Yes                 4                2   
                          dcd C.1.1.1.3      24DEC2020        No         Yes                 4                6   
                          dcd B.2.1.2.1      24DEC2020        No         No                  3                2   
                          dcd B.1.1.1.1      24DEC2020        Yes        Yes                 5                6   
                          dcd A.1.1.1.2      24DEC2020        Yes        No                  2                2   
         CHN-1/id-74      dcd B.2.2.3.1      18JAN2020        Yes        No                  1                6   
                          dcd A.1.1.1.2      18JAN2020        Yes        No                  2                2   
                          dcd A.1.1.1.1      18JAN2020        No         No                  1                2   
                          dcd D.1.1.1.1      18JAN2020        Yes        Yes                 5                6   
                          dcd D.2.1.5.3      18JAN2020        No         Yes                 1                2   
                          dcd A.1.1.1.1      18JAN2020        No         No                  1                2   
                          dcd D.1.1.4.2      18JAN2020        No         No                  3                1   
                          dcd B.2.2.3.1      18JAN2020        Yes        No                  1                3   
                          dcd C.1.1.1.3      18JAN2020        No         Yes                 4                7   
                          dcd C.1.1.1.3      18JAN2020        No         Yes                 4                3   
         CHN-1/id-78      dcd A.1.1.1.2      21FEB2020        Yes        No                  2                1   
                          dcd C.2.1.2.1      21FEB2020        No         Yes                 2                7   
                          dcd D.2.1.5.3      21FEB2020        No         Yes                 1                2   
                          dcd B.1.1.1.1      21FEB2020        Yes        Yes                 5                6   
         CHN-1/id-86      dcd B.1.1.1.1      15MAY2020        Yes        Yes                 5                6   
                          dcd A.1.1.1.1      15MAY2020        No         No                  1                2   
                          dcd B.2.1.2.1      15MAY2020        No         No                  3                1   
                          dcd A.1.1.1.2      15MAY2020        Yes        No                  2                2   
                          dcd C.2.1.2.1      15MAY2020        No         Yes                 2                3   
                          dcd D.2.1.5.3      15MAY2020        No         Yes                 1                2   
                          dcd D.2.1.5.3      15MAY2020        No         Yes                 1                3   
                          dcd B.2.1.2.1      15MAY2020        No         No                  3                2   
                          dcd B.2.2.3.1      15MAY2020        Yes        No                  1                7   
                          dcd D.2.1.5.3      15MAY2020        No         Yes                 1                6   
         CHN-1/id-97      dcd A.1.1.1.2      20JAN2020        Yes        No                  2                7   
                          dcd D.1.1.4.2      20JAN2020        No         No                  3                7   
                          dcd B.2.2.3.1      20JAN2020        Yes        No                  1                3   
                          dcd D.2.1.5.3      20JAN2020        No         Yes                 1                3   
                          dcd B.2.2.3.1      20JAN2020        Yes        No                  1                2   
                          dcd C.1.1.1.3      20JAN2020        No         Yes                 4                1   
                          dcd D.1.1.1.1      20JAN2020        Yes        Yes                 5                6   
        CHN-11/id-113     dcd A.1.1.1.1      10JAN2021        No         No                  1                2   
                          dcd D.1.1.1.1      10JAN2021        Yes        Yes                 5                6   
                          dcd A.1.1.1.1      10JAN2021        No         No                  1                2   
                          dcd C.2.1.2.1      10JAN2021        No         Yes                 2                7   
                          dcd D.1.1.1.1      10JAN2021        Yes        Yes                 5                6   
                          dcd A.1.1.1.2      10JAN2021        Yes        No                  2                2   
                          dcd D.1.1.1.1      10JAN2021        Yes        Yes                 5                6   
                          dcd B.1.1.1.1      10JAN2021        Yes        Yes                 5                6   
        CHN-11/id-116     dcd B.2.1.2.1      15MAR2020        No         No                  3                4   
                          dcd D.1.1.1.1      15MAR2020        Yes        Yes                 5                6   
        CHN-11/id-124     dcd D.2.1.5.3      14JUL2019        No         Yes                 1                3   
                          dcd C.1.1.1.3      14JUL2019        No         Yes                 4                6   
                          dcd B.1.1.1.1      14JUL2019        Yes        Yes                 5                6   
                          dcd B.2.2.3.1      14JUL2019        Yes        No                  1                2   
                          dcd B.1.1.1.1      14JUL2019        Yes        Yes                 5                6   
                          dcd B.2.2.3.1      14JUL2019        Yes        No                  1                2   
                          dcd B.2.2.3.1      14JUL2019        Yes        No                  1                3   
        CHN-11/id-132     dcd D.1.1.4.2      27FEB2020        No         No                  3                2   
                          dcd D.2.1.5.3      27FEB2020        No         Yes                 1                2   
                          dcd D.1.1.1.1      27FEB2020        Yes        Yes                 5                6   
        CHN-11/id-146     dcd D.1.1.1.1      09JAN2021        Yes        Yes                 5                6   
                          dcd B.1.1.1.1      09JAN2021        Yes        Yes                 5                6   
                          dcd C.1.1.1.3      09JAN2021        No         Yes                 4                3   
                          dcd C.1.1.1.3      09JAN2021        No         Yes                 4                2   
                          dcd B.2.1.2.1      09JAN2021        No         No                  3                1   
        CHN-11/id-153     dcd A.1.1.1.2      13OCT2020        Yes        No                  2                6   
                          dcd C.1.1.1.3      13OCT2020        No         Yes                 4                2   
                          dcd D.2.1.5.3      13OCT2020        No         Yes                 1                3   
                          dcd D.1.1.1.1      13OCT2020        Yes        Yes                 5                6   
                          dcd A.1.1.1.1      13OCT2020        No         No                  1                3   
                          dcd A.1.1.1.1      13OCT2020        No         No                  1                2   
                          dcd B.2.2.3.1      13OCT2020        Yes        No                  1                7   
                          dcd D.2.1.5.3      13OCT2020        No         Yes                 1                2   
        CHN-11/id-158     dcd B.2.1.2.1      20JUL2020        No         No                  3                1   
                          dcd A.1.1.1.1      20JUL2020        No         No                  1                2   
                          dcd A.1.1.1.1      20JUL2020        No         No                  1                1   
                          dcd C.2.1.2.1      20JUL2020        No         Yes                 2                5   
                          dcd D.1.1.4.2      20JUL2020        No         No                  3                2   
                          dcd D.1.1.1.1      20JUL2020        Yes        Yes                 5                6   
                          dcd D.1.1.1.1      20JUL2020        Yes        Yes                 5                6   
                          dcd C.1.1.1.3      20JUL2020        No         Yes                 4                5   
        CHN-11/id-167     dcd A.1.1.1.2      08NOV2019        Yes        No                  2                2   
                          dcd C.1.1.1.3      08NOV2019        No         Yes                 4                2   
                          dcd C.1.1.1.3      08NOV2019        No         Yes                 4                7   
                          dcd D.1.1.1.1      08NOV2019        Yes        Yes                 5                6   
                          dcd B.2.2.3.1      08NOV2019        Yes        No                  1                2   
                          dcd A.1.1.1.1      08NOV2019        No         No                  1                5   
                          dcd D.2.1.5.3      08NOV2019        No         Yes                 1                2   
                          dcd D.1.1.4.2      08NOV2019        No         No                  3                2   
                          dcd D.2.1.5.3      08NOV2019        No         Yes                 1                3   
        CHN-11/id-174     dcd D.1.1.1.1      19MAY2020        Yes        Yes                 5                6   
        CHN-11/id-184     dcd B.2.1.2.1      04MAY2019        No         No                  3                6   
                          dcd B.2.1.2.1      04MAY2019        No         No                  3                2   
                          dcd D.1.1.4.2      04MAY2019        No         No                  3                2   
                          dcd D.2.1.5.3      04MAY2019        No         Yes                 1                2   
                          dcd B.2.1.2.1      04MAY2019        No         No                  3                3   
                          dcd B.1.1.1.1      04MAY2019        Yes        Yes                 5                6   
                          dcd C.2.1.2.1      04MAY2019        No         Yes                 2                2   
                          dcd C.1.1.1.3      04MAY2019        No         Yes                 4                1   
                          dcd D.2.1.5.3      04MAY2019        No         Yes                 1                2   
                          dcd A.1.1.1.2      04MAY2019        Yes        No                  2                1   
        CHN-11/id-192     dcd D.1.1.4.2      26DEC2019        No         No                  3                2   
                          dcd A.1.1.1.1      26DEC2019        No         No                  1                2   
                          dcd B.1.1.1.1      26DEC2019        Yes        Yes                 5                6   
                          dcd D.2.1.5.3      26DEC2019        No         Yes                 1                6   
                          dcd B.2.2.3.1      26DEC2019        Yes        No                  1                2   
                          dcd D.1.1.1.1      26DEC2019        Yes        Yes                 5                6   
                          dcd D.2.1.5.3      26DEC2019        No         Yes                 1                2   
                          dcd B.2.1.2.1      26DEC2019        No         No                  3                2   
         CHN-11/id-2      dcd A.1.1.1.2      13JUL2020        Yes        No                  2                2   
                          dcd B.1.1.1.1      13JUL2020        Yes        Yes                 5                6   
                          dcd A.1.1.1.2      13JUL2020        Yes        No                  2                3   
                          dcd A.1.1.1.1      13JUL2020        No         No                  1                2   
                          dcd A.1.1.1.2      13JUL2020        Yes        No                  2                3   
        CHN-11/id-220     dcd C.2.1.2.1      01MAR2019        No         Yes                 2                3   
                          dcd D.1.1.1.1      01MAR2019        Yes        Yes                 5                6   
                          dcd B.1.1.1.1      01MAR2019        Yes        Yes                 5                6   
                          dcd D.2.1.5.3      01MAR2019        No         Yes                 1                3   
        CHN-11/id-222     dcd A.1.1.1.2      25FEB2020        Yes        No                  2                3   
        CHN-11/id-24      dcd C.2.1.2.1      29OCT2020        No         Yes                 2                2   
                          dcd D.1.1.1.1      29OCT2020        Yes        Yes                 5                6   
                          dcd B.2.1.2.1      29OCT2020        No         No                  3                2   
                          dcd C.1.1.1.3      29OCT2020        No         Yes                 4                2   
                          dcd B.1.1.1.1      29OCT2020        Yes        Yes                 5                6   
                          dcd D.1.1.4.2      29OCT2020        No         No                  3                2   
                          dcd A.1.1.1.2      29OCT2020        Yes        No                  2                6   
        CHN-11/id-244     dcd C.2.1.2.1      17JUL2020        No         Yes                 2                7   
                          dcd B.2.2.3.1      17JUL2020        Yes        No                  1                2   
                          dcd A.1.1.1.2      17JUL2020        Yes        No                  2                3   
        CHN-11/id-246     dcd A.1.1.1.2      22DEC2020        Yes        No                  2                3   
                          dcd B.2.2.3.1      22DEC2020        Yes        No                  1                2   
                          dcd A.1.1.1.1      22DEC2020        No         No                  1                1   
                          dcd C.1.1.1.3      22DEC2020        No         Yes                 4                3   
                          dcd A.1.1.1.2      22DEC2020        Yes        No                  2                6   
                          dcd A.1.1.1.1      22DEC2020        No         No                  1                2   
        CHN-11/id-247     dcd C.1.1.1.3      28JUL2019        No         Yes                 4                2   
                          dcd D.2.1.5.3      28JUL2019        No         Yes                 1                5   
                          dcd D.1.1.4.2      28JUL2019        No         No                  3                3   
                          dcd B.2.2.3.1      28JUL2019        Yes        No                  1                2   
                          dcd A.1.1.1.2      28JUL2019        Yes        No                  2                7   
                          dcd A.1.1.1.1      28JUL2019        No         No                  1                6   
                          dcd B.2.1.2.1      28JUL2019        No         No                  3                2   
                          dcd D.1.1.1.1      28JUL2019        Yes        Yes                 5                6   
                          dcd A.1.1.1.1      28JUL2019        No         No                  1                2   
                          dcd A.1.1.1.1      28JUL2019        No         No                  1                2   
        CHN-11/id-256     dcd B.2.1.2.1      17MAR2020        No         No                  3                1   
                          dcd A.1.1.1.1      17MAR2020        No         No                  1                1   
                          dcd C.2.1.2.1      17MAR2020        No         Yes                 2                3   
                          dcd D.2.1.5.3      17MAR2020        No         Yes                 1                6   
                          dcd D.1.1.1.1      17MAR2020        Yes        Yes                 5                6   
                          dcd D.1.1.4.2      17MAR2020        No         No                  3                3   
                          dcd C.1.1.1.3      17MAR2020        No         Yes                 4                2   
                          dcd C.2.1.2.1      17MAR2020        No         Yes                 2                7   
                          dcd A.1.1.1.2      17MAR2020        Yes        No                  2                3   
        CHN-11/id-257     dcd A.1.1.1.2      15NOV2020        Yes        No                  2                2   
                          dcd B.2.1.2.1      15NOV2020        No         No                  3                5   
                          dcd A.1.1.1.1      15NOV2020        No         No                  1                3   
                          dcd D.1.1.4.2      15NOV2020        No         No                  3                1   
        CHN-11/id-263     dcd C.1.1.1.3      03APR2019        No         Yes                 4                1   
                          dcd C.2.1.2.1      03APR2019        No         Yes                 2                6   
                          dcd D.2.1.5.3      03APR2019        No         Yes                 1                2   
                          dcd D.2.1.5.3      03APR2019        No         Yes                 1                2   
                          dcd C.1.1.1.3      03APR2019        No         Yes                 4                6   
                          dcd C.1.1.1.3      03APR2019        No         Yes                 4                2   
                          dcd C.1.1.1.3      03APR2019        No         Yes                 4                2   
        CHN-11/id-27      dcd C.2.1.2.1      18NOV2019        No         Yes                 2                7   
                          dcd A.1.1.1.1      18NOV2019        No         No                  1                1   
        CHN-11/id-278     dcd C.2.1.2.1      24AUG2020        No         Yes                 2                1   
                          dcd A.1.1.1.1      24AUG2020        No         No                  1                2   
                          dcd B.1.1.1.1      24AUG2020        Yes        Yes                 5                6   
                          dcd D.1.1.4.2      24AUG2020        No         No                  3                3   
                          dcd B.2.2.3.1      24AUG2020        Yes        No                  1                2   
                          dcd B.2.1.2.1      24AUG2020        No         No                  3                2   
        CHN-11/id-289     dcd D.1.1.4.2      28SEP2020        No         No                  3                2   
                          dcd D.1.1.1.1      28SEP2020        Yes        Yes                 5                6   
                          dcd D.1.1.4.2      28SEP2020        No         No                  3                1   
                          dcd B.2.1.2.1      28SEP2020        No         No                  3                2   
                          dcd B.1.1.1.1      28SEP2020        Yes        Yes                 5                6   
        CHN-11/id-291     dcd B.1.1.1.1      31OCT2020        Yes        Yes                 5                6   
                          dcd D.2.1.5.3      31OCT2020        No         Yes                 1                2   
                          dcd D.2.1.5.3      31OCT2020        No         Yes                 1                5   
                          dcd B.1.1.1.1      31OCT2020        Yes        Yes                 5                6   
                          dcd B.2.2.3.1      31OCT2020        Yes        No                  1                2   
                          dcd B.2.2.3.1      31OCT2020        Yes        No                  1                2   
                          dcd C.1.1.1.3      31OCT2020        No         Yes                 4                2   
        CHN-11/id-298     dcd D.2.1.5.3      28MAR2020        No         Yes                 1                3   
                          dcd C.2.1.2.1      28MAR2020        No         Yes                 2                3   
                          dcd D.1.1.1.1      28MAR2020        Yes        Yes                 5                6   
                          dcd D.2.1.5.3      28MAR2020        No         Yes                 1                2   
                          dcd C.1.1.1.3      28MAR2020        No         Yes                 4                3   
        CHN-11/id-317     dcd B.2.1.2.1      20MAY2020        No         No                  3                5   
                          dcd B.2.2.3.1      20MAY2020        Yes        No                  1                2   
                          dcd B.2.1.2.1      20MAY2020        No         No                  3                2   
                          dcd B.2.1.2.1      20MAY2020        No         No                  3                2   
                          dcd D.1.1.1.1      20MAY2020        Yes        Yes                 5                6   
                          dcd A.1.1.1.1      20MAY2020        No         No                  1                2   
                          dcd D.1.1.4.2      20MAY2020        No         No                  3                2   
        CHN-11/id-318     dcd B.2.1.2.1      28AUG2019        No         No                  3                2   
                          dcd A.1.1.1.2      28AUG2019        Yes        No                  2                1   
                          dcd D.2.1.5.3      28AUG2019        No         Yes                 1                1   
                          dcd A.1.1.1.1      28AUG2019        No         No                  1                2   
                          dcd C.2.1.2.1      28AUG2019        No         Yes                 2                2   
                          dcd D.2.1.5.3      28AUG2019        No         Yes                 1                2   
                          dcd D.1.1.1.1      28AUG2019        Yes        Yes                 5                6   
                          dcd B.1.1.1.1      28AUG2019        Yes        Yes                 5                6   
        CHN-11/id-354     dcd D.1.1.1.1      10FEB2020        Yes        Yes                 5                6   
                          dcd B.1.1.1.1      10FEB2020        Yes        Yes                 5                6   
                          dcd D.1.1.4.2      10FEB2020        No         No                  3                1   
                          dcd B.2.1.2.1      10FEB2020        No         No                  3                3   
                          dcd C.1.1.1.3      10FEB2020        No         Yes                 4                2   
                          dcd D.1.1.4.2      10FEB2020        No         No                  3                6   
                          dcd A.1.1.1.2      10FEB2020        Yes        No                  2                2   
                          dcd A.1.1.1.2      10FEB2020        Yes        No                  2                2   
        CHN-11/id-356     dcd B.2.2.3.1      12MAR2020        Yes        No                  1                2   
                          dcd B.2.2.3.1      12MAR2020        Yes        No                  1                1   
                          dcd B.2.1.2.1      12MAR2020        No         No                  3                3   
                          dcd D.2.1.5.3      12MAR2020        No         Yes                 1                2   
                          dcd B.2.2.3.1      12MAR2020        Yes        No                  1                2   
                          dcd B.1.1.1.1      12MAR2020        Yes        Yes                 5                6   
                          dcd A.1.1.1.1      12MAR2020        No         No                  1                1   
                          dcd D.1.1.1.1      12MAR2020        Yes        Yes                 5                6   
                          dcd C.1.1.1.3      12MAR2020        No         Yes                 4                6   
        CHN-11/id-358     dcd D.1.1.1.1      02DEC2020        Yes        Yes                 5                6   
                          dcd C.1.1.1.3      02DEC2020        No         Yes                 4                5   
                          dcd C.2.1.2.1      02DEC2020        No         Yes                 2                6   
                          dcd A.1.1.1.1      02DEC2020        No         No                  1                2   
                          dcd D.1.1.4.2      02DEC2020        No         No                  3                2   
                          dcd D.2.1.5.3      02DEC2020        No         Yes                 1                3   
        CHN-11/id-362     dcd B.1.1.1.1      23APR2020        Yes        Yes                 5                6   
                          dcd B.2.2.3.1      23APR2020        Yes        No                  1                3   
                          dcd C.1.1.1.3      23APR2020        No         Yes                 4                2   
                          dcd D.2.1.5.3      23APR2020        No         Yes                 1                2   
                          dcd D.1.1.4.2      23APR2020        No         No                  3                2   
                          dcd D.1.1.4.2      23APR2020        No         No                  3                2   
                          dcd D.1.1.1.1      23APR2020        Yes        Yes                 5                6   
                          dcd A.1.1.1.2      23APR2020        Yes        No                  2                2   
                          dcd C.2.1.2.1      23APR2020        No         Yes                 2                3   
        CHN-11/id-364     dcd B.2.1.2.1      20DEC2020        No         No                  3                5   
                          dcd B.2.2.3.1      20DEC2020        Yes        No                  1                3   
                          dcd B.1.1.1.1      20DEC2020        Yes        Yes                 5                6   
                          dcd A.1.1.1.2      20DEC2020        Yes        No                  2                6   
                          dcd B.2.2.3.1      20DEC2020        Yes        No                  1                2   
                          dcd D.1.1.4.2      20DEC2020        No         No                  3                2   
        CHN-11/id-377     dcd D.1.1.4.2      10JAN2020        No         No                  3                6   
        CHN-11/id-379     dcd B.2.1.2.1      30JUL2019        No         No                  3                1   
                          dcd C.1.1.1.3      30JUL2019        No         Yes                 4                3   
                          dcd C.2.1.2.1      30JUL2019        No         Yes                 2                1   
                          dcd C.2.1.2.1      30JUL2019        No         Yes                 2                2   
                          dcd A.1.1.1.2      30JUL2019        Yes        No                  2                6   
                          dcd A.1.1.1.1      30JUL2019        No         No                  1                3   
                          dcd A.1.1.1.1      30JUL2019        No         No                  1                5   
                          dcd D.2.1.5.3      30JUL2019        No         Yes                 1                3   
                          dcd A.1.1.1.2      30JUL2019        Yes        No                  2                3   
                          dcd B.2.2.3.1      30JUL2019        Yes        No                  1                6   
        CHN-11/id-38      dcd A.1.1.1.2      17JUN2019        Yes        No                  2                2   
        CHN-11/id-386     dcd D.2.1.5.3      18JAN2020        No         Yes                 1                2   
        CHN-11/id-391     dcd B.2.1.2.1      15MAY2020        No         No                  3                7   
                          dcd D.1.1.4.2      15MAY2020        No         No                  3                5   
                          dcd B.2.1.2.1      15MAY2020        No         No                  3                1   
                          dcd D.1.1.4.2      15MAY2020        No         No                  3                5   
                          dcd A.1.1.1.1      15MAY2020        No         No                  1                2   
        CHN-11/id-392     dcd B.1.1.1.1      28SEP2019        Yes        Yes                 5                6   
                          dcd B.2.1.2.1      28SEP2019        No         No                  3                2   
                          dcd D.1.1.1.1      28SEP2019        Yes        Yes                 5                6   
                          dcd C.2.1.2.1      28SEP2019        No         Yes                 2                1   
                          dcd D.2.1.5.3      28SEP2019        No         Yes                 1                6   
                          dcd D.2.1.5.3      28SEP2019        No         Yes                 1                2   
                          dcd B.1.1.1.1      28SEP2019        Yes        Yes                 5                6   
        CHN-11/id-54      dcd D.2.1.5.3      21AUG2019        No         Yes                 1                2   
                          dcd D.1.1.4.2      21AUG2019        No         No                  3                2   
                          dcd B.2.2.3.1      21AUG2019        Yes        No                  1                2   
                          dcd C.2.1.2.1      21AUG2019        No         Yes                 2                2   
                          dcd D.1.1.1.1      21AUG2019        Yes        Yes                 5                6   
                          dcd C.2.1.2.1      21AUG2019        No         Yes                 2                3   
                          dcd B.2.2.3.1      21AUG2019        Yes        No                  1                1   
        CHN-11/id-55      dcd C.1.1.1.3      23NOV2020        No         Yes                 4                2   
                          dcd B.2.2.3.1      23NOV2020        Yes        No                  1                2   
        CHN-11/id-63      dcd D.1.1.4.2      16OCT2019        No         No                  3                6   
                          dcd A.1.1.1.2      16OCT2019        Yes        No                  2                2   
                          dcd B.2.1.2.1      16OCT2019        No         No                  3                2   
                          dcd B.1.1.1.1      16OCT2019        Yes        Yes                 5                6   
                          dcd B.2.2.3.1      16OCT2019        Yes        No                  1                3   
                          dcd B.1.1.1.1      16OCT2019        Yes        Yes                 5                6   
        CHN-11/id-75      dcd A.1.1.1.1      09MAR2020        No         No                  1                6   
        CHN-11/id-90      dcd A.1.1.1.1      31DEC2019        No         No                  1                2   
                          dcd C.1.1.1.3      31DEC2019        No         Yes                 4                2   
                          dcd D.2.1.5.3      31DEC2019        No         Yes                 1                2   
                          dcd C.2.1.2.1      31DEC2019        No         Yes                 2                1   
                          dcd A.1.1.1.2      31DEC2019        Yes        No                  2                2   
                          dcd C.2.1.2.1      31DEC2019        No         Yes                 2                2   
                          dcd D.2.1.5.3      31DEC2019        No         Yes                 1                1   
                          dcd D.1.1.1.1      31DEC2019        Yes        Yes                 5                6   
                          dcd B.2.2.3.1      31DEC2019        Yes        No                  1                1   
                          dcd A.1.1.1.1      31DEC2019        No         No                  1                5   
        CHN-11/id-91      dcd A.1.1.1.2      29MAY2020        Yes        No                  2                3   
                          dcd B.2.2.3.1      29MAY2020        Yes        No                  1                5   
                          dcd D.1.1.4.2      29MAY2020        No         No                  3                7   
                          dcd B.2.1.2.1      29MAY2020        No         No                  3                3   
                          dcd D.1.1.4.2      29MAY2020        No         No                  3                2   
                          dcd B.2.2.3.1      29MAY2020        Yes        No                  1                5   
                          dcd A.1.1.1.2      29MAY2020        Yes        No                  2                2   
        CHN-12/id-255     dcd C.1.1.1.3      20JUN2020        No         Yes                 4                2   
        CHN-12/id-258     dcd B.2.1.2.1      01MAR2020        No         No                  3                2   
                          dcd A.1.1.1.1      01MAR2020        No         No                  1                2   
        CHN-12/id-266     dcd D.1.1.1.1      29OCT2019        Yes        Yes                 5                6   
                          dcd B.1.1.1.1      29OCT2019        Yes        Yes                 5                6   
                          dcd D.2.1.5.3      29OCT2019        No         Yes                 1                2   
                          dcd B.2.2.3.1      29OCT2019        Yes        No                  1                7   
                          dcd A.1.1.1.2      29OCT2019        Yes        No                  2                2   
                          dcd D.2.1.5.3      29OCT2019        No         Yes                 1                2   
                          dcd D.1.1.1.1      29OCT2019        Yes        Yes                 5                6   
                          dcd D.1.1.4.2      29OCT2019        No         No                  3                5   
        CHN-12/id-285     dcd A.1.1.1.2      27SEP2020        Yes        No                  2                5   
                          dcd C.1.1.1.3      27SEP2020        No         Yes                 4                5   
        CHN-12/id-294     dcd D.1.1.1.1      10OCT2020        Yes        Yes                 5                6   
                          dcd A.1.1.1.1      10OCT2020        No         No                  1                3   
                          dcd C.2.1.2.1      10OCT2020        No         Yes                 2                1   
                          dcd B.1.1.1.1      10OCT2020        Yes        Yes                 5                6   
                          dcd D.2.1.5.3      10OCT2020        No         Yes                 1                3   
        CHN-12/id-322     dcd C.2.1.2.1      04JUL2019        No         Yes                 2                3   
                          dcd A.1.1.1.2      04JUL2019        Yes        No                  2                2   
                          dcd B.2.2.3.1      04JUL2019        Yes        No                  1                1   
                          dcd B.1.1.1.1      04JUL2019        Yes        Yes                 5                6   
        CHN-12/id-396     dcd A.1.1.1.2      20SEP2019        Yes        No                  2                3   
                          dcd C.1.1.1.3      20SEP2019        No         Yes                 4                2   
                          dcd D.1.1.4.2      20SEP2019        No         No                  3                2   
                          dcd B.2.1.2.1      20SEP2019        No         No                  3                2   
                          dcd A.1.1.1.1      20SEP2019        No         No                  1                1   
                          dcd B.1.1.1.1      20SEP2019        Yes        Yes                 5                6   
        CHN-12/id-57      dcd B.2.2.3.1      13OCT2019        Yes        No                  1                1   
        CHN-13/id-102     dcd B.1.1.1.1      23MAR2019        Yes        Yes                 5                6   
                          dcd B.2.1.2.1      23MAR2019        No         No                  3                2   
                          dcd B.2.1.2.1      23MAR2019        No         No                  3                3   
                          dcd D.1.1.1.1      23MAR2019        Yes        Yes                 5                6   
                          dcd B.2.2.3.1      23MAR2019        Yes        No                  1                6   
                          dcd D.2.1.5.3      23MAR2019        No         Yes                 1                5   
                          dcd D.1.1.1.1      23MAR2019        Yes        Yes                 5                6   
                          dcd D.1.1.1.1      23MAR2019        Yes        Yes                 5                6   
                          dcd B.2.1.2.1      23MAR2019        No         No                  3                2   
        CHN-13/id-166     dcd B.2.1.2.1      30JUN2020        No         No                  3                2   
                          dcd A.1.1.1.1      30JUN2020        No         No                  1                3   
                          dcd D.1.1.4.2      30JUN2020        No         No                  3                2   
                          dcd A.1.1.1.2      30JUN2020        Yes        No                  2                2   
                          dcd D.1.1.4.2      30JUN2020        No         No                  3                7   
                          dcd C.2.1.2.1      30JUN2020        No         Yes                 2                2   
                          dcd D.1.1.4.2      30JUN2020        No         No                  3                3   
                          dcd D.1.1.4.2      30JUN2020        No         No                  3                7   
        CHN-13/id-19      dcd B.1.1.1.1      13OCT2019        Yes        Yes                 5                6   
                          dcd C.1.1.1.3      13OCT2019        No         Yes                 4                2   
                          dcd D.1.1.4.2      13OCT2019        No         No                  3                1   
                          dcd D.1.1.1.1      13OCT2019        Yes        Yes                 5                6   
                          dcd A.1.1.1.1      13OCT2019        No         No                  1                2   
                          dcd D.2.1.5.3      13OCT2019        No         Yes                 1                2   
                          dcd B.2.1.2.1      13OCT2019        No         No                  3                3   
                          dcd C.2.1.2.1      13OCT2019        No         Yes                 2                2   
        CHN-13/id-239     dcd B.2.2.3.1      06NOV2020        Yes        No                  1                2   
                          dcd A.1.1.1.1      06NOV2020        No         No                  1                6   
                          dcd D.1.1.4.2      06NOV2020        No         No                  3                3   
                          dcd D.1.1.4.2      06NOV2020        No         No                  3                2   
                          dcd B.2.1.2.1      06NOV2020        No         No                  3                2   
                          dcd B.1.1.1.1      06NOV2020        Yes        Yes                 5                6   
                          dcd B.1.1.1.1      06NOV2020        Yes        Yes                 5                6   
                          dcd D.2.1.5.3      06NOV2020        No         Yes                 1                2   
        CHN-13/id-240     dcd D.1.1.4.2      08APR2019        No         No                  3                7   
        CHN-13/id-249     dcd B.2.1.2.1      25FEB2020        No         No                  3                2   
                          dcd D.2.1.5.3      25FEB2020        No         Yes                 1                7   
                          dcd B.2.1.2.1      25FEB2020        No         No                  3                2   
                          dcd B.2.2.3.1      25FEB2020        Yes        No                  1                5   
        CHN-13/id-270     dcd A.1.1.1.2      17AUG2019        Yes        No                  2                3   
                          dcd B.2.2.3.1      17AUG2019        Yes        No                  1                3   
                          dcd B.2.1.2.1      17AUG2019        No         No                  3                7   
        CHN-13/id-304     dcd B.2.2.3.1      23FEB2020        Yes        No                  1                2   
                          dcd A.1.1.1.1      23FEB2020        No         No                  1                3   
                          dcd D.1.1.1.1      23FEB2020        Yes        Yes                 5                6   
                          dcd B.2.2.3.1      23FEB2020        Yes        No                  1                2   
                          dcd D.1.1.1.1      23FEB2020        Yes        Yes                 5                6   
                          dcd C.2.1.2.1      23FEB2020        No         Yes                 2                3   
                          dcd B.1.1.1.1      23FEB2020        Yes        Yes                 5                6   
                          dcd C.2.1.2.1      23FEB2020        No         Yes                 2                2   
         CHN-14/id-1      dcd D.1.1.4.2      07MAY2019        No         No                  3                3   
                          dcd A.1.1.1.1      07MAY2019        No         No                  1                7   
                          dcd A.1.1.1.2      07MAY2019        Yes        No                  2                2   
                          dcd C.1.1.1.3      07MAY2019        No         Yes                 4                2   
                          dcd C.2.1.2.1      07MAY2019        No         Yes                 2                6   
                          dcd B.2.2.3.1      07MAY2019        Yes        No                  1                2   
                          dcd B.1.1.1.1      07MAY2019        Yes        Yes                 5                6   
                          dcd B.2.1.2.1      07MAY2019        No         No                  3                3   
                          dcd B.2.1.2.1      07MAY2019        No         No                  3                2   
                          dcd B.2.1.2.1      07MAY2019        No         No                  3                2   
        CHN-14/id-103     dcd A.1.1.1.1      03NOV2019        No         No                  1                3   
                          dcd D.2.1.5.3      03NOV2019        No         Yes                 1                5   
                          dcd D.1.1.4.2      03NOV2019        No         No                  3                7   
                          dcd D.1.1.4.2      03NOV2019        No         No                  3                1   
                          dcd B.2.1.2.1      03NOV2019        No         No                  3                6   
        CHN-14/id-143     dcd C.2.1.2.1      07AUG2020        No         Yes                 2                1   
                          dcd A.1.1.1.2      07AUG2020        Yes        No                  2                1   
                          dcd A.1.1.1.2      07AUG2020        Yes        No                  2                5   
                          dcd A.1.1.1.2      07AUG2020        Yes        No                  2                3   
                          dcd A.1.1.1.1      07AUG2020        No         No                  1                2   
                          dcd B.1.1.1.1      07AUG2020        Yes        Yes                 5                6   
                          dcd B.2.1.2.1      07AUG2020        No         No                  3                6   
                          dcd A.1.1.1.2      07AUG2020        Yes        No                  2                6   
        CHN-14/id-161     dcd B.2.1.2.1      12SEP2019        No         No                  3                7   
                          dcd D.1.1.1.1      12SEP2019        Yes        Yes                 5                6   
                          dcd C.2.1.2.1      12SEP2019        No         Yes                 2                2   
                          dcd B.2.2.3.1      12SEP2019        Yes        No                  1                7   
                          dcd D.1.1.4.2      12SEP2019        No         No                  3                2   
        CHN-14/id-168     dcd B.1.1.1.1      29MAY2019        Yes        Yes                 5                6   
        CHN-14/id-228     dcd B.2.2.3.1      18OCT2019        Yes        No                  1                2   
                          dcd D.2.1.5.3      18OCT2019        No         Yes                 1                6   
        CHN-14/id-305     dcd C.1.1.1.3      23JAN2021        No         Yes                 4                1   
                          dcd D.1.1.1.1      23JAN2021        Yes        Yes                 5                6   
                          dcd B.2.2.3.1      23JAN2021        Yes        No                  1                2   
        CHN-14/id-375     dcd A.1.1.1.2      27MAR2020        Yes        No                  2                2   
                          dcd D.1.1.1.1      27MAR2020        Yes        Yes                 5                6   
                          dcd B.2.2.3.1      27MAR2020        Yes        No                  1                1   
                          dcd C.2.1.2.1      27MAR2020        No         Yes                 2                1   
                          dcd D.1.1.1.1      27MAR2020        Yes        Yes                 5                6   
                          dcd A.1.1.1.2      27MAR2020        Yes        No                  2                6   
                          dcd A.1.1.1.2      27MAR2020        Yes        No                  2                2   
        CHN-14/id-56      dcd A.1.1.1.1      10OCT2019        No         No                  1                1   
                          dcd D.1.1.1.1      10OCT2019        Yes        Yes                 5                6   
                          dcd C.2.1.2.1      10OCT2019        No         Yes                 2                3   
                          dcd D.2.1.5.3      10OCT2019        No         Yes                 1                3   
                          dcd C.2.1.2.1      10OCT2019        No         Yes                 2                3   
                          dcd D.2.1.5.3      10OCT2019        No         Yes                 1                2   
                          dcd B.2.2.3.1      10OCT2019        Yes        No                  1                7   
                          dcd D.1.1.1.1      10OCT2019        Yes        Yes                 5                6   
                          dcd D.1.1.1.1      10OCT2019        Yes        Yes                 5                6   
                          dcd C.1.1.1.3      10OCT2019        No         Yes                 4                2   
        CHN-15/id-14      dcd A.1.1.1.1      29SEP2019        No         No                  1                2   
                          dcd D.2.1.5.3      29SEP2019        No         Yes                 1                1   
                          dcd D.1.1.4.2      29SEP2019        No         No                  3                3   
                          dcd C.2.1.2.1      29SEP2019        No         Yes                 2                6   
                          dcd B.2.1.2.1      29SEP2019        No         No                  3                2   
                          dcd A.1.1.1.2      29SEP2019        Yes        No                  2                2   
                          dcd B.2.1.2.1      29SEP2019        No         No                  3                6   
                          dcd C.1.1.1.3      29SEP2019        No         Yes                 4                2   
                          dcd C.2.1.2.1      29SEP2019        No         Yes                 2                2   
        CHN-15/id-201     dcd D.1.1.4.2      05MAR2019        No         No                  3                1   
                          dcd B.2.1.2.1      05MAR2019        No         No                  3                2   
                          dcd A.1.1.1.1      05MAR2019        No         No                  1                3   
                          dcd B.2.1.2.1      05MAR2019        No         No                  3                2   
        CHN-15/id-245     dcd A.1.1.1.1      29MAR2019        No         No                  1                2   
        CHN-15/id-262     dcd B.1.1.1.1      26FEB2019        Yes        Yes                 5                6   
                          dcd B.1.1.1.1      26FEB2019        Yes        Yes                 5                6   
                          dcd D.2.1.5.3      26FEB2019        No         Yes                 1                1   
                          dcd D.1.1.4.2      26FEB2019        No         No                  3                2   
                          dcd C.2.1.2.1      26FEB2019        No         Yes                 2                2   
                          dcd A.1.1.1.1      26FEB2019        No         No                  1                3   
                          dcd C.2.1.2.1      26FEB2019        No         Yes                 2                2   
                          dcd C.2.1.2.1      26FEB2019        No         Yes                 2                2   
                          dcd A.1.1.1.2      26FEB2019        Yes        No                  2                1   
        CHN-15/id-297     dcd D.1.1.1.1      20SEP2019        Yes        Yes                 5                6   
                          dcd A.1.1.1.2      20SEP2019        Yes        No                  2                1   
                          dcd B.2.1.2.1      20SEP2019        No         No                  3                2   
                          dcd C.1.1.1.3      20SEP2019        No         Yes                 4                5   
                          dcd B.2.2.3.1      20SEP2019        Yes        No                  1                2   
        CHN-15/id-399     dcd B.1.1.1.1      15OCT2019        Yes        Yes                 5                6   
                          dcd B.1.1.1.1      15OCT2019        Yes        Yes                 5                6   
                          dcd B.2.1.2.1      15OCT2019        No         No                  3                1   
                          dcd C.1.1.1.3      15OCT2019        No         Yes                 4                6   
                          dcd A.1.1.1.1      15OCT2019        No         No                  1                2   
                          dcd D.1.1.4.2      15OCT2019        No         No                  3                2   
                          dcd A.1.1.1.1      15OCT2019        No         No                  1                2   
        CHN-16/id-302     dcd A.1.1.1.1      09NOV2020        No         No                  1                6   
                          dcd C.1.1.1.3      09NOV2020        No         Yes                 4                6   
        CHN-16/id-323     dcd B.1.1.1.1      25DEC2019        Yes        Yes                 5                6   
                          dcd B.2.2.3.1      25DEC2019        Yes        No                  1                2   
                          dcd D.2.1.5.3      25DEC2019        No         Yes                 1                3   
                          dcd B.1.1.1.1      25DEC2019        Yes        Yes                 5                6   
                          dcd C.1.1.1.3      25DEC2019        No         Yes                 4                3   
                          dcd B.1.1.1.1      25DEC2019        Yes        Yes                 5                6   
                          dcd C.2.1.2.1      25DEC2019        No         Yes                 2                6   
        CHN-16/id-352     dcd B.2.2.3.1      02FEB2021        Yes        No                  1                2   
                          dcd B.2.2.3.1      02FEB2021        Yes        No                  1                2   
                          dcd B.2.1.2.1      02FEB2021        No         No                  3                2   
                          dcd C.1.1.1.3      02FEB2021        No         Yes                 4                6   
                          dcd B.2.1.2.1      02FEB2021        No         No                  3                2   
                          dcd B.2.2.3.1      02FEB2021        Yes        No                  1                1   
                          dcd B.2.2.3.1      02FEB2021        Yes        No                  1                2   
                          dcd A.1.1.1.2      02FEB2021        Yes        No                  2                1   
                          dcd D.1.1.1.1      02FEB2021        Yes        Yes                 5                6   
        CHN-16/id-381     dcd B.2.1.2.1      15FEB2020        No         No                  3                6   
                          dcd B.1.1.1.1      15FEB2020        Yes        Yes                 5                6   
                          dcd A.1.1.1.2      15FEB2020        Yes        No                  2                6   
                          dcd B.1.1.1.1      15FEB2020        Yes        Yes                 5                6   
                          dcd D.1.1.4.2      15FEB2020        No         No                  3                6   
                          dcd A.1.1.1.1      15FEB2020        No         No                  1                7   
                          dcd D.2.1.5.3      15FEB2020        No         Yes                 1                2   
        CHN-17/id-182     dcd B.2.1.2.1      18SEP2019        No         No                  3                2   
                          dcd A.1.1.1.2      18SEP2019        Yes        No                  2                5   
                          dcd D.1.1.1.1      18SEP2019        Yes        Yes                 5                6   
                          dcd D.2.1.5.3      18SEP2019        No         Yes                 1                2   
                          dcd B.2.1.2.1      18SEP2019        No         No                  3                2   
                          dcd D.2.1.5.3      18SEP2019        No         Yes                 1                2   
                          dcd A.1.1.1.2      18SEP2019        Yes        No                  2                2   
                          dcd B.2.1.2.1      18SEP2019        No         No                  3                3   
                          dcd D.2.1.5.3      18SEP2019        No         Yes                 1                6   
                          dcd D.2.1.5.3      18SEP2019        No         Yes                 1                3   
        CHN-17/id-309     dcd B.2.2.3.1      27APR2019        Yes        No                  1                1   
                          dcd D.1.1.1.1      27APR2019        Yes        Yes                 5                6   
                          dcd A.1.1.1.1      27APR2019        No         No                  1                2   
                          dcd D.1.1.4.2      27APR2019        No         No                  3                2   
        CHN-17/id-31      dcd A.1.1.1.1      17NOV2019        No         No                  1                3   
                          dcd D.2.1.5.3      17NOV2019        No         Yes                 1                1   
                          dcd A.1.1.1.1      17NOV2019        No         No                  1                1   
                          dcd B.1.1.1.1      17NOV2019        Yes        Yes                 5                6   
                          dcd A.1.1.1.1      17NOV2019        No         No                  1                2   
                          dcd D.1.1.1.1      17NOV2019        Yes        Yes                 5                6   
                          dcd B.1.1.1.1      17NOV2019        Yes        Yes                 5                6   
                          dcd B.1.1.1.1      17NOV2019        Yes        Yes                 5                6   
                          dcd B.1.1.1.1      17NOV2019        Yes        Yes                 5                6   
                          dcd D.1.1.1.1      17NOV2019        Yes        Yes                 5                6   
        CHN-17/id-48      dcd D.1.1.1.1      03MAY2019        Yes        Yes                 5                6   
                          dcd D.2.1.5.3      03MAY2019        No         Yes                 1                5   
         CHN-17/id-5      dcd C.2.1.2.1      07JAN2021        No         Yes                 2                2   
        CHN-17/id-66      dcd C.1.1.1.3      29JUN2019        No         Yes                 4                2   
        CHN-17/id-84      dcd A.1.1.1.1      24MAR2019        No         No                  1                2   
                          dcd B.1.1.1.1      24MAR2019        Yes        Yes                 5                6   
                          dcd A.1.1.1.2      24MAR2019        Yes        No                  2                2   
                          dcd B.1.1.1.1      24MAR2019        Yes        Yes                 5                6   
                          dcd A.1.1.1.2      24MAR2019        Yes        No                  2                2   
                          dcd C.2.1.2.1      24MAR2019        No         Yes                 2                3   
                          dcd D.1.1.4.2      24MAR2019        No         No                  3                3   
        CHN-17/id-92      dcd C.2.1.2.1      01MAR2020        No         Yes                 2                2   
                          dcd D.1.1.1.1      01MAR2020        Yes        Yes                 5                6   
                          dcd B.2.2.3.1      01MAR2020        Yes        No                  1                2   
                          dcd D.1.1.1.1      01MAR2020        Yes        Yes                 5                6   
                          dcd C.2.1.2.1      01MAR2020        No         Yes                 2                2   
                          dcd D.1.1.4.2      01MAR2020        No         No                  3                2   
                          dcd D.2.1.5.3      01MAR2020        No         Yes                 1                2   
                          dcd D.1.1.4.2      01MAR2020        No         No                  3                3   
        CHN-18/id-106     dcd D.1.1.4.2      11DEC2020        No         No                  3                2   
                          dcd A.1.1.1.1      11DEC2020        No         No                  1                2   
                          dcd B.2.1.2.1      11DEC2020        No         No                  3                6   
                          dcd A.1.1.1.1      11DEC2020        No         No                  1                2   
                          dcd D.1.1.4.2      11DEC2020        No         No                  3                2   
                          dcd D.2.1.5.3      11DEC2020        No         Yes                 1                3   
                          dcd B.1.1.1.1      11DEC2020        Yes        Yes                 5                6   
                          dcd C.2.1.2.1      11DEC2020        No         Yes                 2                2   
                          dcd B.1.1.1.1      11DEC2020        Yes        Yes                 5                6   
        CHN-18/id-170     dcd B.1.1.1.1      20JAN2020        Yes        Yes                 5                6   
                          dcd D.1.1.1.1      20JAN2020        Yes        Yes                 5                6   
        CHN-18/id-51      dcd B.2.1.2.1      25SEP2019        No         No                  3                6   
                          dcd D.1.1.4.2      25SEP2019        No         No                  3                2   
                          dcd B.2.2.3.1      25SEP2019        Yes        No                  1                6   
        CHN-2/id-118      dcd C.1.1.1.3      09APR2020        No         Yes                 4                2   
                          dcd B.1.1.1.1      09APR2020        Yes        Yes                 5                6   
                          dcd C.1.1.1.3      09APR2020        No         Yes                 4                2   
                          dcd A.1.1.1.1      09APR2020        No         No                  1                3   
        CHN-2/id-149      dcd D.2.1.5.3      07JAN2020        No         Yes                 1                1   
                          dcd A.1.1.1.2      07JAN2020        Yes        No                  2                2   
                          dcd A.1.1.1.1      07JAN2020        No         No                  1                2   
                          dcd C.1.1.1.3      07JAN2020        No         Yes                 4                2   
         CHN-2/id-22      dcd D.1.1.4.2      15JAN2021        No         No                  3                1   
                          dcd D.1.1.1.1      15JAN2021        Yes        Yes                 5                6   
                          dcd A.1.1.1.2      15JAN2021        Yes        No                  2                2   
        CHN-2/id-223      dcd A.1.1.1.1      18NOV2020        No         No                  1                2   
                          dcd C.1.1.1.3      18NOV2020        No         Yes                 4                2   
                          dcd B.1.1.1.1      18NOV2020        Yes        Yes                 5                6   
                          dcd D.1.1.1.1      18NOV2020        Yes        Yes                 5                6   
                          dcd A.1.1.1.2      18NOV2020        Yes        No                  2                2   
                          dcd D.1.1.1.1      18NOV2020        Yes        Yes                 5                6   
                          dcd A.1.1.1.2      18NOV2020        Yes        No                  2                2   
                          dcd D.1.1.1.1      18NOV2020        Yes        Yes                 5                6   
                          dcd B.1.1.1.1      18NOV2020        Yes        Yes                 5                6   
                          dcd A.1.1.1.2      18NOV2020        Yes        No                  2                7   
        CHN-2/id-272      dcd D.1.1.1.1      11JAN2020        Yes        Yes                 5                6   
        CHN-2/id-274      dcd D.1.1.1.1      14OCT2019        Yes        Yes                 5                6   
                          dcd D.1.1.1.1      14OCT2019        Yes        Yes                 5                6   
                          dcd C.1.1.1.3      14OCT2019        No         Yes                 4                2   
                          dcd A.1.1.1.1      14OCT2019        No         No                  1                4   
        CHN-2/id-284      dcd A.1.1.1.2      13SEP2020        Yes        No                  2                2   
                          dcd D.1.1.1.1      13SEP2020        Yes        Yes                 5                6   
                          dcd A.1.1.1.1      13SEP2020        No         No                  1                2   
                          dcd B.1.1.1.1      13SEP2020        Yes        Yes                 5                6   
        CHN-2/id-286      dcd D.1.1.1.1      16MAY2019        Yes        Yes                 5                6   
                          dcd B.2.2.3.1      16MAY2019        Yes        No                  1                2   
                          dcd D.2.1.5.3      16MAY2019        No         Yes                 1                2   
                          dcd D.2.1.5.3      16MAY2019        No         Yes                 1                2   
                          dcd C.2.1.2.1      16MAY2019        No         Yes                 2                2   
        CHN-2/id-292      dcd D.1.1.4.2      10JUL2020        No         No                  3                2   
                          dcd C.2.1.2.1      10JUL2020        No         Yes                 2                6   
                          dcd B.2.2.3.1      10JUL2020        Yes        No                  1                2   
                          dcd D.2.1.5.3      10JUL2020        No         Yes                 1                1   
                          dcd D.1.1.4.2      10JUL2020        No         No                  3                1   
                          dcd C.1.1.1.3      10JUL2020        No         Yes                 4                2   
                          dcd C.1.1.1.3      10JUL2020        No         Yes                 4                3   
                          dcd B.2.2.3.1      10JUL2020        Yes        No                  1                2   
                          dcd D.1.1.1.1      10JUL2020        Yes        Yes                 5                6   
                          dcd A.1.1.1.2      10JUL2020        Yes        No                  2                3   
        CHN-2/id-332      dcd C.1.1.1.3      08OCT2019        No         Yes                 4                3   
                          dcd B.1.1.1.1      08OCT2019        Yes        Yes                 5                6   
                          dcd B.2.1.2.1      08OCT2019        No         No                  3                2   
                          dcd B.2.2.3.1      08OCT2019        Yes        No                  1                2   
                          dcd A.1.1.1.2      08OCT2019        Yes        No                  2                2   
         CHN-2/id-34      dcd D.1.1.4.2      17JUL2019        No         No                  3                3   
                          dcd D.1.1.1.1      17JUL2019        Yes        Yes                 5                6   
        CHN-2/id-342      dcd D.1.1.4.2      04MAY2020        No         No                  3                2   
                          dcd D.1.1.1.1      04MAY2020        Yes        Yes                 5                6   
                          dcd B.2.1.2.1      04MAY2020        No         No                  3                5   
        CHN-2/id-367      dcd B.2.2.3.1      27JUN2020        Yes        No                  1                2   
                          dcd A.1.1.1.2      27JUN2020        Yes        No                  2                1   
                          dcd B.2.2.3.1      27JUN2020        Yes        No                  1                6   
                          dcd C.2.1.2.1      27JUN2020        No         Yes                 2                2   
                          dcd D.2.1.5.3      27JUN2020        No         Yes                 1                3   
                          dcd B.1.1.1.1      27JUN2020        Yes        Yes                 5                6   
                          dcd A.1.1.1.1      27JUN2020        No         No                  1                2   
                          dcd D.1.1.4.2      27JUN2020        No         No                  3                1   
                          dcd B.2.2.3.1      27JUN2020        Yes        No                  1                2   
        CHN-2/id-395      dcd D.1.1.1.1      27APR2019        Yes        Yes                 5                6   
                          dcd C.2.1.2.1      27APR2019        No         Yes                 2                6   
                          dcd B.2.1.2.1      27APR2019        No         No                  3                2   
        CHN-2/id-398      dcd A.1.1.1.1      19OCT2019        No         No                  1                2   
                          dcd D.1.1.4.2      19OCT2019        No         No                  3                5   
                          dcd A.1.1.1.1      19OCT2019        No         No                  1                1   
                          dcd C.2.1.2.1      19OCT2019        No         Yes                 2                2   
                          dcd B.2.2.3.1      19OCT2019        Yes        No                  1                2   
                          dcd D.2.1.5.3      19OCT2019        No         Yes                 1                1   
                          dcd B.2.2.3.1      19OCT2019        Yes        No                  1                6   
         CHN-2/id-98      dcd A.1.1.1.1      27MAR2020        No         No                  1                2   
                          dcd C.1.1.1.3      27MAR2020        No         Yes                 4                2   
                          dcd C.2.1.2.1      27MAR2020        No         Yes                 2                3   
                          dcd D.2.1.5.3      27MAR2020        No         Yes                 1                2   
                          dcd B.2.2.3.1      27MAR2020        Yes        No                  1                6   
                          dcd C.2.1.2.1      27MAR2020        No         Yes                 2                1   
                          dcd A.1.1.1.1      27MAR2020        No         No                  1                2   
                          dcd D.1.1.1.1      27MAR2020        Yes        Yes                 5                6   
                          dcd B.2.2.3.1      27MAR2020        Yes        No                  1                3   
                          dcd C.1.1.1.3      27MAR2020        No         Yes                 4                3   
        CHN-3/id-128      dcd B.2.1.2.1      24FEB2019        No         No                  3                2   
                          dcd C.1.1.1.3      24FEB2019        No         Yes                 4                2   
        CHN-3/id-155      dcd D.1.1.4.2      20MAY2020        No         No                  3                5   
                          dcd C.2.1.2.1      20MAY2020        No         Yes                 2                2   
                          dcd A.1.1.1.1      20MAY2020        No         No                  1                4   
                          dcd A.1.1.1.2      20MAY2020        Yes        No                  2                2   
                          dcd B.1.1.1.1      20MAY2020        Yes        Yes                 5                6   
        CHN-3/id-193      dcd D.1.1.4.2      26JAN2021        No         No                  3                3   
                          dcd A.1.1.1.1      26JAN2021        No         No                  1                2   
                          dcd D.2.1.5.3      26JAN2021        No         Yes                 1                3   
        CHN-3/id-204      dcd B.2.2.3.1      08AUG2019        Yes        No                  1                2   
        CHN-3/id-259      dcd D.2.1.5.3      07AUG2019        No         Yes                 1                2   
                          dcd B.2.2.3.1      07AUG2019        Yes        No                  1                7   
                          dcd B.1.1.1.1      07AUG2019        Yes        Yes                 5                6   
                          dcd D.1.1.1.1      07AUG2019        Yes        Yes                 5                6   
                          dcd A.1.1.1.1      07AUG2019        No         No                  1                2   
        CHN-3/id-271      dcd A.1.1.1.1      06AUG2020        No         No                  1                2   
                          dcd C.2.1.2.1      06AUG2020        No         Yes                 2                3   
                          dcd B.1.1.1.1      06AUG2020        Yes        Yes                 5                6   
                          dcd A.1.1.1.1      06AUG2020        No         No                  1                7   
                          dcd C.2.1.2.1      06AUG2020        No         Yes                 2                2   
                          dcd C.2.1.2.1      06AUG2020        No         Yes                 2                2   
                          dcd A.1.1.1.2      06AUG2020        Yes        No                  2                2   
                          dcd D.1.1.1.1      06AUG2020        Yes        Yes                 5                6   
                          dcd C.2.1.2.1      06AUG2020        No         Yes                 2                2   
        CHN-3/id-281      dcd B.1.1.1.1      02SEP2020        Yes        Yes                 5                6   
        CHN-3/id-303      dcd C.1.1.1.3      05JAN2020        No         Yes                 4                3   
                          dcd C.2.1.2.1      05JAN2020        No         Yes                 2                1   
        CHN-3/id-333      dcd B.2.2.3.1      13JAN2020        Yes        No                  1                3   
                          dcd B.2.1.2.1      13JAN2020        No         No                  3                3   
                          dcd B.1.1.1.1      13JAN2020        Yes        Yes                 5                6   
                          dcd C.1.1.1.3      13JAN2020        No         Yes                 4                7   
                          dcd D.1.1.1.1      13JAN2020        Yes        Yes                 5                6   
         CHN-3/id-81      dcd C.1.1.1.3      09SEP2020        No         Yes                 4                6   
                          dcd A.1.1.1.1      09SEP2020        No         No                  1                2   
                          dcd B.2.1.2.1      09SEP2020        No         No                  3                2   
        CHN-4/id-114      dcd D.1.1.4.2      18AUG2019        No         No                  3                2   
                          dcd C.1.1.1.3      18AUG2019        No         Yes                 4                3   
                          dcd C.1.1.1.3      18AUG2019        No         Yes                 4                1   
                          dcd A.1.1.1.1      18AUG2019        No         No                  1                3   
        CHN-4/id-115      dcd C.2.1.2.1      28MAR2019        No         Yes                 2                2   
                          dcd B.2.2.3.1      28MAR2019        Yes        No                  1                2   
                          dcd D.2.1.5.3      28MAR2019        No         Yes                 1                3   
                          dcd D.1.1.1.1      28MAR2019        Yes        Yes                 5                6   
                          dcd C.1.1.1.3      28MAR2019        No         Yes                 4                4   
                          dcd D.2.1.5.3      28MAR2019        No         Yes                 1                2   
                          dcd B.2.2.3.1      28MAR2019        Yes        No                  1                2   
                          dcd B.1.1.1.1      28MAR2019        Yes        Yes                 5                6   
                          dcd B.2.1.2.1      28MAR2019        No         No                  3                2   
                          dcd A.1.1.1.2      28MAR2019        Yes        No                  2                6   
        CHN-4/id-122      dcd D.1.1.1.1      21DEC2019        Yes        Yes                 5                6   
                          dcd C.2.1.2.1      21DEC2019        No         Yes                 2                2   
                          dcd A.1.1.1.1      21DEC2019        No         No                  1                2   
                          dcd B.2.2.3.1      21DEC2019        Yes        No                  1                2   
                          dcd A.1.1.1.1      21DEC2019        No         No                  1                2   
        CHN-4/id-310      dcd A.1.1.1.2      20JUL2019        Yes        No                  2                2   
        CHN-4/id-311      dcd D.2.1.5.3      10AUG2020        No         Yes                 1                2   
        CHN-4/id-335      dcd B.1.1.1.1      17APR2020        Yes        Yes                 5                6   
                          dcd A.1.1.1.2      17APR2020        Yes        No                  2                6   
                          dcd B.2.1.2.1      17APR2020        No         No                  3                2   
        CHN-4/id-370      dcd C.2.1.2.1      29MAR2019        No         Yes                 2                6   
                          dcd D.2.1.5.3      29MAR2019        No         Yes                 1                6   
                          dcd A.1.1.1.2      29MAR2019        Yes        No                  2                2   
                          dcd A.1.1.1.2      29MAR2019        Yes        No                  2                6   
                          dcd B.2.2.3.1      29MAR2019        Yes        No                  1                3   
                          dcd B.2.2.3.1      29MAR2019        Yes        No                  1                2   
                          dcd B.2.2.3.1      29MAR2019        Yes        No                  1                3   
         CHN-4/id-73      dcd B.2.2.3.1      17MAR2019        Yes        No                  1                3   
                          dcd D.2.1.5.3      17MAR2019        No         Yes                 1                2   
                          dcd B.1.1.1.1      17MAR2019        Yes        Yes                 5                6   
                          dcd B.2.2.3.1      17MAR2019        Yes        No                  1                2   
                          dcd C.2.1.2.1      17MAR2019        No         Yes                 2                2   
        CHN-5/id-108      dcd B.1.1.1.1      11SEP2019        Yes        Yes                 5                6   
                          dcd A.1.1.1.2      11SEP2019        Yes        No                  2                3   
                          dcd D.2.1.5.3      11SEP2019        No         Yes                 1                2   
                          dcd B.2.2.3.1      11SEP2019        Yes        No                  1                5   
                          dcd C.2.1.2.1      11SEP2019        No         Yes                 2                1   
                          dcd D.2.1.5.3      11SEP2019        No         Yes                 1                3   
                          dcd C.2.1.2.1      11SEP2019        No         Yes                 2                2   
                          dcd B.1.1.1.1      11SEP2019        Yes        Yes                 5                6   
        CHN-5/id-159      dcd A.1.1.1.2      27MAY2019        Yes        No                  2                2   
                          dcd B.2.2.3.1      27MAY2019        Yes        No                  1                2   
        CHN-5/id-160      dcd D.2.1.5.3      17JUL2019        No         Yes                 1                2   
        CHN-5/id-175      dcd D.2.1.5.3      03OCT2020        No         Yes                 1                2   
        CHN-5/id-221      dcd C.1.1.1.3      28OCT2020        No         Yes                 4                2   
                          dcd D.2.1.5.3      28OCT2020        No         Yes                 1                2   
                          dcd B.1.1.1.1      28OCT2020        Yes        Yes                 5                6   
                          dcd B.2.2.3.1      28OCT2020        Yes        No                  1                1   
                          dcd C.2.1.2.1      28OCT2020        No         Yes                 2                2   
                          dcd A.1.1.1.1      28OCT2020        No         No                  1                2   
                          dcd B.1.1.1.1      28OCT2020        Yes        Yes                 5                6   
        CHN-5/id-231      dcd A.1.1.1.1      07DEC2020        No         No                  1                3   
                          dcd C.1.1.1.3      07DEC2020        No         Yes                 4                2   
                          dcd D.2.1.5.3      07DEC2020        No         Yes                 1                5   
                          dcd A.1.1.1.2      07DEC2020        Yes        No                  2                2   
                          dcd D.1.1.1.1      07DEC2020        Yes        Yes                 5                6   
                          dcd D.2.1.5.3      07DEC2020        No         Yes                 1                3   
                          dcd B.1.1.1.1      07DEC2020        Yes        Yes                 5                6   
        CHN-5/id-273      dcd D.2.1.5.3      03JAN2021        No         Yes                 1                2   
                          dcd B.1.1.1.1      03JAN2021        Yes        Yes                 5                6   
                          dcd A.1.1.1.2      03JAN2021        Yes        No                  2                2   
                          dcd A.1.1.1.1      03JAN2021        No         No                  1                3   
                          dcd D.1.1.4.2      03JAN2021        No         No                  3                2   
                          dcd C.1.1.1.3      03JAN2021        No         Yes                 4                3   
                          dcd C.2.1.2.1      03JAN2021        No         Yes                 2                6   
                          dcd C.2.1.2.1      03JAN2021        No         Yes                 2                2   
                          dcd D.1.1.4.2      03JAN2021        No         No                  3                1   
        CHN-5/id-338      dcd D.2.1.5.3      09AUG2019        No         Yes                 1                2   
                          dcd B.2.1.2.1      09AUG2019        No         No                  3                3   
                          dcd B.2.2.3.1      09AUG2019        Yes        No                  1                2   
                          dcd A.1.1.1.2      09AUG2019        Yes        No                  2                3   
                          dcd D.1.1.4.2      09AUG2019        No         No                  3                7   
                          dcd D.1.1.1.1      09AUG2019        Yes        Yes                 5                6   
                          dcd B.1.1.1.1      09AUG2019        Yes        Yes                 5                6   
        CHN-5/id-348      dcd B.1.1.1.1      23SEP2020        Yes        Yes                 5                6   
                          dcd C.1.1.1.3      23SEP2020        No         Yes                 4                2   
                          dcd A.1.1.1.1      23SEP2020        No         No                  1                2   
                          dcd D.2.1.5.3      23SEP2020        No         Yes                 1                2   
                          dcd B.2.2.3.1      23SEP2020        Yes        No                  1                2   
                          dcd D.1.1.1.1      23SEP2020        Yes        Yes                 5                6   
                          dcd B.2.2.3.1      23SEP2020        Yes        No                  1                1   
         CHN-5/id-83      dcd A.1.1.1.2      08OCT2019        Yes        No                  2                2   
                          dcd D.1.1.1.1      08OCT2019        Yes        Yes                 5                6   
                          dcd D.1.1.1.1      08OCT2019        Yes        Yes                 5                6   
         CHN-6/id-30      dcd C.1.1.1.3      24AUG2020        No         Yes                 4                3   
                          dcd C.1.1.1.3      24AUG2020        No         Yes                 4                2   
                          dcd C.1.1.1.3      24AUG2020        No         Yes                 4                2   
                          dcd D.1.1.1.1      24AUG2020        Yes        Yes                 5                6   
                          dcd B.2.2.3.1      24AUG2020        Yes        No                  1                2   
                          dcd A.1.1.1.2      24AUG2020        Yes        No                  2                5   
                          dcd B.2.2.3.1      24AUG2020        Yes        No                  1                2   
                          dcd C.2.1.2.1      24AUG2020        No         Yes                 2                6   
        CHN-6/id-385      dcd C.2.1.2.1      21NOV2019        No         Yes                 2                2   
                          dcd A.1.1.1.1      21NOV2019        No         No                  1                2   
                          dcd B.2.2.3.1      21NOV2019        Yes        No                  1                2   
                          dcd D.1.1.1.1      21NOV2019        Yes        Yes                 5                6   
         CHN-6/id-89      dcd C.1.1.1.3      23JAN2021        No         Yes                 4                1   
                          dcd A.1.1.1.2      23JAN2021        Yes        No                  2                6   
                          dcd C.1.1.1.3      23JAN2021        No         Yes                 4                4   
        CHN-7/id-126      dcd A.1.1.1.2      02MAY2019        Yes        No                  2                2   
                          dcd C.1.1.1.3      02MAY2019        No         Yes                 4                2   
                          dcd B.1.1.1.1      02MAY2019        Yes        Yes                 5                6   
                          dcd A.1.1.1.2      02MAY2019        Yes        No                  2                6   
                          dcd C.1.1.1.3      02MAY2019        No         Yes                 4                2   
        CHN-7/id-202      dcd D.1.1.1.1      06NOV2019        Yes        Yes                 5                6   
                          dcd D.1.1.1.1      06NOV2019        Yes        Yes                 5                6   
                          dcd D.1.1.4.2      06NOV2019        No         No                  3                2   
                          dcd B.1.1.1.1      06NOV2019        Yes        Yes                 5                6   
                          dcd A.1.1.1.1      06NOV2019        No         No                  1                2   
                          dcd D.1.1.4.2      06NOV2019        No         No                  3                3   
                          dcd B.1.1.1.1      06NOV2019        Yes        Yes                 5                6   
                          dcd D.2.1.5.3      06NOV2019        No         Yes                 1                2   
                          dcd B.2.1.2.1      06NOV2019        No         No                  3                3   
                          dcd C.1.1.1.3      06NOV2019        No         Yes                 4                2   
        CHN-7/id-267      dcd B.1.1.1.1      02MAR2019        Yes        Yes                 5                6   
         CHN-7/id-28      dcd B.2.1.2.1      11MAR2019        No         No                  3                1   
        CHN-7/id-290      dcd B.2.2.3.1      15JAN2021        Yes        No                  1                3   
                          dcd B.2.2.3.1      15JAN2021        Yes        No                  1                6   
                          dcd A.1.1.1.1      15JAN2021        No         No                  1                1   
                          dcd D.1.1.4.2      15JAN2021        No         No                  3                1   
                          dcd B.1.1.1.1      15JAN2021        Yes        Yes                 5                6   
                          dcd A.1.1.1.1      15JAN2021        No         No                  1                2   
                          dcd B.2.1.2.1      15JAN2021        No         No                  3                2   
         CHN-7/id-40      dcd D.1.1.4.2      30NOV2020        No         No                  3                2   
                          dcd A.1.1.1.2      30NOV2020        Yes        No                  2                1   
                          dcd A.1.1.1.2      30NOV2020        Yes        No                  2                1   
        CHN-8/id-205      dcd C.1.1.1.3      18JAN2021        No         Yes                 4                3   
                          dcd D.2.1.5.3      18JAN2021        No         Yes                 1                1   
                          dcd A.1.1.1.2      18JAN2021        Yes        No                  2                1   
                          dcd A.1.1.1.2      18JAN2021        Yes        No                  2                6   
                          dcd C.1.1.1.3      18JAN2021        No         Yes                 4                3   
                          dcd D.1.1.4.2      18JAN2021        No         No                  3                3   
                          dcd A.1.1.1.2      18JAN2021        Yes        No                  2                2   
                          dcd B.2.2.3.1      18JAN2021        Yes        No                  1                2   
                          dcd A.1.1.1.1      18JAN2021        No         No                  1                2   
                          dcd D.1.1.1.1      18JAN2021        Yes        Yes                 5                6   
        CHN-8/id-299      dcd B.2.2.3.1      09NOV2019        Yes        No                  1                5   
                          dcd B.2.2.3.1      09NOV2019        Yes        No                  1                3   
         CHN-9/id-11      dcd C.2.1.2.1      27JAN2021        No         Yes                 2                6   
                          dcd A.1.1.1.2      27JAN2021        Yes        No                  2                2   
                          dcd D.1.1.1.1      27JAN2021        Yes        Yes                 5                6   
                          dcd B.1.1.1.1      27JAN2021        Yes        Yes                 5                6   
        CHN-9/id-147      dcd B.2.2.3.1      06FEB2020        Yes        No                  1                7   
                          dcd D.1.1.4.2      06FEB2020        No         No                  3                3   
                          dcd B.2.2.3.1      06FEB2020        Yes        No                  1                5   
                          dcd A.1.1.1.2      06FEB2020        Yes        No                  2                1   
                          dcd B.2.2.3.1      06FEB2020        Yes        No                  1                6   
                          dcd C.2.1.2.1      06FEB2020        No         Yes                 2                2   
                          dcd A.1.1.1.2      06FEB2020        Yes        No                  2                3   
                          dcd B.2.2.3.1      06FEB2020        Yes        No                  1                3   
                          dcd B.1.1.1.1      06FEB2020        Yes        Yes                 5                6   
        CHN-9/id-374      dcd B.1.1.1.1      17NOV2020        Yes        Yes                 5                6   
        GBR-1/id-319      dcd A.1.1.1.2      02OCT2020        Yes        No                  2                2   
                          dcd B.1.1.1.1      02OCT2020        Yes        Yes                 5                6   
                          dcd D.1.1.1.1      02OCT2020        Yes        Yes                 5                6   
                          dcd D.2.1.5.3      02OCT2020        No         Yes                 1                6   
                          dcd A.1.1.1.2      02OCT2020        Yes        No                  2                2   
                          dcd B.2.1.2.1      02OCT2020        No         No                  3                6   
        GBR-1/id-355      dcd A.1.1.1.1      02APR2020        No         No                  1                2   
        GBR-1/id-384      dcd A.1.1.1.1      19JAN2020        No         No                  1                2   
                          dcd B.2.1.2.1      19JAN2020        No         No                  3                2   
                          dcd C.2.1.2.1      19JAN2020        No         Yes                 2                2   
                          dcd B.2.1.2.1      19JAN2020        No         No                  3                3   
        GBR-11/id-340     dcd D.2.1.5.3      17MAY2020        No         Yes                 1                2   
                          dcd D.2.1.5.3      17MAY2020        No         Yes                 1                1   
                          dcd B.2.2.3.1      17MAY2020        Yes        No                  1                2   
                          dcd C.1.1.1.3      17MAY2020        No         Yes                 4                2   
        GBR-11/id-390     dcd D.1.1.4.2      31DEC2019        No         No                  3                2   
                          dcd B.2.1.2.1      31DEC2019        No         No                  3                3   
                          dcd B.1.1.1.1      31DEC2019        Yes        Yes                 5                6   
        GBR-13/id-80      dcd D.2.1.5.3      24OCT2020        No         Yes                 1                2   
                          dcd A.1.1.1.1      24OCT2020        No         No                  1                2   
        GBR-15/id-293     dcd B.2.1.2.1      21MAY2020        No         No                  3                2   
        GBR-17/id-211     dcd B.2.2.3.1      23DEC2020        Yes        No                  1                2   
                          dcd B.1.1.1.1      23DEC2020        Yes        Yes                 5                6   
                          dcd D.2.1.5.3      23DEC2020        No         Yes                 1                2   
                          dcd B.2.2.3.1      23DEC2020        Yes        No                  1                2   
                          dcd B.2.2.3.1      23DEC2020        Yes        No                  1                5   
                          dcd D.1.1.1.1      23DEC2020        Yes        Yes                 5                6   
                          dcd B.2.1.2.1      23DEC2020        No         No                  3                1   
        GBR-6/id-111      dcd C.1.1.1.3      29JUL2019        No         Yes                 4                2   
                          dcd C.2.1.2.1      29JUL2019        No         Yes                 2                1   
                          dcd B.1.1.1.1      29JUL2019        Yes        Yes                 5                6   
         JPN-1/id-21      dcd A.1.1.1.2      17NOV2020        Yes        No                  2                2   
                          dcd D.1.1.1.1      17NOV2020        Yes        Yes                 5                6   
                          dcd B.1.1.1.1      17NOV2020        Yes        Yes                 5                6   
                          dcd D.1.1.1.1      17NOV2020        Yes        Yes                 5                6   
                          dcd B.2.1.2.1      17NOV2020        No         No                  3                6   
                          dcd A.1.1.1.1      17NOV2020        No         No                  1                6   
                          dcd D.1.1.1.1      17NOV2020        Yes        Yes                 5                6   
                          dcd A.1.1.1.2      17NOV2020        Yes        No                  2                1   
                          dcd C.2.1.2.1      17NOV2020        No         Yes                 2                3   
                          dcd B.2.1.2.1      17NOV2020        No         No                  3                3   
        JPN-1/id-218      dcd B.2.2.3.1      09OCT2019        Yes        No                  1                1   
                          dcd C.1.1.1.3      09OCT2019        No         Yes                 4                2   
                          dcd B.2.1.2.1      09OCT2019        No         No                  3                2   
                          dcd C.1.1.1.3      09OCT2019        No         Yes                 4                2   
                          dcd A.1.1.1.1      09OCT2019        No         No                  1                2   
        JPN-1/id-300      dcd A.1.1.1.2      07MAY2020        Yes        No                  2                6   
         JPN-1/id-7       dcd D.1.1.1.1      10OCT2019        Yes        Yes                 5                6   
                          dcd B.2.2.3.1      10OCT2019        Yes        No                  1                3   
                          dcd C.1.1.1.3      10OCT2019        No         Yes                 4                2   
                          dcd C.1.1.1.3      10OCT2019        No         Yes                 4                2   
                          dcd C.1.1.1.3      10OCT2019        No         Yes                 4                7   
                          dcd D.1.1.4.2      10OCT2019        No         No                  3                2   
                          dcd A.1.1.1.1      10OCT2019        No         No                  1                2   
                          dcd B.2.2.3.1      10OCT2019        Yes        No                  1                6   
                          dcd A.1.1.1.2      10OCT2019        Yes        No                  2                2   
                          dcd D.2.1.5.3      10OCT2019        No         Yes                 1                2   
        JPN-11/id-135     dcd D.1.1.1.1      12OCT2019        Yes        Yes                 5                6   
                          dcd B.2.2.3.1      12OCT2019        Yes        No                  1                3   
                          dcd A.1.1.1.2      12OCT2019        Yes        No                  2                5   
                          dcd A.1.1.1.1      12OCT2019        No         No                  1                3   
                          dcd B.2.2.3.1      12OCT2019        Yes        No                  1                3   
        JPN-11/id-373     dcd A.1.1.1.2      25AUG2020        Yes        No                  2                3   
                          dcd B.2.1.2.1      25AUG2020        No         No                  3                6   
                          dcd D.2.1.5.3      25AUG2020        No         Yes                 1                1   
                          dcd A.1.1.1.1      25AUG2020        No         No                  1                1   
                          dcd B.1.1.1.1      25AUG2020        Yes        Yes                 5                6   
                          dcd A.1.1.1.2      25AUG2020        Yes        No                  2                3   
                          dcd B.2.1.2.1      25AUG2020        No         No                  3                2   
                          dcd A.1.1.1.1      25AUG2020        No         No                  1                6   
                          dcd D.2.1.5.3      25AUG2020        No         Yes                 1                2   
        JPN-11/id-61      dcd D.2.1.5.3      22DEC2020        No         Yes                 1                2   
        JPN-12/id-219     dcd D.2.1.5.3      03MAY2020        No         Yes                 1                2   
                          dcd D.1.1.1.1      03MAY2020        Yes        Yes                 5                6   
                          dcd C.1.1.1.3      03MAY2020        No         Yes                 4                3   
                          dcd A.1.1.1.1      03MAY2020        No         No                  1                1   
                          dcd B.1.1.1.1      03MAY2020        Yes        Yes                 5                6   
        JPN-14/id-194     dcd C.1.1.1.3      01NOV2019        No         Yes                 4                2   
                          dcd B.1.1.1.1      01NOV2019        Yes        Yes                 5                6   
                          dcd C.2.1.2.1      01NOV2019        No         Yes                 2                2   
        JPN-17/id-393     dcd B.2.1.2.1      08JUN2020        No         No                  3                5   
                          dcd A.1.1.1.2      08JUN2020        Yes        No                  2                3   
                          dcd A.1.1.1.1      08JUN2020        No         No                  1                7   
                          dcd C.2.1.2.1      08JUN2020        No         Yes                 2                2   
                          dcd D.1.1.1.1      08JUN2020        Yes        Yes                 5                6   
        JPN-18/id-189     dcd B.1.1.1.1      09SEP2020        Yes        Yes                 5                6   
        JPN-3/id-109      dcd D.2.1.5.3      17OCT2019        No         Yes                 1                6   
                          dcd C.1.1.1.3      17OCT2019        No         Yes                 4                2   
                          dcd B.2.2.3.1      17OCT2019        Yes        No                  1                2   
                          dcd B.2.2.3.1      17OCT2019        Yes        No                  1                2   
                          dcd B.2.2.3.1      17OCT2019        Yes        No                  1                2   
                          dcd A.1.1.1.2      17OCT2019        Yes        No                  2                1   
                          dcd A.1.1.1.2      17OCT2019        Yes        No                  2                2   
        JPN-5/id-252      dcd B.2.2.3.1      16OCT2020        Yes        No                  1                2   
                          dcd C.2.1.2.1      16OCT2020        No         Yes                 2                3   
                          dcd D.1.1.1.1      16OCT2020        Yes        Yes                 5                6   
                          dcd D.1.1.4.2      16OCT2020        No         No                  3                2   
        JPN-5/id-326      dcd B.2.1.2.1      03NOV2019        No         No                  3                2   
                          dcd B.2.1.2.1      03NOV2019        No         No                  3                2   
                          dcd D.2.1.5.3      03NOV2019        No         Yes                 1                3   
                          dcd B.2.1.2.1      03NOV2019        No         No                  3                3   
                          dcd B.2.1.2.1      03NOV2019        No         No                  3                5   
                          dcd B.1.1.1.1      03NOV2019        Yes        Yes                 5                6   
                          dcd C.2.1.2.1      03NOV2019        No         Yes                 2                6   
                          dcd A.1.1.1.1      03NOV2019        No         No                  1                2   
        JPN-6/id-260      dcd B.2.2.3.1      06JAN2021        Yes        No                  1                7   
        NGA-1/id-172      dcd B.2.2.3.1      06MAR2020        Yes        No                  1                2   
                          dcd D.2.1.5.3      06MAR2020        No         Yes                 1                3   
                          dcd D.2.1.5.3      06MAR2020        No         Yes                 1                3   
        NGA-1/id-198      dcd A.1.1.1.1      26DEC2019        No         No                  1                6   
                          dcd A.1.1.1.2      26DEC2019        Yes        No                  2                2   
                          dcd C.2.1.2.1      26DEC2019        No         Yes                 2                2   
                          dcd C.1.1.1.3      26DEC2019        No         Yes                 4                2   
                          dcd A.1.1.1.2      26DEC2019        Yes        No                  2                2   
                          dcd D.1.1.4.2      26DEC2019        No         No                  3                2   
                          dcd D.1.1.4.2      26DEC2019        No         No                  3                6   
                          dcd B.1.1.1.1      26DEC2019        Yes        Yes                 5                6   
                          dcd B.2.2.3.1      26DEC2019        Yes        No                  1                3   
                          dcd D.1.1.4.2      26DEC2019        No         No                  3                2   
        NGA-1/id-325      dcd B.2.1.2.1      08SEP2019        No         No                  3                6   
                          dcd D.1.1.1.1      08SEP2019        Yes        Yes                 5                6   
                          dcd C.2.1.2.1      08SEP2019        No         Yes                 2                2   
                          dcd C.1.1.1.3      08SEP2019        No         Yes                 4                2   
                          dcd A.1.1.1.2      08SEP2019        Yes        No                  2                2   
                          dcd D.1.1.4.2      08SEP2019        No         No                  3                2   
                          dcd B.2.1.2.1      08SEP2019        No         No                  3                3   
                          dcd A.1.1.1.2      08SEP2019        Yes        No                  2                2   
                          dcd D.2.1.5.3      08SEP2019        No         Yes                 1                1   
                          dcd C.1.1.1.3      08SEP2019        No         Yes                 4                1   
        NGA-1/id-327      dcd D.2.1.5.3      01JAN2020        No         Yes                 1                3   
                          dcd A.1.1.1.2      01JAN2020        Yes        No                  2                1   
                          dcd B.2.1.2.1      01JAN2020        No         No                  3                5   
                          dcd B.2.2.3.1      01JAN2020        Yes        No                  1                6   
                          dcd A.1.1.1.2      01JAN2020        Yes        No                  2                2   
                          dcd B.2.1.2.1      01JAN2020        No         No                  3                2   
                          dcd C.1.1.1.3      01JAN2020        No         Yes                 4                3   
                          dcd A.1.1.1.2      01JAN2020        Yes        No                  2                2   
        NGA-1/id-357      dcd C.2.1.2.1      21JAN2020        No         Yes                 2                2   
                          dcd D.2.1.5.3      21JAN2020        No         Yes                 1                7   
                          dcd B.1.1.1.1      21JAN2020        Yes        Yes                 5                6   
                          dcd A.1.1.1.2      21JAN2020        Yes        No                  2                2   
                          dcd C.2.1.2.1      21JAN2020        No         Yes                 2                6   
                          dcd B.2.2.3.1      21JAN2020        Yes        No                  1                6   
                          dcd C.1.1.1.3      21JAN2020        No         Yes                 4                2   
                          dcd A.1.1.1.1      21JAN2020        No         No                  1                2   
        NGA-1/id-388      dcd B.1.1.1.1      17MAY2019        Yes        Yes                 5                6   
                          dcd D.1.1.1.1      17MAY2019        Yes        Yes                 5                6   
                          dcd A.1.1.1.2      17MAY2019        Yes        No                  2                3   
                          dcd D.1.1.1.1      17MAY2019        Yes        Yes                 5                6   
                          dcd B.2.1.2.1      17MAY2019        No         No                  3                2   
         NGA-1/id-43      dcd C.2.1.2.1      10SEP2020        No         Yes                 2                7   
                          dcd B.2.2.3.1      10SEP2020        Yes        No                  1                1   
                          dcd A.1.1.1.2      10SEP2020        Yes        No                  2                3   
                          dcd D.2.1.5.3      10SEP2020        No         Yes                 1                2   
                          dcd D.1.1.1.1      10SEP2020        Yes        Yes                 5                6   
         NGA-1/id-46      dcd B.1.1.1.1      01APR2020        Yes        Yes                 5                6   
         NGA-1/id-96      dcd D.2.1.5.3      21JUL2019        No         Yes                 1                2   
                          dcd D.2.1.5.3      21JUL2019        No         Yes                 1                3   
                          dcd B.2.1.2.1      21JUL2019        No         No                  3                5   
                          dcd B.2.1.2.1      21JUL2019        No         No                  3                2   
                          dcd A.1.1.1.1      21JUL2019        No         No                  1                6   
                          dcd D.1.1.1.1      21JUL2019        Yes        Yes                 5                6   
                          dcd D.1.1.1.1      21JUL2019        Yes        Yes                 5                6   
                          dcd D.2.1.5.3      21JUL2019        No         Yes                 1                3   
                          dcd D.1.1.1.1      21JUL2019        Yes        Yes                 5                6   
        NGA-11/id-173     dcd B.1.1.1.1      10MAR2019        Yes        Yes                 5                6   
                          dcd D.1.1.1.1      10MAR2019        Yes        Yes                 5                6   
                          dcd C.2.1.2.1      10MAR2019        No         Yes                 2                3   
                          dcd A.1.1.1.1      10MAR2019        No         No                  1                6   
                          dcd B.2.2.3.1      10MAR2019        Yes        No                  1                2   
                          dcd B.2.2.3.1      10MAR2019        Yes        No                  1                3   
                          dcd B.2.2.3.1      10MAR2019        Yes        No                  1                5   
                          dcd D.1.1.4.2      10MAR2019        No         No                  3                3   
        NGA-11/id-313     dcd B.2.2.3.1      12MAY2019        Yes        No                  1                3   
        NGA-11/id-334     dcd A.1.1.1.1      16JAN2021        No         No                  1                2   
                          dcd B.2.2.3.1      16JAN2021        Yes        No                  1                7   
                          dcd D.2.1.5.3      16JAN2021        No         Yes                 1                3   
                          dcd A.1.1.1.1      16JAN2021        No         No                  1                2   
                          dcd B.1.1.1.1      16JAN2021        Yes        Yes                 5                6   
                          dcd B.1.1.1.1      16JAN2021        Yes        Yes                 5                6   
                          dcd B.1.1.1.1      16JAN2021        Yes        Yes                 5                6   
                          dcd B.2.1.2.1      16JAN2021        No         No                  3                2   
        NGA-11/id-35      dcd D.1.1.1.1      26AUG2019        Yes        Yes                 5                6   
                          dcd C.2.1.2.1      26AUG2019        No         Yes                 2                6   
                          dcd D.1.1.4.2      26AUG2019        No         No                  3                2   
        NGA-11/id-366     dcd B.2.2.3.1      05OCT2020        Yes        No                  1                2   
                          dcd C.1.1.1.3      05OCT2020        No         Yes                 4                2   
                          dcd D.1.1.4.2      05OCT2020        No         No                  3                2   
                          dcd C.1.1.1.3      05OCT2020        No         Yes                 4                3   
                          dcd B.2.2.3.1      05OCT2020        Yes        No                  1                3   
                          dcd B.2.1.2.1      05OCT2020        No         No                  3                2   
                          dcd B.2.1.2.1      05OCT2020        No         No                  3                2   
        NGA-11/id-41      dcd A.1.1.1.2      01AUG2020        Yes        No                  2                2   
                          dcd A.1.1.1.2      01AUG2020        Yes        No                  2                3   
                          dcd D.1.1.1.1      01AUG2020        Yes        Yes                 5                6   
                          dcd A.1.1.1.2      01AUG2020        Yes        No                  2                1   
                          dcd D.2.1.5.3      01AUG2020        No         Yes                 1                2   
                          dcd D.1.1.4.2      01AUG2020        No         No                  3                2   
        NGA-12/id-264     dcd A.1.1.1.2      09APR2020        Yes        No                  2                2   
        NGA-12/id-387     dcd C.2.1.2.1      07JAN2020        No         Yes                 2                2   
                          dcd D.2.1.5.3      07JAN2020        No         Yes                 1                2   
                          dcd C.1.1.1.3      07JAN2020        No         Yes                 4                3   
                          dcd A.1.1.1.1      07JAN2020        No         No                  1                3   
                          dcd D.2.1.5.3      07JAN2020        No         Yes                 1                6   
                          dcd D.1.1.4.2      07JAN2020        No         No                  3                1   
        NGA-17/id-72      dcd A.1.1.1.1      11SEP2019        No         No                  1                2   
                          dcd D.1.1.4.2      11SEP2019        No         No                  3                2   
        NGA-2/id-308      dcd B.2.2.3.1      25SEP2019        Yes        No                  1                6   
                          dcd C.2.1.2.1      25SEP2019        No         Yes                 2                1   
                          dcd B.2.1.2.1      25SEP2019        No         No                  3                2   
                          dcd D.1.1.4.2      25SEP2019        No         No                  3                2   
                          dcd B.1.1.1.1      25SEP2019        Yes        Yes                 5                6   
                          dcd D.2.1.5.3      25SEP2019        No         Yes                 1                7   
        NGA-2/id-353      dcd D.1.1.1.1      02MAR2020        Yes        Yes                 5                6   
        NGA-4/id-215      dcd B.2.2.3.1      19MAY2020        Yes        No                  1                2   
                          dcd C.2.1.2.1      19MAY2020        No         Yes                 2                2   
                          dcd B.2.2.3.1      19MAY2020        Yes        No                  1                3   
                          dcd B.2.1.2.1      19MAY2020        No         No                  3                1   
                          dcd B.1.1.1.1      19MAY2020        Yes        Yes                 5                6   
                          dcd B.1.1.1.1      19MAY2020        Yes        Yes                 5                6   
                          dcd D.2.1.5.3      19MAY2020        No         Yes                 1                2   
                          dcd C.2.1.2.1      19MAY2020        No         Yes                 2                3   
                          dcd B.1.1.1.1      19MAY2020        Yes        Yes                 5                6   
         NGA-4/id-37      dcd D.2.1.5.3      17AUG2020        No         Yes                 1                6   
                          dcd A.1.1.1.1      17AUG2020        No         No                  1                1   
                          dcd C.2.1.2.1      17AUG2020        No         Yes                 2                2   
                          dcd D.2.1.5.3      17AUG2020        No         Yes                 1                2   
         NGA-5/id-99      dcd D.2.1.5.3      04DEC2020        No         Yes                 1                2   
                          dcd A.1.1.1.2      04DEC2020        Yes        No                  2                2   
                          dcd C.1.1.1.3      04DEC2020        No         Yes                 4                7   
                          dcd C.2.1.2.1      04DEC2020        No         Yes                 2                7   
                          dcd C.1.1.1.3      04DEC2020        No         Yes                 4                2   
                          dcd C.1.1.1.3      04DEC2020        No         Yes                 4                2   
        PAK-1/id-112      dcd B.2.2.3.1      26DEC2019        Yes        No                  1                3   
                          dcd C.2.1.2.1      26DEC2019        No         Yes                 2                2   
                          dcd D.1.1.1.1      26DEC2019        Yes        Yes                 5                6   
                          dcd B.2.2.3.1      26DEC2019        Yes        No                  1                2   
        PAK-1/id-125      dcd B.2.2.3.1      11NOV2020        Yes        No                  1                2   
                          dcd D.1.1.1.1      11NOV2020        Yes        Yes                 5                6   
                          dcd A.1.1.1.1      11NOV2020        No         No                  1                2   
                          dcd C.1.1.1.3      11NOV2020        No         Yes                 4                7   
                          dcd C.1.1.1.3      11NOV2020        No         Yes                 4                5   
        PAK-1/id-148      dcd D.1.1.1.1      17JUN2019        Yes        Yes                 5                6   
                          dcd B.1.1.1.1      17JUN2019        Yes        Yes                 5                6   
                          dcd C.2.1.2.1      17JUN2019        No         Yes                 2                3   
                          dcd B.2.2.3.1      17JUN2019        Yes        No                  1                2   
                          dcd D.2.1.5.3      17JUN2019        No         Yes                 1                3   
                          dcd B.2.1.2.1      17JUN2019        No         No                  3                3   
                          dcd A.1.1.1.1      17JUN2019        No         No                  1                5   
                          dcd C.2.1.2.1      17JUN2019        No         Yes                 2                6   
                          dcd B.2.1.2.1      17JUN2019        No         No                  3                2   
        PAK-1/id-169      dcd A.1.1.1.1      15NOV2019        No         No                  1                2   
                          dcd B.2.1.2.1      15NOV2019        No         No                  3                2   
                          dcd C.2.1.2.1      15NOV2019        No         Yes                 2                2   
                          dcd D.1.1.1.1      15NOV2019        Yes        Yes                 5                6   
         PAK-1/id-17      dcd D.2.1.5.3      12JUL2019        No         Yes                 1                2   
                          dcd D.1.1.4.2      12JUL2019        No         No                  3                2   
                          dcd A.1.1.1.1      12JUL2019        No         No                  1                2   
                          dcd B.1.1.1.1      12JUL2019        Yes        Yes                 5                6   
        PAK-1/id-178      dcd A.1.1.1.1      06JUN2019        No         No                  1                2   
                          dcd C.1.1.1.3      06JUN2019        No         Yes                 4                2   
                          dcd C.2.1.2.1      06JUN2019        No         Yes                 2                2   
        PAK-1/id-280      dcd D.1.1.4.2      28MAY2019        No         No                  3                3   
                          dcd A.1.1.1.1      28MAY2019        No         No                  1                2   
                          dcd B.2.1.2.1      28MAY2019        No         No                  3                2   
                          dcd A.1.1.1.2      28MAY2019        Yes        No                  2                1   
                          dcd B.2.1.2.1      28MAY2019        No         No                  3                3   
                          dcd A.1.1.1.2      28MAY2019        Yes        No                  2                7   
                          dcd A.1.1.1.1      28MAY2019        No         No                  1                5   
                          dcd C.1.1.1.3      28MAY2019        No         Yes                 4                3   
         PAK-1/id-39      dcd D.2.1.5.3      05AUG2020        No         Yes                 1                1   
                          dcd C.1.1.1.3      05AUG2020        No         Yes                 4                2   
                          dcd C.1.1.1.3      05AUG2020        No         Yes                 4                2   
         PAK-1/id-79      dcd D.2.1.5.3      22NOV2019        No         Yes                 1                2   
                          dcd B.2.2.3.1      22NOV2019        Yes        No                  1                2   
                          dcd B.1.1.1.1      22NOV2019        Yes        Yes                 5                6   
                          dcd D.1.1.4.2      22NOV2019        No         No                  3                2   
         PAK-1/id-95      dcd B.1.1.1.1      01MAY2019        Yes        Yes                 5                6   
                          dcd D.1.1.1.1      01MAY2019        Yes        Yes                 5                6   
                          dcd B.1.1.1.1      01MAY2019        Yes        Yes                 5                6   
        PAK-11/id-145     dcd C.1.1.1.3      17JAN2020        No         Yes                 4                2   
                          dcd B.2.2.3.1      17JAN2020        Yes        No                  1                2   
                          dcd B.2.1.2.1      17JAN2020        No         No                  3                2   
                          dcd A.1.1.1.2      17JAN2020        Yes        No                  2                7   
                          dcd B.2.2.3.1      17JAN2020        Yes        No                  1                2   
        PAK-11/id-187     dcd D.1.1.1.1      24DEC2019        Yes        Yes                 5                6   
        PAK-11/id-210     dcd A.1.1.1.1      25SEP2019        No         No                  1                1   
        PAK-11/id-268     dcd A.1.1.1.1      21MAR2019        No         No                  1                2   
                          dcd B.2.2.3.1      21MAR2019        Yes        No                  1                3   
                          dcd B.2.1.2.1      21MAR2019        No         No                  3                1   
                          dcd D.1.1.4.2      21MAR2019        No         No                  3                5   
                          dcd B.2.1.2.1      21MAR2019        No         No                  3                2   
                          dcd B.2.1.2.1      21MAR2019        No         No                  3                3   
                          dcd D.1.1.4.2      21MAR2019        No         No                  3                2   
                          dcd D.1.1.4.2      21MAR2019        No         No                  3                6   
        PAK-11/id-330     dcd A.1.1.1.2      15JAN2020        Yes        No                  2                2   
                          dcd D.1.1.4.2      15JAN2020        No         No                  3                7   
                          dcd C.1.1.1.3      15JAN2020        No         Yes                 4                6   
        PAK-11/id-49      dcd D.2.1.5.3      25DEC2019        No         Yes                 1                5   
                          dcd D.1.1.4.2      25DEC2019        No         No                  3                2   
                          dcd D.1.1.4.2      25DEC2019        No         No                  3                2   
                          dcd B.2.1.2.1      25DEC2019        No         No                  3                2   
                          dcd A.1.1.1.1      25DEC2019        No         No                  1                6   
                          dcd D.2.1.5.3      25DEC2019        No         Yes                 1                5   
                          dcd D.1.1.4.2      25DEC2019        No         No                  3                1   
        PAK-11/id-68      dcd A.1.1.1.2      03JUN2019        Yes        No                  2                3   
                          dcd D.2.1.5.3      03JUN2019        No         Yes                 1                3   
        PAK-11/id-87      dcd A.1.1.1.2      21JUL2019        Yes        No                  2                1   
                          dcd C.1.1.1.3      21JUL2019        No         Yes                 4                7   
                          dcd B.2.1.2.1      21JUL2019        No         No                  3                4   
                          dcd B.2.1.2.1      21JUL2019        No         No                  3                2   
                          dcd A.1.1.1.2      21JUL2019        Yes        No                  2                6   
                          dcd C.2.1.2.1      21JUL2019        No         Yes                 2                2   
                          dcd B.2.1.2.1      21JUL2019        No         No                  3                5   
                          dcd C.2.1.2.1      21JUL2019        No         Yes                 2                6   
                          dcd A.1.1.1.2      21JUL2019        Yes        No                  2                2   
                          dcd D.2.1.5.3      21JUL2019        No         Yes                 1                2   
        PAK-12/id-328     dcd D.1.1.1.1      10SEP2019        Yes        Yes                 5                6   
                          dcd B.2.1.2.1      10SEP2019        No         No                  3                2   
                          dcd A.1.1.1.2      10SEP2019        Yes        No                  2                2   
                          dcd D.1.1.4.2      10SEP2019        No         No                  3                2   
                          dcd A.1.1.1.1      10SEP2019        No         No                  1                2   
                          dcd C.2.1.2.1      10SEP2019        No         Yes                 2                2   
                          dcd A.1.1.1.1      10SEP2019        No         No                  1                2   
                          dcd D.1.1.4.2      10SEP2019        No         No                  3                6   
                          dcd B.2.1.2.1      10SEP2019        No         No                  3                2   
        PAK-13/id-251     dcd B.1.1.1.1      19MAR2020        Yes        Yes                 5                6   
        PAK-13/id-350     dcd D.1.1.4.2      24NOV2020        No         No                  3                1   
                          dcd C.2.1.2.1      24NOV2020        No         Yes                 2                7   
                          dcd D.1.1.4.2      24NOV2020        No         No                  3                3   
                          dcd A.1.1.1.1      24NOV2020        No         No                  1                2   
                          dcd B.2.2.3.1      24NOV2020        Yes        No                  1                7   
        PAK-14/id-117     dcd A.1.1.1.2      15JUL2019        Yes        No                  2                2   
                          dcd B.2.2.3.1      15JUL2019        Yes        No                  1                2   
                          dcd D.1.1.4.2      15JUL2019        No         No                  3                2   
        PAK-15/id-314     dcd D.1.1.4.2      17SEP2019        No         No                  3                1   
                          dcd B.2.2.3.1      17SEP2019        Yes        No                  1                3   
                          dcd C.2.1.2.1      17SEP2019        No         Yes                 2                3   
                          dcd B.2.2.3.1      17SEP2019        Yes        No                  1                2   
                          dcd B.2.2.3.1      17SEP2019        Yes        No                  1                2   
                          dcd B.2.1.2.1      17SEP2019        No         No                  3                1   
                          dcd C.2.1.2.1      17SEP2019        No         Yes                 2                2   
                          dcd D.1.1.4.2      17SEP2019        No         No                  3                2   
        PAK-2/id-188      dcd D.2.1.5.3      12MAR2020        No         Yes                 1                2   
                          dcd D.2.1.5.3      12MAR2020        No         Yes                 1                2   
                          dcd B.2.2.3.1      12MAR2020        Yes        No                  1                2   
                          dcd A.1.1.1.2      12MAR2020        Yes        No                  2                2   
                          dcd A.1.1.1.2      12MAR2020        Yes        No                  2                2   
                          dcd A.1.1.1.2      12MAR2020        Yes        No                  2                3   
                          dcd A.1.1.1.1      12MAR2020        No         No                  1                2   
                          dcd D.1.1.1.1      12MAR2020        Yes        Yes                 5                6   
                          dcd D.1.1.1.1      12MAR2020        Yes        Yes                 5                6   
                          dcd D.1.1.1.1      12MAR2020        Yes        Yes                 5                6   
        PAK-2/id-191      dcd D.1.1.1.1      07APR2019        Yes        Yes                 5                6   
                          dcd D.1.1.1.1      07APR2019        Yes        Yes                 5                6   
                          dcd B.1.1.1.1      07APR2019        Yes        Yes                 5                6   
                          dcd A.1.1.1.2      07APR2019        Yes        No                  2                5   
                          dcd B.1.1.1.1      07APR2019        Yes        Yes                 5                6   
                          dcd B.2.2.3.1      07APR2019        Yes        No                  1                2   
        PAK-2/id-213      dcd C.2.1.2.1      16JAN2020        No         Yes                 2                3   
                          dcd A.1.1.1.2      16JAN2020        Yes        No                  2                2   
         PAK-5/id-20      dcd D.1.1.4.2      21SEP2020        No         No                  3                2   
                          dcd D.1.1.1.1      21SEP2020        Yes        Yes                 5                6   
                          dcd D.1.1.4.2      21SEP2020        No         No                  3                3   
                          dcd C.2.1.2.1      21SEP2020        No         Yes                 2                3   
                          dcd D.1.1.4.2      21SEP2020        No         No                  3                2   
                          dcd B.2.2.3.1      21SEP2020        Yes        No                  1                5   
                          dcd A.1.1.1.1      21SEP2020        No         No                  1                2   
                          dcd D.2.1.5.3      21SEP2020        No         Yes                 1                2   
                          dcd C.2.1.2.1      21SEP2020        No         Yes                 2                1   
         RUS-1/id-52      dcd B.2.2.3.1      18MAR2019        Yes        No                  1                2   
                          dcd B.1.1.1.1      18MAR2019        Yes        Yes                 5                6   
                          dcd C.2.1.2.1      18MAR2019        No         Yes                 2                3   
        RUS-11/id-162     dcd D.1.1.4.2      30MAR2020        No         No                  3                3   
                          dcd A.1.1.1.2      30MAR2020        Yes        No                  2                2   
                          dcd A.1.1.1.2      30MAR2020        Yes        No                  2                3   
        RUS-11/id-283     dcd A.1.1.1.1      23JUL2020        No         No                  1                2   
                          dcd A.1.1.1.1      23JUL2020        No         No                  1                2   
                          dcd A.1.1.1.1      23JUL2020        No         No                  1                1   
                          dcd B.2.2.3.1      23JUL2020        Yes        No                  1                2   
                          dcd C.2.1.2.1      23JUL2020        No         Yes                 2                1   
        RUS-11/id-76      dcd D.2.1.5.3      11AUG2019        No         Yes                 1                2   
                          dcd D.1.1.4.2      11AUG2019        No         No                  3                1   
                          dcd C.1.1.1.3      11AUG2019        No         Yes                 4                6   
                          dcd A.1.1.1.1      11AUG2019        No         No                  1                1   
                          dcd D.2.1.5.3      11AUG2019        No         Yes                 1                2   
                          dcd C.1.1.1.3      11AUG2019        No         Yes                 4                2   
                          dcd A.1.1.1.2      11AUG2019        Yes        No                  2                2   
                          dcd A.1.1.1.2      11AUG2019        Yes        No                  2                2   
                          dcd A.1.1.1.1      11AUG2019        No         No                  1                2   
        RUS-11/id-94      dcd C.2.1.2.1      23AUG2019        No         Yes                 2                2   
                          dcd C.1.1.1.3      23AUG2019        No         Yes                 4                2   
        RUS-13/id-70      dcd D.1.1.4.2      15APR2019        No         No                  3                7   
                          dcd B.1.1.1.1      15APR2019        Yes        Yes                 5                6   
                          dcd B.1.1.1.1      15APR2019        Yes        Yes                 5                6   
        RUS-14/id-183     dcd D.2.1.5.3      27AUG2019        No         Yes                 1                3   
                          dcd B.2.1.2.1      27AUG2019        No         No                  3                1   
                          dcd A.1.1.1.2      27AUG2019        Yes        No                  2                2   
        RUS-16/id-165     dcd B.2.2.3.1      06JUL2020        Yes        No                  1                4   
                          dcd D.1.1.4.2      06JUL2020        No         No                  3                2   
         RUS-16/id-4      dcd A.1.1.1.1      28MAR2020        No         No                  1                6   
                          dcd D.1.1.4.2      28MAR2020        No         No                  3                7   
                          dcd A.1.1.1.2      28MAR2020        Yes        No                  2                3   
                          dcd A.1.1.1.2      28MAR2020        Yes        No                  2                3   
                          dcd C.2.1.2.1      28MAR2020        No         Yes                 2                4   
                          dcd B.2.1.2.1      28MAR2020        No         No                  3                2   
                          dcd D.1.1.4.2      28MAR2020        No         No                  3                2   
                          dcd A.1.1.1.1      28MAR2020        No         No                  1                1   
                          dcd B.2.1.2.1      28MAR2020        No         No                  3                2   
        RUS-18/id-359     dcd A.1.1.1.1      08JUN2019        No         No                  1                2   
        RUS-2/id-176      dcd A.1.1.1.2      12APR2020        Yes        No                  2                2   
                          dcd C.1.1.1.3      12APR2020        No         Yes                 4                5   
                          dcd C.1.1.1.3      12APR2020        No         Yes                 4                2   
                          dcd A.1.1.1.1      12APR2020        No         No                  1                2   
                          dcd C.1.1.1.3      12APR2020        No         Yes                 4                3   
                          dcd D.2.1.5.3      12APR2020        No         Yes                 1                2   
                          dcd A.1.1.1.2      12APR2020        Yes        No                  2                2   
                          dcd B.2.1.2.1      12APR2020        No         No                  3                2   
                          dcd B.2.1.2.1      12APR2020        No         No                  3                2   
        RUS-3/id-378      dcd D.1.1.1.1      28FEB2019        Yes        Yes                 5                6   
                          dcd D.2.1.5.3      28FEB2019        No         Yes                 1                6   
                          dcd D.1.1.1.1      28FEB2019        Yes        Yes                 5                6   
                          dcd B.2.2.3.1      28FEB2019        Yes        No                  1                7   
        RUS-4/id-150      dcd C.1.1.1.3      09MAR2020        No         Yes                 4                2   
                          dcd A.1.1.1.1      09MAR2020        No         No                  1                2   
                          dcd C.2.1.2.1      09MAR2020        No         Yes                 2                2   
                          dcd B.2.1.2.1      09MAR2020        No         No                  3                3   
                          dcd A.1.1.1.1      09MAR2020        No         No                  1                2   
                          dcd D.1.1.4.2      09MAR2020        No         No                  3                7   
        RUS-4/id-180      dcd D.1.1.4.2      21JUN2019        No         No                  3                2   
                          dcd D.1.1.4.2      21JUN2019        No         No                  3                6   
                          dcd D.2.1.5.3      21JUN2019        No         Yes                 1                6   
                          dcd D.2.1.5.3      21JUN2019        No         Yes                 1                5   
         RUS-4/id-6       dcd B.1.1.1.1      03APR2019        Yes        Yes                 5                6   
                          dcd B.1.1.1.1      03APR2019        Yes        Yes                 5                6   
                          dcd C.1.1.1.3      03APR2019        No         Yes                 4                2   
                          dcd A.1.1.1.1      03APR2019        No         No                  1                5   
                          dcd B.2.2.3.1      03APR2019        Yes        No                  1                2   
                          dcd A.1.1.1.1      03APR2019        No         No                  1                2   
                          dcd C.1.1.1.3      03APR2019        No         Yes                 4                2   
                          dcd C.1.1.1.3      03APR2019        No         Yes                 4                2   
         RUS-5/id-29      dcd D.2.1.5.3      08DEC2020        No         Yes                 1                2   
                          dcd B.1.1.1.1      08DEC2020        Yes        Yes                 5                6   
                          dcd B.2.2.3.1      08DEC2020        Yes        No                  1                2   
                          dcd B.2.1.2.1      08DEC2020        No         No                  3                2   
                          dcd D.1.1.4.2      08DEC2020        No         No                  3                2   
                          dcd D.1.1.4.2      08DEC2020        No         No                  3                2   
                          dcd A.1.1.1.2      08DEC2020        Yes        No                  2                2   
         RUS-6/id-77      dcd B.2.2.3.1      24NOV2020        Yes        No                  1                2   
                          dcd C.2.1.2.1      24NOV2020        No         Yes                 2                2   
                          dcd B.1.1.1.1      24NOV2020        Yes        Yes                 5                6   
                          dcd D.2.1.5.3      24NOV2020        No         Yes                 1                2   
                          dcd C.1.1.1.3      24NOV2020        No         Yes                 4                5   
                          dcd A.1.1.1.1      24NOV2020        No         No                  1                2   
                          dcd B.2.2.3.1      24NOV2020        Yes        No                  1                6   
                          dcd C.2.1.2.1      24NOV2020        No         Yes                 2                2   
                          dcd D.1.1.4.2      24NOV2020        No         No                  3                3   
        RUS-7/id-243      dcd D.2.1.5.3      23JAN2021        No         Yes                 1                2   
                          dcd C.2.1.2.1      23JAN2021        No         Yes                 2                2   
                          dcd A.1.1.1.1      23JAN2021        No         No                  1                6   
                          dcd B.2.2.3.1      23JAN2021        Yes        No                  1                3   
                          dcd D.1.1.1.1      23JAN2021        Yes        Yes                 5                6   
                          dcd A.1.1.1.1      23JAN2021        No         No                  1                1   
                          dcd B.1.1.1.1      23JAN2021        Yes        Yes                 5                6   
                          dcd D.2.1.5.3      23JAN2021        No         Yes                 1                3   
                          dcd D.1.1.1.1      23JAN2021        Yes        Yes                 5                6   
                          dcd D.1.1.4.2      23JAN2021        No         No                  3                3   
        USA-1/id-137      dcd D.1.1.1.1      03MAY2019        Yes        Yes                 5                6   
        USA-1/id-138      dcd B.2.1.2.1      15AUG2020        No         No                  3                6   
                          dcd B.1.1.1.1      15AUG2020        Yes        Yes                 5                6   
                          dcd D.2.1.5.3      15AUG2020        No         Yes                 1                1   
                          dcd D.2.1.5.3      15AUG2020        No         Yes                 1                1   
                          dcd B.2.1.2.1      15AUG2020        No         No                  3                6   
                          dcd D.1.1.4.2      15AUG2020        No         No                  3                5   
                          dcd B.2.2.3.1      15AUG2020        Yes        No                  1                3   
                          dcd C.2.1.2.1      15AUG2020        No         Yes                 2                2   
        USA-1/id-207      dcd B.2.1.2.1      14JAN2021        No         No                  3                1   
        USA-1/id-242      dcd D.2.1.5.3      27APR2019        No         Yes                 1                2   
                          dcd B.2.1.2.1      27APR2019        No         No                  3                3   
                          dcd B.1.1.1.1      27APR2019        Yes        Yes                 5                6   
                          dcd B.2.1.2.1      27APR2019        No         No                  3                2   
                          dcd D.1.1.4.2      27APR2019        No         No                  3                2   
                          dcd D.1.1.1.1      27APR2019        Yes        Yes                 5                6   
                          dcd D.1.1.4.2      27APR2019        No         No                  3                1   
                          dcd C.2.1.2.1      27APR2019        No         Yes                 2                1   
                          dcd C.2.1.2.1      27APR2019        No         Yes                 2                3   
        USA-1/id-254      dcd B.2.2.3.1      15SEP2020        Yes        No                  1                6   
                          dcd D.1.1.1.1      15SEP2020        Yes        Yes                 5                6   
                          dcd D.1.1.4.2      15SEP2020        No         No                  3                2   
                          dcd A.1.1.1.1      15SEP2020        No         No                  1                2   
                          dcd C.1.1.1.3      15SEP2020        No         Yes                 4                3   
                          dcd D.1.1.1.1      15SEP2020        Yes        Yes                 5                6   
                          dcd D.1.1.4.2      15SEP2020        No         No                  3                2   
                          dcd B.2.2.3.1      15SEP2020        Yes        No                  1                2   
                          dcd D.2.1.5.3      15SEP2020        No         Yes                 1                2   
                          dcd C.1.1.1.3      15SEP2020        No         Yes                 4                6   
        USA-1/id-261      dcd D.1.1.4.2      06MAR2019        No         No                  3                2   
                          dcd D.1.1.1.1      06MAR2019        Yes        Yes                 5                6   
                          dcd A.1.1.1.2      06MAR2019        Yes        No                  2                6   
                          dcd C.2.1.2.1      06MAR2019        No         Yes                 2                1   
                          dcd C.1.1.1.3      06MAR2019        No         Yes                 4                4   
                          dcd B.2.2.3.1      06MAR2019        Yes        No                  1                3   
                          dcd D.1.1.1.1      06MAR2019        Yes        Yes                 5                6   
                          dcd C.1.1.1.3      06MAR2019        No         Yes                 4                3   
        USA-1/id-269      dcd D.2.1.5.3      17MAY2019        No         Yes                 1                5   
                          dcd B.1.1.1.1      17MAY2019        Yes        Yes                 5                6   
                          dcd B.2.2.3.1      17MAY2019        Yes        No                  1                3   
                          dcd A.1.1.1.2      17MAY2019        Yes        No                  2                2   
                          dcd B.2.1.2.1      17MAY2019        No         No                  3                2   
        USA-1/id-295      dcd D.1.1.1.1      09AUG2019        Yes        Yes                 5                6   
                          dcd A.1.1.1.2      09AUG2019        Yes        No                  2                6   
                          dcd B.2.2.3.1      09AUG2019        Yes        No                  1                3   
                          dcd C.2.1.2.1      09AUG2019        No         Yes                 2                1   
        USA-1/id-394      dcd A.1.1.1.1      18DEC2019        No         No                  1                7   
                          dcd A.1.1.1.1      18DEC2019        No         No                  1                2   
                          dcd B.1.1.1.1      18DEC2019        Yes        Yes                 5                6   
                          dcd A.1.1.1.2      18DEC2019        Yes        No                  2                2   
                          dcd A.1.1.1.2      18DEC2019        Yes        No                  2                2   
                          dcd B.1.1.1.1      18DEC2019        Yes        Yes                 5                6   
                          dcd A.1.1.1.1      18DEC2019        No         No                  1                2   
                          dcd A.1.1.1.1      18DEC2019        No         No                  1                2   
         USA-1/id-45      dcd D.1.1.4.2      06MAR2019        No         No                  3                2   
                          dcd B.2.2.3.1      06MAR2019        Yes        No                  1                1   
                          dcd C.1.1.1.3      06MAR2019        No         Yes                 4                2   
                          dcd C.2.1.2.1      06MAR2019        No         Yes                 2                2   
                          dcd A.1.1.1.2      06MAR2019        Yes        No                  2                2   
        USA-11/id-100     dcd A.1.1.1.1      10MAR2020        No         No                  1                5   
                          dcd B.2.1.2.1      10MAR2020        No         No                  3                2   
                          dcd A.1.1.1.1      10MAR2020        No         No                  1                5   
        USA-11/id-136     dcd D.2.1.5.3      02OCT2019        No         Yes                 1                2   
                          dcd A.1.1.1.2      02OCT2019        Yes        No                  2                2   
                          dcd C.1.1.1.3      02OCT2019        No         Yes                 4                6   
        USA-11/id-157     dcd B.1.1.1.1      14JUN2020        Yes        Yes                 5                6   
                          dcd B.2.2.3.1      14JUN2020        Yes        No                  1                6   
                          dcd B.2.2.3.1      14JUN2020        Yes        No                  1                2   
                          dcd D.1.1.4.2      14JUN2020        No         No                  3                2   
                          dcd D.1.1.1.1      14JUN2020        Yes        Yes                 5                6   
                          dcd D.2.1.5.3      14JUN2020        No         Yes                 1                6   
                          dcd B.2.2.3.1      14JUN2020        Yes        No                  1                2   
                          dcd A.1.1.1.2      14JUN2020        Yes        No                  2                6   
        USA-11/id-203     dcd B.2.2.3.1      29DEC2019        Yes        No                  1                7   
                          dcd A.1.1.1.2      29DEC2019        Yes        No                  2                2   
                          dcd C.2.1.2.1      29DEC2019        No         Yes                 2                1   
        USA-11/id-224     dcd C.2.1.2.1      17NOV2020        No         Yes                 2                3   
        USA-11/id-238     dcd D.1.1.4.2      17DEC2019        No         No                  3                6   
        USA-11/id-32      dcd A.1.1.1.1      13MAR2020        No         No                  1                5   
                          dcd D.1.1.1.1      13MAR2020        Yes        Yes                 5                6   
                          dcd B.2.1.2.1      13MAR2020        No         No                  3                7   
                          dcd B.2.1.2.1      13MAR2020        No         No                  3                6   
                          dcd C.1.1.1.3      13MAR2020        No         Yes                 4                6   
                          dcd D.2.1.5.3      13MAR2020        No         Yes                 1                5   
                          dcd B.2.1.2.1      13MAR2020        No         No                  3                5   
                          dcd B.1.1.1.1      13MAR2020        Yes        Yes                 5                6   
        USA-11/id-339     dcd A.1.1.1.2      19OCT2019        Yes        No                  2                1   
                          dcd B.1.1.1.1      19OCT2019        Yes        Yes                 5                6   
                          dcd A.1.1.1.2      19OCT2019        Yes        No                  2                2   
                          dcd D.1.1.4.2      19OCT2019        No         No                  3                6   
                          dcd A.1.1.1.2      19OCT2019        Yes        No                  2                3   
                          dcd D.1.1.4.2      19OCT2019        No         No                  3                6   
                          dcd C.1.1.1.3      19OCT2019        No         Yes                 4                5   
                          dcd D.1.1.1.1      19OCT2019        Yes        Yes                 5                6   
        USA-11/id-365     dcd B.2.2.3.1      09JUN2019        Yes        No                  1                1   
                          dcd B.2.2.3.1      09JUN2019        Yes        No                  1                3   
                          dcd B.2.2.3.1      09JUN2019        Yes        No                  1                2   
                          dcd A.1.1.1.1      09JUN2019        No         No                  1                3   
                          dcd D.2.1.5.3      09JUN2019        No         Yes                 1                2   
                          dcd D.1.1.4.2      09JUN2019        No         No                  3                3   
                          dcd B.2.1.2.1      09JUN2019        No         No                  3                5   
                          dcd C.2.1.2.1      09JUN2019        No         Yes                 2                6   
                          dcd A.1.1.1.2      09JUN2019        Yes        No                  2                7   
                          dcd A.1.1.1.1      09JUN2019        No         No                  1                5   
        USA-12/id-140     dcd D.2.1.5.3      05JUL2020        No         Yes                 1                2   
                          dcd B.2.2.3.1      05JUL2020        Yes        No                  1                3   
                          dcd D.1.1.1.1      05JUL2020        Yes        Yes                 5                6   
                          dcd C.2.1.2.1      05JUL2020        No         Yes                 2                2   
                          dcd A.1.1.1.2      05JUL2020        Yes        No                  2                2   
                          dcd D.1.1.4.2      05JUL2020        No         No                  3                2   
        USA-12/id-152     dcd A.1.1.1.1      17AUG2020        No         No                  1                3   
                          dcd B.2.2.3.1      17AUG2020        Yes        No                  1                3   
                          dcd A.1.1.1.1      17AUG2020        No         No                  1                2   
                          dcd C.1.1.1.3      17AUG2020        No         Yes                 4                1   
                          dcd C.1.1.1.3      17AUG2020        No         Yes                 4                6   
                          dcd C.2.1.2.1      17AUG2020        No         Yes                 2                2   
                          dcd D.1.1.1.1      17AUG2020        Yes        Yes                 5                6   
                          dcd D.2.1.5.3      17AUG2020        No         Yes                 1                3   
        USA-12/id-226     dcd B.2.2.3.1      29JAN2020        Yes        No                  1                3   
                          dcd D.2.1.5.3      29JAN2020        No         Yes                 1                2   
                          dcd B.1.1.1.1      29JAN2020        Yes        Yes                 5                6   
                          dcd B.1.1.1.1      29JAN2020        Yes        Yes                 5                6   
                          dcd D.1.1.4.2      29JAN2020        No         No                  3                2   
                          dcd B.2.2.3.1      29JAN2020        Yes        No                  1                2   
                          dcd B.2.1.2.1      29JAN2020        No         No                  3                3   
                          dcd D.1.1.1.1      29JAN2020        Yes        Yes                 5                6   
        USA-12/id-343     dcd B.2.1.2.1      18MAR2020        No         No                  3                3   
                          dcd B.2.2.3.1      18MAR2020        Yes        No                  1                5   
                          dcd C.1.1.1.3      18MAR2020        No         Yes                 4                5   
                          dcd A.1.1.1.1      18MAR2020        No         No                  1                4   
                          dcd A.1.1.1.1      18MAR2020        No         No                  1                2   
                          dcd C.1.1.1.3      18MAR2020        No         Yes                 4                6   
                          dcd B.2.2.3.1      18MAR2020        Yes        No                  1                1   
                          dcd B.2.1.2.1      18MAR2020        No         No                  3                3   
        USA-12/id-44      dcd C.1.1.1.3      28APR2019        No         Yes                 4                3   
                          dcd D.1.1.4.2      28APR2019        No         No                  3                6   
        USA-14/id-196     dcd B.2.2.3.1      25JAN2020        Yes        No                  1                2   
                          dcd D.2.1.5.3      25JAN2020        No         Yes                 1                3   
                          dcd B.2.1.2.1      25JAN2020        No         No                  3                7   
        USA-15/id-127     dcd D.2.1.5.3      12MAY2019        No         Yes                 1                2   
                          dcd B.2.2.3.1      12MAY2019        Yes        No                  1                3   
                          dcd B.2.1.2.1      12MAY2019        No         No                  3                3   
                          dcd C.2.1.2.1      12MAY2019        No         Yes                 2                2   
                          dcd C.1.1.1.3      12MAY2019        No         Yes                 4                2   
                          dcd B.2.2.3.1      12MAY2019        Yes        No                  1                3   
                          dcd C.1.1.1.3      12MAY2019        No         Yes                 4                3   
        USA-15/id-372     dcd C.2.1.2.1      22JAN2020        No         Yes                 2                2   
        USA-17/id-142     dcd A.1.1.1.2      14MAY2019        Yes        No                  2                2   
                          dcd B.2.2.3.1      14MAY2019        Yes        No                  1                2   
         USA-17/id-3      dcd A.1.1.1.1      26JAN2020        No         No                  1                2   
                          dcd C.2.1.2.1      26JAN2020        No         Yes                 2                6   
        USA-19/id-58      dcd A.1.1.1.1      31OCT2020        No         No                  1                2   
                          dcd D.1.1.1.1      31OCT2020        Yes        Yes                 5                6   
                          dcd D.1.1.1.1      31OCT2020        Yes        Yes                 5                6   
                          dcd D.1.1.4.2      31OCT2020        No         No                  3                2   
                          dcd B.1.1.1.1      31OCT2020        Yes        Yes                 5                6   
                          dcd B.2.1.2.1      31OCT2020        No         No                  3                7   
                          dcd C.2.1.2.1      31OCT2020        No         Yes                 2                2   
                          dcd B.2.1.2.1      31OCT2020        No         No                  3                6   
        USA-2/id-110      dcd C.1.1.1.3      23JUL2020        No         Yes                 4                3   
                          dcd B.2.1.2.1      23JUL2020        No         No                  3                7   
                          dcd D.2.1.5.3      23JUL2020        No         Yes                 1                2   
                          dcd B.1.1.1.1      23JUL2020        Yes        Yes                 5                6   
                          dcd C.1.1.1.3      23JUL2020        No         Yes                 4                2   
                          dcd C.2.1.2.1      23JUL2020        No         Yes                 2                7   
                          dcd B.2.1.2.1      23JUL2020        No         No                  3                2   
                          dcd D.1.1.4.2      23JUL2020        No         No                  3                3   
        USA-3/id-282      dcd D.1.1.1.1      20JUL2020        Yes        Yes                 5                6   
                          dcd D.1.1.1.1      20JUL2020        Yes        Yes                 5                6   
                          dcd B.2.2.3.1      20JUL2020        Yes        No                  1                2   
                          dcd D.2.1.5.3      20JUL2020        No         Yes                 1                3   
                          dcd A.1.1.1.1      20JUL2020        No         No                  1                1   
                          dcd A.1.1.1.1      20JUL2020        No         No                  1                2   
                          dcd A.1.1.1.1      20JUL2020        No         No                  1                5   
                          dcd B.2.1.2.1      20JUL2020        No         No                  3                2   
                          dcd D.2.1.5.3      20JUL2020        No         Yes                 1                1   
        USA-3/id-320      dcd A.1.1.1.2      29JUL2019        Yes        No                  2                5   
                          dcd D.2.1.5.3      29JUL2019        No         Yes                 1                2   
                          dcd B.2.1.2.1      29JUL2019        No         No                  3                2   
                          dcd A.1.1.1.1      29JUL2019        No         No                  1                7   
        USA-4/id-190      dcd D.2.1.5.3      29OCT2019        No         Yes                 1                2   
                          dcd A.1.1.1.1      29OCT2019        No         No                  1                7   
                          dcd B.2.2.3.1      29OCT2019        Yes        No                  1                2   
                          dcd B.1.1.1.1      29OCT2019        Yes        Yes                 5                6   
                          dcd A.1.1.1.2      29OCT2019        Yes        No                  2                2   
                          dcd A.1.1.1.1      29OCT2019        No         No                  1                2   
        USA-4/id-382      dcd C.2.1.2.1      03SEP2019        No         Yes                 2                2   
                          dcd B.2.1.2.1      03SEP2019        No         No                  3                2   
                          dcd B.2.1.2.1      03SEP2019        No         No                  3                2   
                          dcd A.1.1.1.2      03SEP2019        Yes        No                  2                5   
        USA-5/id-179      dcd A.1.1.1.2      08SEP2020        Yes        No                  2                2   
                          dcd C.2.1.2.1      08SEP2020        No         Yes                 2                2   
                          dcd C.2.1.2.1      08SEP2020        No         Yes                 2                3   
                          dcd B.2.2.3.1      08SEP2020        Yes        No                  1                6   
                          dcd D.1.1.4.2      08SEP2020        No         No                  3                2   
        USA-6/id-151      dcd D.2.1.5.3      11APR2020        No         Yes                 1                2   
        USA-8/id-206      dcd D.1.1.4.2      22JUL2019        No         No                  3                2   
                          dcd D.1.1.1.1      22JUL2019        Yes        Yes                 5                6   
                          dcd C.1.1.1.3      22JUL2019        No         Yes                 4                3   
                          dcd B.2.2.3.1      22JUL2019        Yes        No                  1                2   
                          dcd B.2.1.2.1      22JUL2019        No         No                  3                2   
                          dcd B.2.2.3.1      22JUL2019        Yes        No                  1                1   
                          dcd B.2.2.3.1      22JUL2019        Yes        No                  1                1   
                          dcd C.2.1.2.1      22JUL2019        No         Yes                 2                2   
        USA-9/id-130      dcd D.1.1.1.1      18JUL2020        Yes        Yes                 5                6   
                          dcd D.1.1.4.2      18JUL2020        No         No                  3                2   
                          dcd D.1.1.4.2      18JUL2020        No         No                  3                2   

