% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convo_list_convos.R
\name{bs_list_convos}
\alias{bs_list_convos}
\title{List the conversations (direct message threads) for the authenticated user}
\usage{
bs_list_convos(
  read_state = NULL,
  status = NULL,
  cursor = NULL,
  limit = NULL,
  user = get_bluesky_user(),
  pass = get_bluesky_pass(),
  auth = bs_auth(user, pass),
  clean = TRUE
)
}
\arguments{
\item{read_state}{Character, optional. Filter by read state, one of \code{c('unread')}.
Default: \code{NULL}.}

\item{status}{Character, optional. Filter by conversation status, one of
\code{c('accepted', 'request')}. Default: \code{NULL}.}

\item{cursor}{Character, length 1. A cursor property from a prior response. Default: \code{NULL}.}

\item{limit}{Integer. Number of records to request. If over \code{100}, multiple requests are made.}

\item{user}{Character. User name to log in with. Defaults to \code{get_bluesky_user()}.}

\item{pass}{Character. App password to log in with. Defaults to \code{get_bluesky_pass()}.}

\item{auth}{Authentication information. Defaults to \code{bs_auth(user, pass)}.}

\item{clean}{Logical. Should output be cleaned into a \code{tibble}? Default: \code{TRUE}.}
}
\value{
a \link[tibble:tibble]{tibble::tibble} or a \code{list} if \code{clean = FALSE}
}
\description{
List the conversations (direct message threads) for the authenticated user
}
\section{Lexicon references}{

\href{https://github.com/bluesky-social/atproto/blob/main/lexicons/chat/bsky/convo/listConvos.json}{chat.bsky.convo.listConvos.json (2025-05-16)}
}

\section{Function introduced}{

\code{v0.4.0} (2025-05-16)
}

\examples{
\dontshow{if (has_bluesky_pass() && has_bluesky_user()) withAutoprint(\{ # examplesIf}
bs_list_convos(limit = 5, status = 'accepted')
\dontshow{\}) # examplesIf}
}
\concept{chat}
