% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/temperature.R
\name{temperature}
\alias{temperature}
\alias{temperature.default}
\alias{temperature.data.frame}
\alias{temperature.array}
\alias{temperature.sf}
\title{Temperature indices}
\usage{
temperature(object, ...)

\method{temperature}{default}(object, tmin, ..., timeseries = FALSE)

\method{temperature}{data.frame}(object, day.one, span = NULL, ..., timeseries = FALSE)

\method{temperature}{array}(object, day.one, span = NULL, ..., timeseries = FALSE)

\method{temperature}{sf}(
  object,
  day.one,
  span = NULL,
  ...,
  timeseries = FALSE,
  as.sf = TRUE
)
}
\arguments{
\item{object}{a numeric vector with the maximum temperature, 
or a data.frame with geographical coordinates (lonlat), 
or an object of class \code{sf} with geometry 'POINT' or 'POLYGON', 
or an \code{array} with two dimensions containing the
maximum and minimum temperature, in that order. See details}

\item{...}{additional arguments passed to methods. See details}

\item{tmin}{a numeric vector with the minimum temperature}

\item{timeseries}{logical, \code{FALSE} for a single point time series
observation or \code{TRUE} for a time series based on \var{intervals}}

\item{day.one}{a vector of class \code{Date} or any other object that can be 
coerced to \code{Date} (e.g. integer, character YYYY-MM-DD) for the starting 
day to capture the climate data}

\item{span}{an integer or a vector with integers (optional if \var{last.day} is 
given) for the length of the time series to be captured}

\item{as.sf}{logical, to return an object of class 'sf'}
}
\value{
A dataframe with temperature indices:
\item{maxDT}{maximun day temperature (degree Celsius)}
\item{minDT}{minimum day temperature (degree Celsius)}
\item{maxNT}{maximun night temperature (degree Celsius)}
\item{minNT}{minimum night temperature (degree Celsius) }
\item{DTR}{diurnal temperature range (mean difference between DT 
and NT (degree Celsius)) }
\item{SU}{summer days, number of days with maximum temperature > 
30 (degree Celsius)}
\item{TR}{tropical nights, number of nights with maximum 
temperature > 25 (degree Celsius)}
\item{CFD}{consecutive frosty days, number of days with temperature 
bellow 0 degree Celsius}
\item{WSDI}{maximum warm spell duration, consecutive days with 
temperature > 90th percentile}
\item{CSDI}{maximum cold spell duration, consecutive nights with 
temperature < 10th percentile}
\item{T10p}{the 10th percentile of night tempeture (degree Celsius)}
\item{T90p}{the 90th percentile of day tempeture (degree Celsius)}
}
\description{
Methods to compute temperature indices over a time series
}
\details{
Additional arguments:

\code{intervals}: an integer (no lower than 5), for the days intervals when
 \var{timeseries = TRUE}

\code{last.day}: optional to \var{span}, an object of class \code{Date} or
 any other object that can be coerced to \code{Date} (e.g. integer, character 
 YYYY-MM-DD)  for the last day of the time series. For \code{data.frame}, \code{array} 
 and \code{sf} methods
 
\code{dates}: a character (or Date or numeric) vector for the dates of tmax and tmin
 in the \code{default} method

\code{data.from}: character for the source of remote data. Current remote source 
 is: 'nasapower'

\code{pars}: character vector for the temperature data to be fetched. If 
 \code{data.from} is 'nasapower', the temperature can be adjusted to 2 m, the default,
 c("T2M_MAX", "T2M_MIN") or 10 m c("T10M_MAX", "T10M_MIN") 

\code{days.before}: optional, an integer for the number of days before 
 \var{day.one} to be included in the timespan.


# S3 Methods

The \code{array} method assumes that \var{object} contains climate data available 
 in your R section; this requires an array with two dimensions, 1st dimension 
 contains the day temperature and 2nd dimension the night temperature, 
 see help("temp_dat", package = "climatrends") for an example on input structure.

The \code{data.frame} and the \code{sf} methods assumes that the climate data
 will be fetched from a remote (cloud) source that be adjusted using the argument 
 \var{data.from}.

When \var{timeseries = TRUE}, an id is created, 
 which is the index for the rownames of the inputted \var{object}.
}
\examples{
# the default method
data("innlandet", package = "climatrends")

# a single temporal observation
temperature(innlandet$tmax, innlandet$tmin)

# return as timeseries with 30-day intervals
temperature(innlandet$tmax, 
            innlandet$tmin, 
            dates = innlandet$dates,
            timeseries = TRUE, 
            intervals = 30)

#####################################################

# array method
data("temp_dat", package = "climatrends")

temperature(temp_dat,
            day.one = "2013-10-28",
            span = 12)


}
\references{
Aguilar E., et al. (2005). Journal of Geophysical Research, 
110(D23), D23107. \doi{https://doi.org/10.1029/2005JD006119}
}
\seealso{
Other temperature functions: 
\code{\link{ETo}()},
\code{\link{GDD}()},
\code{\link{crop_sensitive}()}
}
\concept{temperature functions}
