% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/devRate.R
\docType{package}
\name{devRate}
\alias{devRate}
\alias{devRate-package}
\title{devRate: A package to quantify the relationship between development rate and temperature in ectotherms.}
\description{
The devRate package allows quantifying the relationship between development rate and temperature in ectotherm organisms.
}
\section{Citation}{


Please use \code{citation("devRate")} to cite the devRate package and/or
Rebaudo F, Struelens Q, Dangles O. Modelling temperature-dependent development
rate and phenology in arthropods: The devRate package for r. Methods Ecol Evol.
2017;00:1-7. https://doi.org/10.1111/2041-210X.12935.

Author's affiliation: UMR EGCE, Univ. ParisSud, CNRS, IRD, Univ. ParisSaclay, Gif-sur-Yvette, France
}

\section{Overview}{


The devRate package provides three categories of functions:

- to find development rate information about a specific organism (Order, Family, Genus, species): which equations were used and what are the associated parameters (e.g., helpful to estimate starting values for your empirical data sets);

- to relate development rate and temperature; and

- to plot your empirical datasets and the associated fitted model, and/or to plot development curves from the literature.
}

\section{Usage}{


You can use the package:

- to get development rate curves as a function of temperature for a specific organism (hundred of examples from the literature are included in the package);

- to know which equations exists and which are most used in the literature; and

- to relate development rate with temperature from your empirical data, using the equations from the package database.
}

\section{Installation instructions}{


\code{install.packages("devRate")}
}

\section{Documentation}{


The package includes two vignettes (long-form documentation):

- quickUserGuide: Using devRate package to fit development rate models to an empirical dataset

- modelEvaluation: Model evaluation using Shi et al. 2016 study
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/frareb/devRate/}
  \item Report bugs at \url{https://github.com/frareb/devRate/issues}
}

}
\author{
\strong{Maintainer}: Francois Rebaudo \email{francois.rebaudo@ird.fr} (2016-2025)

Authors:
\itemize{
  \item Baptiste Regnier (PhD; 2019-2020)
}

Other contributors:
\itemize{
  \item Camila Benavides (M2 student; 2018) [contributor]
  \item Tanusson Selvarajah (L2 student; 2018) [contributor]
  \item Nicolas Bonnal (M1 student; 2018) [contributor]
  \item Badre Rabhi (L2 student; 2017) [contributor]
  \item Quentin Struelens (VIA; 2016) [contributor]
}

}
