#' @title Simpson's evenness index
#'
#' @description Computes Simpson's evenness index.
#'
#' @param x Vector of dimension S (spicies) with the numbers of observed individuals in each spicy. NA values are allowed. 0 values are converted to NA.
#'
#' @return Simpson's evenness index.
#'
#' @seealso \link{evenness}, \link{simpson_D}
#'
#' @references
#' "Quantifying Diversity through Entropy Decomposition: Insights into Hominin Occupation and Carcass Processing at Qesem cave"
#'
#' @examples
#' data(Qesem_s)
#' simpson_E(Qesem_s$HU)
#'
#' @export
simpson_E <- function(x){
  return(1-simpson_D(x))
}
