% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_json_duckdb.R
\name{read_json_duckdb}
\alias{read_json_duckdb}
\title{Read JSON files using DuckDB}
\usage{
read_json_duckdb(
  path,
  ...,
  prudence = c("thrifty", "lavish", "stingy"),
  options = list()
)
}
\arguments{
\item{path}{Path to files, glob patterns \code{*} and \verb{?} are supported.}

\item{...}{These dots are for future extensions and must be empty.}

\item{prudence}{Memory protection, controls if DuckDB may convert
intermediate results in DuckDB-managed memory to data frames in R memory.
\itemize{
\item \code{"thrifty"}: up to a maximum size of 1 million cells,
\item \code{"lavish"}: regardless of size,
\item \code{"stingy"}: never.
}

The default is \code{"thrifty"} for the ingestion functions,
and may be different for other functions.
See \code{vignette("prudence")} for more information.}

\item{options}{Arguments to the DuckDB \code{read_json} table function.}
}
\description{
\code{read_json_duckdb()} reads a JSON file using DuckDB's \code{read_json()} table function.
}
\examples{
\dontshow{if (identical(Sys.getenv("IN_PKGDOWN"), "TRUE")) withAutoprint(\{ # examplesIf}

# Create and read a simple JSON file
path <- tempfile("duckplyr_test_", fileext = ".json")
writeLines('[{"a": 1, "b": "x"}, {"a": 2, "b": "y"}]', path)

# Reading needs the json extension
db_exec("INSTALL json")
db_exec("LOAD json")
read_json_duckdb(path)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=read_csv_duckdb]{read_csv_duckdb()}}, \code{\link[=read_parquet_duckdb]{read_parquet_duckdb()}}
}
