% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{clear_cache}
\alias{clear_cache}
\title{Manually reset the cache, deleting all currently saved data and starting afresh}
\usage{
clear_cache(..., disable = FALSE)
}
\arguments{
\item{...}{
  Arguments passed on to \code{\link[=set_cache]{set_cache}}
  \describe{
    \item{\code{cache_dir}}{the directory in which the cache is stored. By default, this
is \code{rappdirs::user_cache_dir("R", version = "epidatr")}. The path can be
either relative or absolute. The environmental variable is
\code{EPIDATR_CACHE_DIR}.}
    \item{\code{days}}{the maximum length of time in days to keep any particular cached
call. By default this is \code{1}. The environmental variable is
\code{EPIDATR_CACHE_MAX_AGE_DAYS}.}
    \item{\code{max_size}}{the size of the entire cache, in MB, at which to start
pruning entries. By default this is \code{1024}, or 1GB. The environmental
variable is \code{EPIDATR_CACHE_MAX_SIZE_MB}.}
    \item{\code{logfile}}{where cachem's log of transactions is stored, relative to the
cache directory. By default, it is \code{"logfile.txt"}. The environmental
variable is \code{EPIDATR_CACHE_LOGFILE}.}
    \item{\code{confirm}}{whether to confirm directory creation. default is \code{TRUE};
should only be set in non-interactive scripts}
    \item{\code{startup}}{indicates whether the function is being called on
startup. Affects suppressability of the messages. Default is \code{FALSE}.}
  }}

\item{disable}{instead of setting a new cache, disable caching entirely;
defaults to \code{FALSE}}
}
\value{
\code{\link{NULL}} no return value, all effects are stored in the package
environment
}
\description{
Deletes the current cache and resets a new cache. Deletes local data! If you
are using a session unique cache, the previous settings will be reused. If
you pass in new \code{set_cache} arguments, they will take precedence over the
previous settings.
}
\seealso{
\code{\link{set_cache}} to start a new cache (and general caching info),
\code{\link{disable_cache}} to only disable without deleting, and \code{\link{cache_info}}
}
